/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http.handlers;

import com.questdb.net.http.IOContext;
import com.questdb.net.http.RequestHeaderBuffer;
import com.questdb.net.http.ResponseSink;
import com.questdb.net.http.handlers.AbstractMultipartHandler;
import com.questdb.std.Chars;
import com.questdb.std.LocalValue;
import com.questdb.std.Misc;
import com.questdb.std.Mutable;
import com.questdb.std.Unsafe;
import com.questdb.std.str.ByteSequence;
import com.questdb.std.str.DirectByteCharSequence;
import com.questdb.store.PlainFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class UploadHandler
extends AbstractMultipartHandler {
    private final File path;
    private final LocalValue<UploadContext> lvContext = new LocalValue();

    public UploadHandler(File path) {
        this.path = path;
    }

    @Override
    public void setup(IOContext context) {
        UploadContext h = this.lvContext.get(context);
        if (h == null) {
            this.lvContext.set(context, new UploadContext());
        }
    }

    @Override
    public void setupThread() {
    }

    @Override
    protected void onComplete0(IOContext context) throws IOException {
        ResponseSink sink = context.responseSink();
        sink.status(200, "text/html; charset=utf-8");
        sink.put("OK, got it").put("\r\n");
        sink.flush();
    }

    @Override
    protected void onData(IOContext context, ByteSequence data) {
        UploadContext h = this.lvContext.get(context);
        if (h != null && h.mf != null) {
            PlainFile mf = h.mf;
            int len = data.length();
            long mapAddr = mf.addressOf(h.wptr);
            int mapLen = mf.pageRemaining(h.wptr);
            if (len < mapLen) {
                this.write0(data, 0, mapAddr, len);
                UploadContext uploadContext = h;
                uploadContext.wptr = uploadContext.wptr + (long)len;
            } else {
                int p = 0;
                while (true) {
                    this.write0(data, p, mapAddr, mapLen);
                    UploadContext uploadContext = h;
                    uploadContext.wptr = uploadContext.wptr + (long)mapLen;
                    p += mapLen;
                    if ((len -= mapLen) <= 0) break;
                    mapAddr = mf.addressOf(h.wptr);
                    mapLen = mf.pageRemaining(h.wptr);
                    if (len >= mapLen) continue;
                    mapLen = len;
                }
            }
        }
    }

    @Override
    protected void onPartBegin(IOContext context, RequestHeaderBuffer hb) throws IOException {
        CharSequence file = hb.getContentDispositionFilename();
        if (file != null) {
            try {
                UploadContext h = this.lvContext.get(context);
                h.mf = new PlainFile(new File(this.path, file.toString()), 21, 2);
            }
            catch (IOException ignore) {
                this.sendError(context);
            }
        }
    }

    @Override
    protected void onPartEnd(IOContext context) throws IOException {
        UploadContext h = this.lvContext.get(context);
        if (h != null && h.mf != null) {
            h.mf.compact(h.wptr);
            h.clear();
        }
    }

    private void sendError(IOContext context) throws IOException {
        ResponseSink sink = context.responseSink();
        sink.status(200, "text/html; charset=utf-8");
        sink.put("OOPS").put("\r\n");
        sink.flush();
    }

    private void write0(ByteSequence data, int offset, long addr, int len) {
        if (data instanceof DirectByteCharSequence) {
            Unsafe.getUnsafe().copyMemory(((DirectByteCharSequence)data).getLo() + (long)offset, addr, len);
        } else {
            Chars.strcpy(data, len, addr);
        }
    }

    private static class UploadContext
    implements Mutable,
    Closeable {
        private long wptr = 0L;
        private PlainFile mf;

        private UploadContext() {
        }

        @Override
        public void clear() {
            this.mf = Misc.free(this.mf);
            this.wptr = 0L;
        }

        @Override
        public void close() {
            this.clear();
        }
    }
}

