/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser;

import com.questdb.BootstrapEnv;
import com.questdb.common.ColumnType;
import com.questdb.parser.ImportedColumnMetadata;
import com.questdb.parser.json.JsonException;
import com.questdb.parser.json.JsonParser;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.Chars;
import com.questdb.std.Mutable;
import com.questdb.std.ObjList;
import com.questdb.std.ObjectPool;
import com.questdb.std.Unsafe;
import com.questdb.std.str.AbstractCharSequence;
import com.questdb.std.time.DateFormat;
import com.questdb.std.time.DateFormatFactory;
import com.questdb.std.time.DateLocale;
import com.questdb.std.time.DateLocaleFactory;

public class JsonSchemaParser
implements JsonParser,
Mutable {
    private static final int S_NEED_ARRAY = 1;
    private static final int S_NEED_OBJECT = 2;
    private static final int S_NEED_PROPERTY = 3;
    private static final int P_NAME = 1;
    private static final int P_TYPE = 2;
    private static final int P_PATTERN = 3;
    private static final int P_LOCALE = 4;
    private static final CharSequenceIntHashMap propertyNameMap = new CharSequenceIntHashMap();
    private final ObjectPool<ImportedColumnMetadata> mPool = new ObjectPool<ImportedColumnMetadata>(ImportedColumnMetadata::new, 64);
    private final DateLocaleFactory dateLocaleFactory;
    private final ObjList<ImportedColumnMetadata> metadata = new ObjList();
    private final ObjectPool<FloatingCharSequence> csPool = new ObjectPool<FloatingCharSequence>(() -> new FloatingCharSequence(), 64);
    private final DateFormatFactory dateFormatFactory;
    private int state = 1;
    private CharSequence name;
    private int type = -1;
    private CharSequence pattern;
    private DateFormat dateFormat;
    private DateLocale dateLocale;
    private int propertyIndex;
    private long buf;
    private long bufCapacity = 0L;
    private int bufSize = 0;

    public JsonSchemaParser(BootstrapEnv env) {
        this.dateLocaleFactory = env.dateLocaleFactory;
        this.dateFormatFactory = env.dateFormatFactory;
    }

    @Override
    public void clear() {
        this.bufSize = 0;
        this.state = 1;
        this.metadata.clear();
        this.csPool.clear();
        this.mPool.clear();
        this.clearStage();
    }

    public ObjList<ImportedColumnMetadata> getMetadata() {
        return this.metadata;
    }

    @Override
    public void onEvent(int code, CharSequence tag, int position) throws JsonException {
        block0 : switch (code) {
            case 3: {
                if (this.state != 1) {
                    throw JsonException.with("Unexpected array", position);
                }
                this.state = 2;
                break;
            }
            case 1: {
                if (this.state != 2) {
                    throw JsonException.with("Unexpected object", position);
                }
                this.state = 3;
                break;
            }
            case 5: {
                this.propertyIndex = propertyNameMap.get(tag);
                break;
            }
            case 6: {
                switch (this.propertyIndex) {
                    case 1: {
                        this.name = this.copy(tag);
                        break block0;
                    }
                    case 2: {
                        this.type = ColumnType.columnTypeOf(tag);
                        if (this.type != -1) break block0;
                        throw JsonException.with("Invalid type", position);
                    }
                    case 3: {
                        this.dateFormat = this.dateFormatFactory.get(tag);
                        this.pattern = this.copy(tag);
                        break block0;
                    }
                    case 4: {
                        this.dateLocale = this.dateLocaleFactory.getDateLocale(tag);
                        if (this.dateLocale != null) break block0;
                        throw JsonException.with("Invalid date locale", position);
                    }
                }
                break;
            }
            case 2: {
                this.state = 2;
                this.createImportedType(position);
                break;
            }
            case 7: {
                throw JsonException.with("Must be an object", position);
            }
        }
    }

    private void clearStage() {
        this.name = null;
        this.pattern = null;
        this.type = -1;
        this.dateLocale = null;
        this.dateFormat = null;
    }

    private CharSequence copy(CharSequence tag) {
        int l = tag.length();
        long n = this.bufSize + l;
        if (n >= this.bufCapacity) {
            long ptr = Unsafe.malloc(n * 2L);
            Unsafe.getUnsafe().copyMemory(this.buf, ptr, this.bufSize);
            Unsafe.free(this.buf, this.bufCapacity);
            this.buf = ptr;
            this.bufCapacity = n * 2L;
        }
        Chars.strcpy(tag, l, this.buf + (long)this.bufSize);
        CharSequence cs = this.csPool.next().of(this.bufSize, this.bufSize + l);
        this.bufSize += l;
        return cs;
    }

    private void createImportedType(int position) throws JsonException {
        if (this.name == null) {
            throw JsonException.with("Missing 'name' property", position);
        }
        if (this.type == -1) {
            throw JsonException.with("Missing 'type' property", position);
        }
        ImportedColumnMetadata m = this.mPool.next();
        m.name = this.name;
        m.importedColumnType = this.type;
        m.pattern = this.pattern;
        m.dateFormat = this.dateFormat;
        m.dateLocale = this.dateLocale == null && this.type == 10 ? this.dateLocaleFactory.getDefaultDateLocale() : this.dateLocale;
        this.metadata.add(m);
        this.clearStage();
    }

    static {
        propertyNameMap.put("name", 1);
        propertyNameMap.put("type", 2);
        propertyNameMap.put("pattern", 3);
        propertyNameMap.put("locale", 4);
    }

    private class FloatingCharSequence
    extends AbstractCharSequence
    implements Mutable {
        int lo;
        int hi;

        private FloatingCharSequence() {
        }

        @Override
        public int length() {
            return this.hi - this.lo;
        }

        @Override
        public char charAt(int index) {
            return (char)Unsafe.getUnsafe().getByte(JsonSchemaParser.this.buf + (long)this.lo + (long)index);
        }

        CharSequence of(int lo, int hi) {
            this.lo = lo;
            this.hi = hi;
            return this;
        }

        @Override
        public void clear() {
        }
    }
}

