/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.json;

import com.questdb.parser.json.JsonException;
import com.questdb.parser.json.JsonParser;
import com.questdb.std.Chars;
import com.questdb.std.IntHashSet;
import com.questdb.std.IntStack;
import com.questdb.std.Mutable;
import com.questdb.std.Unsafe;
import com.questdb.std.str.DirectByteCharSequence;
import com.questdb.std.str.SplitByteSequence;
import com.questdb.std.str.StringSink;
import java.io.Closeable;

public class JsonLexer
implements Mutable,
Closeable {
    public static final int EVT_OBJ_START = 1;
    public static final int EVT_OBJ_END = 2;
    public static final int EVT_ARRAY_START = 3;
    public static final int EVT_ARRAY_END = 4;
    public static final int EVT_NAME = 5;
    public static final int EVT_VALUE = 6;
    public static final int EVT_ARRAY_VALUE = 7;
    private static final int S_START = 0;
    private static final int S_EXPECT_NAME = 1;
    private static final int S_EXPECT_FIRST_NAME = 5;
    private static final int S_EXPECT_VALUE = 2;
    private static final int S_EXPECT_COMMA = 3;
    private static final int S_EXPECT_COLON = 4;
    private static final IntHashSet unquotedTerminators = new IntHashSet(256);
    private final IntStack objDepthStack = new IntStack();
    private final IntStack arrayDepthStack = new IntStack();
    private final DirectByteCharSequence dbcs = new DirectByteCharSequence();
    private final DirectByteCharSequence reserveDbcs = new DirectByteCharSequence();
    private final SplitByteSequence splitCs = new SplitByteSequence();
    private final StringSink sink = new StringSink();
    private final int cacheSizeLimit;
    private int state = 0;
    private int objDepth = 0;
    private int arrayDepth = 0;
    private boolean ignoreNext = false;
    private boolean quoted = false;
    private long cache = 0L;
    private int cacheCapacity = 0;
    private int cacheSize = 0;
    private boolean useCache = false;
    private int position = 0;

    public JsonLexer(int cacheSizeLimit) {
        this.cacheSizeLimit = cacheSizeLimit;
    }

    @Override
    public void clear() {
        this.objDepthStack.clear();
        this.arrayDepthStack.clear();
        this.state = 0;
        this.objDepth = 0;
        this.arrayDepth = 0;
        this.ignoreNext = false;
        this.quoted = false;
        this.cacheSize = 0;
        this.useCache = false;
        this.position = 0;
    }

    @Override
    public void close() {
        if (this.cacheCapacity > 0 && this.cache != 0L) {
            Unsafe.free(this.cache, this.cacheCapacity);
        }
    }

    public void parse(long lo, long len, JsonParser listener) throws JsonException {
        if (len <= 0L) {
            return;
        }
        long p = lo;
        long hi = lo + len;
        long valueStart = this.useCache ? lo : 0L;
        int posAtStart = this.position;
        int state = this.state;
        boolean quoted = this.quoted;
        boolean ignoreNext = this.ignoreNext;
        boolean useCache = this.useCache;
        int cacheSize = this.cacheSize;
        int objDepth = this.objDepth;
        int arrayDepth = this.arrayDepth;
        block14: while (p < hi) {
            char c = (char)Unsafe.getUnsafe().getByte(p++);
            if (ignoreNext) {
                ignoreNext = false;
                continue;
            }
            if (valueStart > 0L) {
                if (quoted) {
                    if (c == '\\') {
                        ignoreNext = true;
                        continue;
                    }
                    if (c != '\"') {
                        continue;
                    }
                } else if (JsonLexer.isNotATerminator(c)) continue;
                int vp = (int)((long)posAtStart + valueStart - lo + 1L - (long)cacheSize);
                if (state == 1 || state == 5) {
                    listener.onEvent(5, this.getCharSequence(valueStart, p, cacheSize), vp);
                    state = 4;
                } else {
                    listener.onEvent(arrayDepth > 0 ? 7 : 6, this.getCharSequence(valueStart, p, cacheSize), vp);
                    state = 3;
                }
                valueStart = 0L;
                cacheSize = 0;
                useCache = false;
                if (quoted) continue;
            }
            switch (c) {
                case '{': {
                    if (state != 0 && state != 2) {
                        throw JsonException.with("{ is not expected here", (int)((long)posAtStart + p - lo));
                    }
                    this.arrayDepthStack.push(arrayDepth);
                    arrayDepth = 0;
                    listener.onEvent(1, null, (int)((long)posAtStart + p - lo));
                    ++objDepth;
                    state = 5;
                    continue block14;
                }
                case '}': {
                    if (arrayDepth > 0) {
                        throw JsonException.with("} is not expected here. You have non-terminated array", (int)((long)posAtStart + p - lo));
                    }
                    if (objDepth > 0) {
                        switch (state) {
                            case 2: {
                                throw JsonException.with("Attribute value expected", (int)((long)posAtStart + p - lo - 1L));
                            }
                            case 1: {
                                throw JsonException.with("Attribute name expected", (int)((long)posAtStart + p - lo - 1L));
                            }
                        }
                        listener.onEvent(2, null, (int)((long)posAtStart + p - lo));
                        --objDepth;
                        arrayDepth = this.arrayDepthStack.pop();
                        state = 3;
                        continue block14;
                    }
                    throw JsonException.with("Dangling }", (int)((long)posAtStart + p - lo));
                }
                case '[': {
                    if (state != 0 && state != 2) {
                        throw JsonException.with("[ is not expected here", (int)((long)posAtStart + p - lo));
                    }
                    listener.onEvent(3, null, (int)((long)posAtStart + p - lo));
                    this.objDepthStack.push(objDepth);
                    objDepth = 0;
                    ++arrayDepth;
                    state = 2;
                    continue block14;
                }
                case ']': {
                    if (objDepth > 0) {
                        throw JsonException.with("] is not expected here. You have non-terminated object", (int)((long)posAtStart + p - lo));
                    }
                    if (arrayDepth == 0) {
                        throw JsonException.with("Dangling ]", (int)((long)posAtStart + p - lo));
                    }
                    listener.onEvent(4, null, (int)((long)posAtStart + p - lo));
                    --arrayDepth;
                    objDepth = this.objDepthStack.pop();
                    state = 3;
                    continue block14;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block14;
                }
                case ',': {
                    if (state != 3) {
                        throw JsonException.with("Unexpected comma", (int)((long)posAtStart + p - lo));
                    }
                    if (arrayDepth > 0) {
                        state = 2;
                        continue block14;
                    }
                    state = 1;
                    continue block14;
                }
                case ':': {
                    if (state != 4) {
                        throw JsonException.with("Misplaced ':'", (int)((long)posAtStart + p - lo));
                    }
                    state = 2;
                    continue block14;
                }
                case '\"': {
                    if (state != 1 && state != 5 && state != 2) {
                        throw JsonException.with("Unexpected quote '\"'", (int)((long)posAtStart + p - lo));
                    }
                    valueStart = p;
                    quoted = true;
                    continue block14;
                }
            }
            if (state != 2) {
                throw JsonException.with("Unexpected symbol", (int)((long)posAtStart + p - lo));
            }
            valueStart = p - 1L;
            quoted = false;
        }
        this.position = (int)((long)posAtStart + p - lo);
        this.state = state;
        this.quoted = quoted;
        this.ignoreNext = ignoreNext;
        this.cacheSize = cacheSize;
        this.objDepth = objDepth;
        this.arrayDepth = arrayDepth;
        if (valueStart > 0L) {
            this.cacheIncompleteTag(valueStart, hi);
            useCache = true;
        }
        this.useCache = useCache;
    }

    public void parseLast() throws JsonException {
        if (this.cacheSize > 0) {
            throw JsonException.with("Unterminated string", this.position);
        }
        if (this.arrayDepth > 0) {
            throw JsonException.with("Unterminated array", this.position);
        }
        if (this.objDepth > 0 || this.arrayDepthStack.size() > 0 || this.objDepthStack.size() > 0) {
            throw JsonException.with("Unterminated object", this.position);
        }
    }

    private static boolean isNotATerminator(char c) {
        return !unquotedTerminators.contains(c);
    }

    private void cacheIncompleteTag(long valueStart, long hi) throws JsonException {
        int n = (int)(hi - valueStart) + this.cacheSize;
        if (n > this.cacheCapacity) {
            if (n > this.cacheSizeLimit) {
                throw JsonException.with("String is too long", this.position);
            }
            long ptr = Unsafe.malloc(n);
            if (this.cacheCapacity > 0) {
                Unsafe.getUnsafe().copyMemory(this.cache, ptr, this.cacheSize);
                Unsafe.free(this.cache, this.cacheCapacity);
            }
            this.cacheCapacity = n;
            this.cache = ptr;
        }
        if (n > 0) {
            Unsafe.getUnsafe().copyMemory(valueStart, this.cache + (long)this.cacheSize, n);
            this.cacheSize += n;
        }
    }

    private CharSequence getCharSequence(long lo, long hi, int cacheSize) {
        this.sink.clear();
        if (cacheSize == 0) {
            Chars.utf8Decode(this.dbcs.of(lo, hi - 1L), this.sink);
        } else {
            Chars.utf8Decode(this.splitCs.of(this.reserveDbcs.of(this.cache, this.cache + (long)cacheSize), this.dbcs.of(lo, hi - 1L)), this.sink);
        }
        return this.sink;
    }

    static {
        unquotedTerminators.add(32);
        unquotedTerminators.add(9);
        unquotedTerminators.add(10);
        unquotedTerminators.add(13);
        unquotedTerminators.add(44);
        unquotedTerminators.add(125);
        unquotedTerminators.add(93);
        unquotedTerminators.add(123);
        unquotedTerminators.add(91);
    }
}

