/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.plaintext;

import com.questdb.std.IntList;
import com.questdb.std.IntLongPriorityQueue;
import com.questdb.std.ObjectFactory;
import com.questdb.std.Unsafe;

public class PlainTextDelimiterLexer {
    public static final ObjectFactory<PlainTextDelimiterLexer> FACTORY = PlainTextDelimiterLexer::new;
    private static final int maxLines = 10000;
    private final IntList commas = new IntList(10000);
    private final IntList pipes = new IntList(10000);
    private final IntList tabs = new IntList(10000);
    private final IntList semicolons = new IntList(10000);
    private final IntLongPriorityQueue heap = new IntLongPriorityQueue(4);
    private double stdDev;
    private int avgRecLen;
    private char delimiter;

    private PlainTextDelimiterLexer() {
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public void of(long address, int len) {
        IntList test;
        long lim = address + (long)len;
        long p = address;
        boolean suspended = false;
        int line = 0;
        int comma = 0;
        int pipe = 0;
        int tab = 0;
        int semicolon = 0;
        int _comma = 0;
        int _pipe = 0;
        int _tab = 0;
        int _semicolon = 0;
        this.commas.clear();
        this.pipes.clear();
        this.tabs.clear();
        this.semicolons.clear();
        this.avgRecLen = 0;
        this.stdDev = Double.POSITIVE_INFINITY;
        this.delimiter = '\u0000';
        boolean eol = false;
        block14: while (p < lim && line < 10000) {
            char b = (char)Unsafe.getUnsafe().getByte(p++);
            if (suspended && b != '\"') continue;
            switch (b) {
                case ',': {
                    ++comma;
                    if (!eol) continue block14;
                    eol = false;
                    break;
                }
                case '|': {
                    ++pipe;
                    if (!eol) continue block14;
                    eol = false;
                    break;
                }
                case '\t': {
                    ++tab;
                    if (!eol) continue block14;
                    eol = false;
                    break;
                }
                case ';': {
                    ++semicolon;
                    if (!eol) continue block14;
                    eol = false;
                    break;
                }
                case '\"': {
                    boolean bl = suspended = !suspended;
                    if (!eol) continue block14;
                    eol = false;
                    break;
                }
                case '\n': {
                    if (eol) break;
                    ++line;
                    this.commas.add(comma - _comma);
                    this.pipes.add(pipe - _pipe);
                    this.tabs.add(tab - _tab);
                    this.semicolons.add(semicolon - _semicolon);
                    _comma = comma;
                    _pipe = pipe;
                    _tab = tab;
                    _semicolon = semicolon;
                    eol = true;
                    break;
                }
                default: {
                    if (!eol) continue block14;
                    eol = false;
                }
            }
        }
        if (line == 0) {
            return;
        }
        this.avgRecLen = len / line;
        this.heap.clear();
        this.heap.add(44, comma);
        this.heap.add(124, pipe);
        this.heap.add(9, tab);
        this.heap.add(59, semicolon);
        this.delimiter = (char)this.heap.peekBottom();
        switch (this.delimiter) {
            case ',': {
                test = this.commas;
                break;
            }
            case '|': {
                test = this.pipes;
                break;
            }
            case '\t': {
                test = this.tabs;
                break;
            }
            case ';': {
                test = this.semicolons;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported delimiter: " + this.delimiter);
            }
        }
        int n = test.size();
        if (n == 0) {
            this.delimiter = '\u0000';
            return;
        }
        double temp = 0.0;
        for (int i = 0; i < n; ++i) {
            temp += (double)test.getQuick(i);
        }
        double mean = temp / (double)n;
        temp = 0.0;
        for (int i = 0; i < n; ++i) {
            int v = test.getQuick(i);
            temp += (mean - (double)v) * (mean - (double)v);
        }
        this.stdDev = Math.sqrt(temp / (double)n);
    }

    int getAvgRecLen() {
        return this.avgRecLen;
    }
}

