/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.plaintext;

import com.questdb.BootstrapEnv;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.parser.ImportedColumnMetadata;
import com.questdb.parser.plaintext.MetadataAwareTextParser;
import com.questdb.parser.plaintext.PlainTextMetadataParser;
import com.questdb.parser.plaintext.PlainTextParser;
import com.questdb.std.Mutable;
import com.questdb.std.ObjList;
import com.questdb.std.ObjectPool;
import com.questdb.std.Unsafe;
import com.questdb.std.str.DirectByteCharSequence;
import java.io.Closeable;

public class PlainTextLexer
implements Closeable,
Mutable {
    private static final Log LOG = LogFactory.getLog(PlainTextLexer.class);
    private final ObjList<DirectByteCharSequence> fields = new ObjList();
    private final ObjectPool<DirectByteCharSequence> csPool = new ObjectPool<DirectByteCharSequence>(DirectByteCharSequence.FACTORY, 16);
    private final ObjectPool<ImportedColumnMetadata> mPool = new ObjectPool<ImportedColumnMetadata>(ImportedColumnMetadata::new, 256);
    private final PlainTextMetadataParser mel;
    private final long lineRollBufLimit;
    private boolean ignoreEolOnce;
    private char separator;
    private boolean inQuote;
    private boolean delayedOutQuote;
    private boolean eol;
    private int fieldIndex;
    private long fieldLo;
    private long fieldHi;
    private int lineCount;
    private boolean useLineRollBuf = false;
    private long lineRollBufCur;
    private PlainTextParser plainTextParser;
    private boolean calcFields;
    private long lastLineStart;
    private long lineRollBufLen;
    private long lineRollBufPtr;
    private boolean header;
    private long lastQuotePos = -1L;

    public PlainTextLexer(BootstrapEnv env) {
        this.mel = new PlainTextMetadataParser(this.mPool, env.typeProbeCollection);
        this.lineRollBufLen = env.configuration.getHttpImportInitialTextBuf();
        this.lineRollBufLimit = env.configuration.getHttpImportMaxTextBuf();
        this.lineRollBufPtr = Unsafe.malloc(this.lineRollBufLen);
    }

    public void analyseStructure(long addr, int len, int lineCountLimit, MetadataAwareTextParser ial, boolean forceHeader, ObjList<ImportedColumnMetadata> schema) {
        this.mel.of(schema, forceHeader);
        this.parse(addr, len, lineCountLimit, this.mel);
        this.mel.onLineCount(this.lineCount);
        ial.onMetadata(this.mel.getMetadata(), this.mel.isHeader());
        this.setHeader(this.mel.isHeader());
        this.restart();
    }

    @Override
    public final void clear() {
        this.restart();
        this.fields.clear();
        this.calcFields = true;
        this.csPool.clear();
        this.mPool.clear();
        this.mel.clear();
    }

    @Override
    public void close() {
        if (this.lineRollBufPtr != 0L) {
            Unsafe.free(this.lineRollBufPtr, this.lineRollBufLen);
            this.lineRollBufPtr = 0L;
        }
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public PlainTextLexer of(char separator) {
        this.clear();
        this.separator = separator;
        return this;
    }

    public void parse(long lo, long len, int lineCountLimit, PlainTextParser plainTextParser) {
        this.plainTextParser = plainTextParser;
        this.fieldHi = this.useLineRollBuf ? this.lineRollBufCur : (this.fieldLo = lo);
        this.parse(lo, len, lineCountLimit);
    }

    public void parseLast() {
        if (this.useLineRollBuf) {
            if (this.inQuote) {
                this.plainTextParser.onError(this.lineCount);
            } else {
                ++this.fieldHi;
                this.stashField();
                this.triggerLine(0L);
            }
        }
    }

    public final void restart() {
        this.fieldLo = 0L;
        this.eol = false;
        this.fieldIndex = 0;
        this.inQuote = false;
        this.delayedOutQuote = false;
        this.lineCount = 0;
        this.lineRollBufCur = this.lineRollBufPtr;
        this.useLineRollBuf = false;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    private void calcField() {
        if (this.fields.size() == this.fieldIndex) {
            this.fields.add(this.csPool.next());
        }
    }

    private void growRollBuf(long len) {
        if (len > this.lineRollBufLimit) {
            this.plainTextParser.onError(this.lineCount);
        }
        LOG.info().$("Resizing line roll buffer: ").$(this.lineRollBufLen).$(" -> ").$(len).$();
        long p = Unsafe.malloc(len);
        long l = this.lineRollBufCur - this.lineRollBufPtr;
        if (l > 0L) {
            Unsafe.getUnsafe().copyMemory(this.lineRollBufPtr, p, l);
        }
        Unsafe.free(this.lineRollBufPtr, this.lineRollBufLen);
        this.shift(this.lineRollBufPtr - p);
        this.lineRollBufCur = p + l;
        this.lineRollBufPtr = p;
        this.lineRollBufLen = len;
    }

    private void ignoreEolOnce() {
        this.eol = true;
        this.fieldIndex = 0;
        this.ignoreEolOnce = false;
    }

    private void parse(long lo, long len, int lineCountLimit) {
        long hi = lo + len;
        long ptr = lo;
        block4: while (ptr < hi) {
            byte c = Unsafe.getUnsafe().getByte(ptr++);
            if (this.useLineRollBuf) {
                this.putToRollBuf(c);
            }
            ++this.fieldHi;
            if (this.delayedOutQuote && c != 34) {
                this.delayedOutQuote = false;
                this.inQuote = false;
            }
            if (c == this.separator) {
                if (this.eol) {
                    this.uneol(lo);
                }
                if (this.inQuote || this.ignoreEolOnce) continue;
                this.stashField();
                ++this.fieldIndex;
                continue;
            }
            switch (c) {
                case 34: {
                    this.quote();
                    break;
                }
                case 10: 
                case 13: {
                    if (this.inQuote) break;
                    if (this.eol) {
                        this.fieldLo = this.fieldHi;
                        break;
                    }
                    this.stashField();
                    if (this.ignoreEolOnce) {
                        this.ignoreEolOnce();
                        break;
                    }
                    this.triggerLine(ptr);
                    if (this.lineCount <= lineCountLimit) continue block4;
                    break block4;
                }
                default: {
                    if (!this.eol) continue block4;
                    this.uneol(lo);
                }
            }
        }
        if (this.useLineRollBuf) {
            return;
        }
        if (this.eol) {
            this.fieldLo = 0L;
        } else {
            this.rollLine(lo, hi);
            this.useLineRollBuf = true;
        }
    }

    private void putToRollBuf(byte c) {
        if (this.lineRollBufCur - this.lineRollBufPtr == this.lineRollBufLen) {
            this.growRollBuf(this.lineRollBufLen << 2);
        }
        Unsafe.getUnsafe().putByte(this.lineRollBufCur++, c);
    }

    private void quote() {
        if (this.inQuote) {
            this.delayedOutQuote = !this.delayedOutQuote;
            this.lastQuotePos = this.fieldHi;
        } else if (this.fieldHi - this.fieldLo == 1L) {
            this.inQuote = true;
            this.fieldLo = this.fieldHi;
        }
    }

    private void rollLine(long lo, long hi) {
        long l = hi - lo - this.lastLineStart;
        if (l >= this.lineRollBufLen) {
            this.growRollBuf(l << 2);
        }
        assert (lo + this.lastLineStart + l <= hi);
        Unsafe.getUnsafe().copyMemory(lo + this.lastLineStart, this.lineRollBufPtr, l);
        this.lineRollBufCur = this.lineRollBufPtr + l;
        this.shift(lo + this.lastLineStart - this.lineRollBufPtr);
    }

    private void shift(long d) {
        for (int i = 0; i < this.fieldIndex; ++i) {
            this.fields.getQuick(i).lshift(d);
        }
        this.fieldLo -= d;
        this.fieldHi -= d;
        if (this.lastQuotePos > -1L) {
            this.lastQuotePos -= d;
        }
    }

    private void stashField() {
        if (this.calcFields) {
            this.calcField();
        }
        if (this.fieldIndex >= this.fields.size()) {
            this.plainTextParser.onError(this.lineCount++);
            this.ignoreEolOnce = true;
            this.fieldIndex = 0;
            return;
        }
        DirectByteCharSequence seq = this.fields.getQuick(this.fieldIndex);
        if (this.lastQuotePos > -1L) {
            seq.of(this.fieldLo, this.lastQuotePos - 1L);
            this.lastQuotePos = -1L;
        } else {
            seq.of(this.fieldLo, this.fieldHi - 1L);
        }
        this.fieldLo = this.fieldHi;
    }

    private void triggerLine(long ptr) {
        if (this.calcFields) {
            this.calcFields = false;
            this.plainTextParser.onFieldCount(this.fields.size());
        }
        int hi = this.fieldIndex + 1;
        if (this.header) {
            this.plainTextParser.onHeader(this.fields, hi);
            this.header = false;
            this.fieldIndex = 0;
            this.eol = true;
            return;
        }
        this.plainTextParser.onFields(this.lineCount++, this.fields, hi);
        this.fieldIndex = 0;
        this.eol = true;
        if (this.useLineRollBuf) {
            this.useLineRollBuf = false;
            this.lineRollBufCur = this.lineRollBufPtr;
            this.fieldLo = this.fieldHi = ptr;
        }
    }

    private void uneol(long lo) {
        this.eol = false;
        this.lastLineStart = this.fieldLo - lo;
    }
}

