/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.plaintext;

import com.questdb.parser.ImportedColumnMetadata;
import com.questdb.parser.plaintext.PlainTextParser;
import com.questdb.parser.typeprobe.TypeProbe;
import com.questdb.parser.typeprobe.TypeProbeCollection;
import com.questdb.std.CharSequenceObjHashMap;
import com.questdb.std.IntList;
import com.questdb.std.Mutable;
import com.questdb.std.ObjList;
import com.questdb.std.ObjectPool;
import com.questdb.std.str.DirectByteCharSequence;
import com.questdb.std.str.StringSink;

public class PlainTextMetadataParser
implements PlainTextParser,
Mutable {
    private final StringSink tempSink = new StringSink();
    private final ObjList<ImportedColumnMetadata> _metadata = new ObjList();
    private final ObjList<String> _headers = new ObjList();
    private final IntList _blanks = new IntList();
    private final IntList _histogram = new IntList();
    private final CharSequenceObjHashMap<ImportedColumnMetadata> schemaColumns = new CharSequenceObjHashMap();
    private final ObjectPool<ImportedColumnMetadata> mPool;
    private final TypeProbeCollection typeProbeCollection;
    private int fieldCount;
    private boolean header = false;
    private boolean forceHeader = false;

    public PlainTextMetadataParser(ObjectPool<ImportedColumnMetadata> mPool, TypeProbeCollection typeProbeCollection) {
        this.mPool = mPool;
        this.typeProbeCollection = typeProbeCollection;
    }

    @Override
    public void clear() {
        this.tempSink.clear();
        this._headers.clear();
        this._blanks.clear();
        this._histogram.clear();
        this.fieldCount = 0;
        this.header = false;
        this._metadata.clear();
        this.schemaColumns.clear();
        this.forceHeader = false;
    }

    public ObjList<ImportedColumnMetadata> getMetadata() {
        return this._metadata;
    }

    public boolean isHeader() {
        return this.header;
    }

    public void of(ObjList<ImportedColumnMetadata> schema, boolean forceHeader) {
        this.clear();
        if (schema != null) {
            int n = schema.size();
            for (int i = 0; i < n; ++i) {
                ImportedColumnMetadata m = schema.getQuick(i);
                this.schemaColumns.put(m.name, m);
            }
        }
        this.forceHeader = forceHeader;
    }

    @Override
    public void onError(int line) {
    }

    @Override
    public void onFieldCount(int count) {
        this.fieldCount = count;
        this._histogram.setAll(this.fieldCount * this.typeProbeCollection.getProbeCount(), 0);
        this._blanks.setAll(count, 0);
        for (int i = 0; i < count; ++i) {
            this._metadata.add(this.mPool.next());
        }
        this._headers.setAll(count, null);
    }

    @Override
    public void onFields(int line, ObjList<DirectByteCharSequence> values, int hi) {
        if (line == 0) {
            this.stashPossibleHeader(values, hi);
        }
        int count = this.typeProbeCollection.getProbeCount();
        for (int i = 0; i < hi; ++i) {
            DirectByteCharSequence cs = values.getQuick(i);
            if (cs.length() == 0) {
                this._blanks.increment(i);
            }
            int offset = i * count;
            for (int k = 0; k < count; ++k) {
                TypeProbe probe = this.typeProbeCollection.getProbe(k);
                if (!probe.probe(cs)) continue;
                this._histogram.increment(k + offset);
            }
        }
    }

    @Override
    public void onHeader(ObjList<DirectByteCharSequence> values, int hi) {
    }

    @Override
    public void onLineCount(int count) {
        int i;
        if (this.calcTypes(count, true) && !this.calcTypes(count - 1, false) || this.forceHeader) {
            for (i = 0; i < this.fieldCount; ++i) {
                this._metadata.getQuick((int)i).name = this._headers.getQuick(i);
            }
            this.header = true;
        }
        if (!this.header) {
            for (i = 0; i < this.fieldCount; ++i) {
                this.tempSink.clear();
                this.tempSink.put('f').put(i);
                this._metadata.getQuick((int)i).name = this.tempSink.toString();
            }
        }
        if (this.schemaColumns.size() > 0) {
            int k = this._metadata.size();
            for (i = 0; i < k; ++i) {
                ImportedColumnMetadata _m = this._metadata.getQuick(i);
                ImportedColumnMetadata m = this.schemaColumns.get(_m.name);
                if (m == null) continue;
                m.copyTo(_m);
            }
        }
    }

    private boolean calcTypes(int count, boolean setDefault) {
        boolean allStrings = true;
        int probeCount = this.typeProbeCollection.getProbeCount();
        for (int i = 0; i < this.fieldCount; ++i) {
            int offset = i * probeCount;
            int blanks = this._blanks.getQuick(i);
            boolean unprobed = true;
            ImportedColumnMetadata m = this._metadata.getQuick(i);
            for (int k = 0; k < probeCount; ++k) {
                if (this._histogram.getQuick(k + offset) + blanks != count || blanks >= count) continue;
                unprobed = false;
                TypeProbe probe = this.typeProbeCollection.getProbe(k);
                m.importedColumnType = probe.getType();
                m.pattern = probe.getFormat();
                m.dateFormat = probe.getDateFormat();
                m.dateLocale = probe.getDateLocale();
                if (!allStrings) break;
                allStrings = false;
                break;
            }
            if (!setDefault || !unprobed) continue;
            m.importedColumnType = 7;
        }
        return allStrings;
    }

    private String normalise(CharSequence seq) {
        boolean capNext = false;
        this.tempSink.clear();
        int l = seq.length();
        block3: for (int i = 0; i < l; ++i) {
            char c = seq.charAt(i);
            if (c > '\u07ff') continue;
            switch (c) {
                case '\u0000': 
                case ' ': 
                case '\"': 
                case '%': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '?': 
                case '\\': 
                case '_': 
                case '~': {
                    capNext = true;
                    continue block3;
                }
                default: {
                    if (i == 0 && Character.isDigit(c)) {
                        this.tempSink.put('_');
                    }
                    if (capNext) {
                        this.tempSink.put(Character.toUpperCase(c));
                        capNext = false;
                        continue block3;
                    }
                    this.tempSink.put(c);
                }
            }
        }
        return this.tempSink.toString();
    }

    private void stashPossibleHeader(ObjList<DirectByteCharSequence> values, int hi) {
        for (int i = 0; i < hi; ++i) {
            this._headers.setQuick(i, this.normalise(values.getQuick(i)));
        }
    }
}

