/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.plaintext;

import com.questdb.BootstrapEnv;
import com.questdb.common.ColumnType;
import com.questdb.common.JournalRuntimeException;
import com.questdb.common.NumericException;
import com.questdb.ex.ImportColumnCountException;
import com.questdb.ex.ImportNameException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.parser.ImportedColumnMetadata;
import com.questdb.parser.plaintext.MetadataAwareTextParser;
import com.questdb.std.Chars;
import com.questdb.std.LongList;
import com.questdb.std.Misc;
import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.ObjList;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.DirectByteCharSequence;
import com.questdb.std.str.DirectCharSink;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.Factory;
import com.questdb.store.factory.configuration.ColumnMetadata;
import com.questdb.store.factory.configuration.JournalMetadata;
import com.questdb.store.factory.configuration.JournalStructure;
import java.io.Closeable;

public class PlainTextStoringParser
implements MetadataAwareTextParser,
Closeable,
Mutable {
    public static final int ATOMICITY_STRICT = 0;
    public static final int ATOMICITY_RELAXED = 1;
    private static final Log LOG = LogFactory.getLog(PlainTextStoringParser.class);
    private final Factory factory;
    private final LongList errors = new LongList();
    private final DirectCharSink utf8Sink = new DirectCharSink(4096);
    private String name;
    private ObjList<ImportedColumnMetadata> metadata;
    private boolean header;
    private JournalWriter writer;
    private long _size;
    private boolean overwrite;
    private boolean durable;
    private int atomicity;

    public PlainTextStoringParser(BootstrapEnv env) {
        this.factory = env.factory;
    }

    @Override
    public void clear() {
        this.writer = Misc.free(this.writer);
        this.errors.clear();
        this._size = 0L;
    }

    @Override
    public void close() {
        this.clear();
        this.utf8Sink.close();
    }

    public void commit() {
        if (this.writer != null) {
            try {
                if (this.durable) {
                    this.writer.commitDurable();
                } else {
                    this.writer.commit();
                }
            }
            catch (JournalException e) {
                throw new JournalRuntimeException(e);
            }
        }
    }

    public LongList getErrors() {
        return this.errors;
    }

    public ObjList<ImportedColumnMetadata> getImportedMetadata() {
        return this.metadata;
    }

    public long getImportedRowCount() {
        try {
            return this.writer.size() - this._size;
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
    }

    public JournalMetadata getJournalMetadata() {
        return this.writer.getMetadata();
    }

    public boolean isHeader() {
        return this.header;
    }

    public PlainTextStoringParser of(String name, boolean overwrite, boolean durable, int atomicity) {
        this.name = name;
        this.overwrite = overwrite;
        this.durable = durable;
        this.atomicity = atomicity;
        return this;
    }

    @Override
    public void onError(int line) {
    }

    @Override
    public void onFieldCount(int count) {
    }

    @Override
    public void onFields(int line, ObjList<DirectByteCharSequence> values, int hi) {
        boolean append = true;
        try {
            JournalEntryWriter w = this.writer.entryWriter();
            for (int i = 0; i < hi; ++i) {
                if (values.getQuick(i).length() == 0) continue;
                try {
                    ImportedColumnMetadata m = this.metadata.getQuick(i);
                    switch (m.importedColumnType) {
                        case 7: {
                            this.utf8Sink.clear();
                            Chars.utf8Decode(values.getQuick(i), this.utf8Sink);
                            w.putStr(i, this.utf8Sink);
                            break;
                        }
                        case 2: {
                            w.putDouble(i, Numbers.parseDouble(values.getQuick(i)));
                            break;
                        }
                        case 4: {
                            w.putInt(i, Numbers.parseInt(values.getQuick(i)));
                            break;
                        }
                        case 3: {
                            w.putFloat(i, Numbers.parseFloat(values.getQuick(i)));
                            break;
                        }
                        case 10: {
                            if (m.dateFormat != null && m.dateLocale != null) {
                                w.putDate(i, m.dateFormat.parse(values.getQuick(i), m.dateLocale));
                                break;
                            }
                            throw NumericException.INSTANCE;
                        }
                        case 8: {
                            this.utf8Sink.clear();
                            Chars.utf8Decode(values.getQuick(i), this.utf8Sink);
                            w.putSym(i, this.utf8Sink);
                            break;
                        }
                        case 5: {
                            w.putLong(i, Numbers.parseLong(values.getQuick(i)));
                            break;
                        }
                        case 0: {
                            w.putBool(i, Chars.equalsIgnoreCase(values.getQuick(i), "true"));
                            break;
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    switch (this.atomicity) {
                        case 0: {
                            LOG.info().$("Error at (").$(line).$(',').$(i).$(')').$();
                            throw new JournalRuntimeException("Error on line: " + line + ", col: " + i, new Object[0]);
                        }
                    }
                    this.errors.increment(i);
                    LOG.debug().$("Error at (").$(line).$(',').$(i).$(") as ").$(this.metadata.getQuick((int)i).importedColumnType).$(": ").$(e.getMessage()).$();
                    append = false;
                    break;
                }
            }
            if (append) {
                w.append();
            }
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
    }

    @Override
    public void onHeader(ObjList<DirectByteCharSequence> values, int hi) {
    }

    @Override
    public void onLineCount(int count) {
    }

    @Override
    public void onMetadata(ObjList<ImportedColumnMetadata> metadata, boolean header) {
        if (this.writer == null) {
            this.metadata = metadata;
            this.header = header;
            try {
                switch (this.factory.getConfiguration().exists(this.name)) {
                    case 2: {
                        this.writer = this.factory.writer(this.createStructure());
                        break;
                    }
                    case 1: {
                        if (this.overwrite) {
                            this.factory.delete(this.name);
                            this.writer = this.factory.writer(this.createStructure());
                            break;
                        }
                        this.writer = this.mapColumnsAndOpenWriter();
                        break;
                    }
                    default: {
                        throw ImportNameException.INSTANCE;
                    }
                }
                this.writer.setSequentialAccess(true);
                this._size = this.writer.size();
                this.errors.seed(this.writer.getMetadata().getColumnCount(), 0L);
            }
            catch (JournalException e) {
                throw new JournalRuntimeException(e);
            }
        }
    }

    private JournalStructure createStructure() {
        ObjList<ColumnMetadata> m = new ObjList<ColumnMetadata>(this.metadata.size());
        int n = this.metadata.size();
        for (int i = 0; i < n; ++i) {
            ColumnMetadata cm = new ColumnMetadata();
            ImportedColumnMetadata im = this.metadata.getQuick(i);
            cm.name = im.name.toString();
            cm.type = im.importedColumnType;
            switch (cm.type) {
                case 7: {
                    cm.size = cm.avgSize + 4;
                    break;
                }
                default: {
                    cm.size = ColumnType.sizeOf(cm.type);
                }
            }
            m.add(cm);
        }
        return new JournalStructure(this.name, m);
    }

    private JournalWriter mapColumnsAndOpenWriter() throws JournalException {
        JournalMetadata jm = this.factory.getMetadata(this.name);
        if (jm.getColumnCount() != this.metadata.size()) {
            throw ImportColumnCountException.INSTANCE;
        }
        int n = this.metadata.size();
        for (int i = 0; i < n; ++i) {
            ImportedColumnMetadata im = this.metadata.getQuick(i);
            ColumnMetadata cm = jm.getColumnQuick(i);
            im.importedColumnType = cm.type;
        }
        return this.factory.writer(jm);
    }
}

