/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.std.CharSequenceObjHashMap;
import com.questdb.std.ObjList;

final class ExprOperator {
    public static final int UNARY = 1;
    public static final int BINARY = 2;
    public static final int SET = 3;
    static final ObjList<ExprOperator> operators = new ObjList<ExprOperator>(){
        {
            this.add(new ExprOperator("^", 2, false, 2));
            this.add(new ExprOperator("*", 3, true, 2));
            this.add(new ExprOperator("/", 3, true, 2));
            this.add(new ExprOperator("+", 4, true, 2));
            this.add(new ExprOperator("-", 4, true, 2));
            this.add(new ExprOperator("<", 6, true, 2));
            this.add(new ExprOperator("<=", 6, true, 2));
            this.add(new ExprOperator(">", 6, true, 2));
            this.add(new ExprOperator(">=", 6, true, 2));
            this.add(new ExprOperator("=", 7, true, 2));
            this.add(new ExprOperator("~", 7, true, 2));
            this.add(new ExprOperator("!=", 7, true, 2));
            this.add(new ExprOperator("in", 7, true, 3, false));
            this.add(new ExprOperator("and", 11, true, 2, false));
            this.add(new ExprOperator("or", 11, true, 2, false));
        }
    };
    static final CharSequenceObjHashMap<ExprOperator> opMap = new CharSequenceObjHashMap<ExprOperator>(){
        {
            int k = operators.size();
            for (int i = 0; i < k; ++i) {
                ExprOperator op = operators.getQuick(i);
                this.put(op.token, op);
            }
        }
    };
    final String token;
    final int precedence;
    final boolean leftAssociative;
    final int type;
    final boolean symbol;

    private ExprOperator(String token, int precedence, boolean leftAssociative, int type, boolean symbol) {
        this.token = token;
        this.precedence = precedence;
        this.leftAssociative = leftAssociative;
        this.type = type;
        this.symbol = symbol;
    }

    private ExprOperator(String token, int precedence, boolean leftAssociative, int type) {
        this.token = token;
        this.precedence = precedence;
        this.leftAssociative = leftAssociative;
        this.type = type;
        this.symbol = true;
    }
}

