/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.ExprListener;
import com.questdb.parser.sql.ExprOperator;
import com.questdb.parser.sql.QueryError;
import com.questdb.parser.sql.model.ExprNode;
import com.questdb.std.Chars;
import com.questdb.std.IntHashSet;
import com.questdb.std.IntStack;
import com.questdb.std.Lexer;
import com.questdb.std.ObjectPool;
import java.util.ArrayDeque;
import java.util.Deque;

public class ExprParser {
    private static final IntHashSet nonLiteralBranches = new IntHashSet();
    private static final int BRANCH_NONE = 0;
    private static final int BRANCH_COMMA = 1;
    private static final int BRANCH_LEFT_BRACE = 2;
    private static final int BRANCH_RIGHT_BRACE = 3;
    private static final int BRANCH_CONSTANT = 4;
    private static final int BRANCH_OPERATOR = 5;
    private static final int BRANCH_LITERAL = 6;
    private static final int BRANCH_LAMBDA = 7;
    private final Deque<ExprNode> opStack = new ArrayDeque<ExprNode>();
    private final IntStack paramCountStack = new IntStack();
    private final ObjectPool<ExprNode> exprNodePool;

    public ExprParser(ObjectPool<ExprNode> exprNodePool) {
        this.exprNodePool = exprNodePool;
    }

    public static void configureLexer(Lexer lexer) {
        lexer.defineSymbol("(");
        lexer.defineSymbol(")");
        lexer.defineSymbol(",");
        lexer.defineSymbol("/*");
        lexer.defineSymbol("*/");
        lexer.defineSymbol("--");
        int k = ExprOperator.operators.size();
        for (int i = 0; i < k; ++i) {
            ExprOperator op = ExprOperator.operators.getQuick(i);
            if (!op.symbol) continue;
            lexer.defineSymbol(op.token);
        }
    }

    public void parseExpr(Lexer lexer, ExprListener listener) throws ParserException {
        ExprNode node;
        CharSequence tok;
        this.opStack.clear();
        this.paramCountStack.clear();
        int paramCount = 0;
        int braceCount = 0;
        char thisChar = '\u0000';
        int thisBranch = 0;
        block16: while ((tok = lexer.optionTok()) != null) {
            char prevChar = thisChar;
            thisChar = tok.charAt(0);
            int prevBranch = thisBranch;
            switch (thisChar) {
                case ',': {
                    thisBranch = 1;
                    if (prevChar == ',') {
                        throw QueryError.$(lexer.position(), "Missing argument");
                    }
                    if (braceCount == 0) {
                        lexer.unparse();
                        break block16;
                    }
                    while ((node = this.opStack.poll()) != null && node.token.charAt(0) != '(') {
                        listener.onNode(node);
                    }
                    if (node != null) {
                        this.opStack.push(node);
                    }
                    ++paramCount;
                    continue block16;
                }
                case '(': {
                    thisBranch = 2;
                    ++braceCount;
                    this.paramCountStack.push(paramCount);
                    paramCount = 0;
                    this.opStack.push(this.exprNodePool.next().of(16, "(", Integer.MAX_VALUE, lexer.position()));
                    continue block16;
                }
                case ')': {
                    if (prevChar == ',') {
                        throw QueryError.$(lexer.position(), "Missing argument");
                    }
                    if (braceCount == 0) {
                        lexer.unparse();
                        break block16;
                    }
                    thisBranch = 3;
                    --braceCount;
                    while ((node = this.opStack.poll()) != null && node.token.charAt(0) != '(') {
                        listener.onNode(node);
                    }
                    node = this.opStack.peek();
                    if (node == null || node.type != 4 && node.type != 32) continue block16;
                    node.paramCount = (prevChar == '(' ? 0 : paramCount + 1) + (node.paramCount == 2 ? 1 : 0);
                    node.type = 8;
                    listener.onNode(node);
                    this.opStack.poll();
                    if (!this.paramCountStack.notEmpty()) continue block16;
                    paramCount = this.paramCountStack.pop();
                    continue block16;
                }
                case '`': {
                    thisBranch = 7;
                    listener.onNode(this.exprNodePool.next().of(65, tok.toString(), 0, lexer.position()));
                    continue block16;
                }
                case '\"': 
                case '\'': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'N': 
                case 'n': {
                    if (thisChar != 'N' && thisChar != 'n' || Chars.equals((CharSequence)"NaN", tok) || Chars.equals((CharSequence)"null", tok)) {
                        thisBranch = 4;
                        listener.onNode(this.exprNodePool.next().of(2, tok.toString(), 0, lexer.position()));
                        continue block16;
                    }
                }
                default: {
                    ExprOperator op = ExprOperator.opMap.get(tok);
                    if (op != null) {
                        ExprNode other;
                        thisBranch = 5;
                        int operatorType = op.type;
                        block7 : switch (thisChar) {
                            case '-': {
                                switch (prevBranch) {
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 5: {
                                        operatorType = 1;
                                        break block7;
                                    }
                                }
                                break;
                            }
                        }
                        while ((other = this.opStack.peek()) != null) {
                            boolean greaterPrecedence;
                            boolean bl = greaterPrecedence = op.leftAssociative && op.precedence >= other.precedence || !op.leftAssociative && op.precedence > other.precedence;
                            if (!greaterPrecedence || operatorType == 1 && (operatorType != 1 || other.paramCount != 1)) break;
                            listener.onNode(other);
                            this.opStack.poll();
                        }
                        node = this.exprNodePool.next().of(op.type == 3 ? 32 : 1, op.token, op.precedence, lexer.position());
                        switch (operatorType) {
                            case 1: {
                                node.paramCount = 1;
                                break;
                            }
                            default: {
                                node.paramCount = 2;
                            }
                        }
                        this.opStack.push(node);
                        continue block16;
                    }
                    if (!nonLiteralBranches.contains(thisBranch)) {
                        thisBranch = 6;
                        this.opStack.push(this.exprNodePool.next().of(4, Chars.toString(tok), Integer.MIN_VALUE, lexer.position()));
                        continue block16;
                    }
                    lexer.unparse();
                    break block16;
                }
            }
        }
        while ((node = this.opStack.poll()) != null) {
            if (node.token.charAt(0) == '(') {
                throw QueryError.$(node.position, "Unbalanced (");
            }
            listener.onNode(node);
        }
    }

    static {
        nonLiteralBranches.add(3);
        nonLiteralBranches.add(4);
        nonLiteralBranches.add(6);
        nonLiteralBranches.add(7);
    }
}

