/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.common.NumericException;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryError;
import com.questdb.std.LongList;
import com.questdb.std.Numbers;
import com.questdb.std.ObjList;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.std.time.Dates;
import com.questdb.std.time.Interval;

public class IntervalCompiler {
    public static String asIntervalStr(LongList l) {
        StringBuilder b = new StringBuilder();
        b.append('[');
        int n = l.size();
        for (int i = 0; i < n; i += 2) {
            if (i > 0) {
                b.append(',');
            }
            b.append("Interval{");
            b.append("lo=");
            b.append(Dates.toString(l.getQuick(i)));
            b.append(", ");
            b.append("hi=");
            b.append(Dates.toString(l.getQuick(i + 1)));
            b.append('}');
        }
        b.append(']');
        return b.toString();
    }

    public static long getIntervalHi(LongList intervals, int pos) {
        return intervals.getQuick((pos << 1) + 1);
    }

    public static long getIntervalLo(LongList intervals, int pos) {
        return intervals.getQuick(pos << 1);
    }

    public static void intersect(LongList a, LongList b, LongList out) {
        int sizeA = a.size() / 2;
        int sizeB = b.size() / 2;
        int intervalA = 0;
        int intervalB = 0;
        while (intervalA != sizeA && intervalB != sizeB) {
            long aLo = IntervalCompiler.getIntervalLo(a, intervalA);
            long aHi = IntervalCompiler.getIntervalHi(a, intervalA);
            long bLo = IntervalCompiler.getIntervalLo(b, intervalB);
            long bHi = IntervalCompiler.getIntervalHi(b, intervalB);
            if (aHi < bLo) {
                ++intervalA;
                continue;
            }
            if (IntervalCompiler.getIntervalLo(a, intervalA) > IntervalCompiler.getIntervalHi(b, intervalB)) {
                ++intervalB;
                continue;
            }
            IntervalCompiler.append(out, aLo > bLo ? aLo : bLo, aHi < bHi ? aHi : bHi);
            if (aHi < bHi) {
                ++intervalA;
                continue;
            }
            ++intervalB;
        }
    }

    public static void parseIntervalEx(CharSequence seq, int lo, int lim, int position, LongList out) throws ParserException {
        int[] pos = new int[3];
        int p = -1;
        for (int i = lo; i < lim; ++i) {
            if (seq.charAt(i) != ';') continue;
            if (p > 1) {
                throw QueryError.$(position, "Invalid interval format");
            }
            pos[++p] = i;
        }
        block4 : switch (p) {
            case -1: {
                try {
                    DateFormatUtils.parseInterval(seq, lo, lim, out);
                    break;
                }
                catch (NumericException i) {
                    try {
                        long millis = DateFormatUtils.tryParse(seq, lo, lim);
                        IntervalCompiler.append(out, millis, millis);
                        break;
                    }
                    catch (NumericException e) {
                        throw QueryError.$(position, "Not a date");
                    }
                }
            }
            case 0: {
                IntervalCompiler.parseRange(seq, lo, pos[0], lim, position, out);
                break;
            }
            case 2: {
                int count;
                int period;
                try {
                    period = Numbers.parseInt(seq, pos[1] + 1, pos[2] - 1);
                }
                catch (NumericException e) {
                    throw QueryError.$(position, "Period not a number");
                }
                try {
                    count = Numbers.parseInt(seq, pos[2] + 1, seq.length());
                }
                catch (NumericException e) {
                    throw QueryError.$(position, "Count not a number");
                }
                IntervalCompiler.parseRange(seq, lo, pos[0], pos[1], position, out);
                char type = seq.charAt(pos[2] - 1);
                switch (type) {
                    case 'y': {
                        IntervalCompiler.addYearIntervals(period, count, out);
                        break block4;
                    }
                    case 'M': {
                        IntervalCompiler.addMonthInterval(period, count, out);
                        break block4;
                    }
                    case 'h': {
                        IntervalCompiler.addMillisInterval((long)period * 3600000L, count, out);
                        break block4;
                    }
                    case 'm': {
                        IntervalCompiler.addMillisInterval((long)period * 60000L, count, out);
                        break block4;
                    }
                    case 's': {
                        IntervalCompiler.addMillisInterval((long)period * 1000L, count, out);
                        break block4;
                    }
                    case 'd': {
                        IntervalCompiler.addMillisInterval((long)period * 86400000L, count, out);
                        break block4;
                    }
                }
                throw QueryError.$(position, "Unknown period: " + type + " at " + (p - 1));
            }
            default: {
                throw QueryError.$(position, "Invalid interval format");
            }
        }
    }

    public static void subtract(LongList a, LongList b, LongList out) {
        int sizeA = a.size() / 2;
        int sizeB = b.size() / 2;
        int intervalA = 0;
        int intervalB = 0;
        boolean fetchA = true;
        if (intervalA < sizeA) {
            long aLo = IntervalCompiler.getIntervalLo(a, intervalA);
            long aHi = IntervalCompiler.getIntervalHi(a, intervalA);
            while (intervalA < sizeA) {
                if (fetchA) {
                    aLo = IntervalCompiler.getIntervalLo(a, intervalA);
                    aHi = IntervalCompiler.getIntervalHi(a, intervalA);
                    fetchA = true;
                }
                if (intervalB == sizeB) {
                    IntervalCompiler.append(out, aLo, aHi);
                    ++intervalA;
                    continue;
                }
                long bLo = IntervalCompiler.getIntervalLo(b, intervalB);
                long bHi = IntervalCompiler.getIntervalHi(b, intervalB);
                if (aHi < bLo) {
                    IntervalCompiler.append(out, aLo, aHi);
                    ++intervalA;
                    continue;
                }
                if (aLo > bHi) {
                    ++intervalB;
                    continue;
                }
                if (aLo < bLo) {
                    IntervalCompiler.append(out, aLo, bLo - 1L);
                }
                if (aHi > bHi) {
                    aLo = bHi + 1L;
                    fetchA = false;
                    ++intervalB;
                    continue;
                }
                ++intervalA;
            }
        }
    }

    public static ObjList<Interval> union(ObjList<Interval> a, ObjList<Interval> b) {
        ObjList<Interval> out = new ObjList<Interval>();
        int indexA = 0;
        int indexB = 0;
        int sizeA = a.size();
        int sizeB = b.size();
        Interval intervalA = null;
        Interval intervalB = null;
        while (true) {
            if (intervalA == null && indexA < sizeA) {
                intervalA = a.getQuick(indexA++);
            }
            if (intervalB == null && indexB < sizeB) {
                intervalB = b.getQuick(indexB++);
            }
            if (intervalA == null && intervalB != null) {
                IntervalCompiler.append(out, intervalB);
                intervalB = null;
                continue;
            }
            if (intervalA != null && intervalB == null) {
                IntervalCompiler.append(out, intervalA);
                intervalA = null;
                continue;
            }
            if (intervalA == null) break;
            if (intervalA.getHi() < intervalB.getLo()) {
                IntervalCompiler.append(out, intervalA);
                intervalA = null;
                continue;
            }
            if (intervalA.getLo() > intervalB.getHi()) {
                IntervalCompiler.append(out, intervalB);
                intervalB = null;
                continue;
            }
            Interval next = new Interval(Math.min(intervalA.getLo(), intervalB.getLo()), Math.max(intervalA.getHi(), intervalB.getHi()));
            if (intervalA.getHi() < intervalB.getHi()) {
                intervalB = next;
                intervalA = null;
                continue;
            }
            intervalA = next;
            intervalB = null;
        }
        return out;
    }

    private static void append(LongList list, long lo, long hi) {
        long prevHi;
        int n = list.size();
        if (n > 0 && (prevHi = list.getQuick(n - 1) + 1L) == lo) {
            list.setQuick(n - 1, hi);
            return;
        }
        list.add(lo);
        list.add(hi);
    }

    private static void append(ObjList<Interval> list, Interval interval) {
        Interval prev;
        int n = list.size();
        if (n > 0 && (prev = list.getQuick(n - 1)).getHi() + 1L == interval.getLo()) {
            list.setQuick(n - 1, new Interval(prev.getLo(), interval.getHi()));
            return;
        }
        list.add(interval);
    }

    private static void parseRange(CharSequence seq, int lo, int p, int lim, int position, LongList out) throws ParserException {
        int period;
        char type = seq.charAt(lim - 1);
        try {
            period = Numbers.parseInt(seq, p + 1, lim - 1);
        }
        catch (NumericException e) {
            throw QueryError.$(position, "Range not a number");
        }
        try {
            DateFormatUtils.parseInterval(seq, lo, p, out);
            int n = out.size();
            out.setQuick(n - 1, Dates.addPeriod(out.getQuick(n - 1), type, period));
            return;
        }
        catch (NumericException n) {
            try {
                long loMillis = DateFormatUtils.tryParse(seq, lo, p);
                IntervalCompiler.append(out, loMillis, Dates.addPeriod(loMillis, type, period));
            }
            catch (NumericException e) {
                throw QueryError.$(position, "Neither interval nor date");
            }
            return;
        }
    }

    private static void addMillisInterval(long period, int count, LongList out) {
        int k = out.size();
        long lo = out.getQuick(k - 2);
        long hi = out.getQuick(k - 1);
        int n = count - 1;
        for (int i = 0; i < n; ++i) {
            IntervalCompiler.append(out, lo += period, hi += period);
        }
    }

    private static void addMonthInterval(int period, int count, LongList out) {
        int k = out.size();
        long lo = out.getQuick(k - 2);
        long hi = out.getQuick(k - 1);
        int n = count - 1;
        for (int i = 0; i < n; ++i) {
            lo = Dates.addMonths(lo, period);
            hi = Dates.addMonths(hi, period);
            IntervalCompiler.append(out, lo, hi);
        }
    }

    private static void addYearIntervals(int period, int count, LongList out) {
        int k = out.size();
        long lo = out.getQuick(k - 2);
        long hi = out.getQuick(k - 1);
        int n = count - 1;
        for (int i = 0; i < n; ++i) {
            lo = Dates.addYear(lo, period);
            hi = Dates.addYear(hi, period);
            IntervalCompiler.append(out, lo, hi);
        }
    }
}

