/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.PostOrderTreeTraversalAlgo;
import com.questdb.parser.sql.QueryError;
import com.questdb.parser.sql.model.ExprNode;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.Chars;
import com.questdb.store.factory.configuration.ColumnName;

class LiteralMatcher
implements PostOrderTreeTraversalAlgo.Visitor {
    private final PostOrderTreeTraversalAlgo algo;
    private CharSequenceIntHashMap names;
    private String alias;
    private boolean match;

    LiteralMatcher(PostOrderTreeTraversalAlgo algo) {
        this.algo = algo;
    }

    @Override
    public void visit(ExprNode node) throws ParserException {
        if (node.type == 4 && this.match) {
            int f = this.names.get(node.token);
            if (f == 0) {
                return;
            }
            if (f > 0) {
                throw QueryError.ambiguousColumn(node.position);
            }
            if (this.alias == null) {
                this.match = false;
                return;
            }
            ColumnName columnName = ColumnName.singleton(node.token);
            if (columnName.alias() == null) {
                this.match = false;
                return;
            }
            if (Chars.equals(columnName.alias(), this.alias) && (f = this.names.get(columnName.name())) > -1) {
                if (f > 0) {
                    throw QueryError.ambiguousColumn(node.position);
                }
                node.token = columnName.name().toString();
                return;
            }
            this.match = false;
        }
    }

    boolean matches(ExprNode node, CharSequenceIntHashMap names, String alias) throws ParserException {
        this.match = true;
        this.names = names;
        this.alias = alias;
        this.algo.traverse(node, this);
        return this.match;
    }
}

