/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.model.ExprNode;
import com.questdb.std.IntStack;
import java.util.ArrayDeque;

final class PostOrderTreeTraversalAlgo {
    private final ArrayDeque<ExprNode> stack = new ArrayDeque();
    private final IntStack indexStack = new IntStack();

    PostOrderTreeTraversalAlgo() {
    }

    void traverse(ExprNode node, Visitor visitor) throws ParserException {
        this.stack.clear();
        this.indexStack.clear();
        ExprNode lastVisited = null;
        while (!this.stack.isEmpty() || node != null) {
            if (node != null) {
                this.stack.push(node);
                this.indexStack.push(0);
                node = node.rhs;
                continue;
            }
            ExprNode peek = this.stack.peek();
            if (peek.paramCount < 3) {
                if (peek.lhs != null && lastVisited != peek.lhs) {
                    node = peek.lhs;
                    continue;
                }
                visitor.visit(peek);
                lastVisited = this.stack.poll();
                this.indexStack.pop();
                continue;
            }
            int index = this.indexStack.peek();
            if (index < peek.paramCount) {
                node = peek.args.getQuick(index);
                this.indexStack.update(index + 1);
                continue;
            }
            visitor.visit(peek);
            lastVisited = this.stack.poll();
            this.indexStack.pop();
        }
    }

    public static interface Visitor {
        public void visit(ExprNode var1) throws ParserException;
    }
}

