/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.BootstrapEnv;
import com.questdb.ServerConfiguration;
import com.questdb.common.ColumnType;
import com.questdb.common.NumericException;
import com.questdb.common.PartitionBy;
import com.questdb.common.Record;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.CopyHelper;
import com.questdb.parser.sql.CopyHelperCompiler;
import com.questdb.parser.sql.LiteralMatcher;
import com.questdb.parser.sql.PostOrderTreeTraversalAlgo;
import com.questdb.parser.sql.QueryError;
import com.questdb.parser.sql.QueryFilterAnalyser;
import com.questdb.parser.sql.QueryParser;
import com.questdb.parser.sql.VirtualColumnBuilder;
import com.questdb.parser.sql.model.AnalyticColumn;
import com.questdb.parser.sql.model.ColumnCastModel;
import com.questdb.parser.sql.model.ColumnIndexModel;
import com.questdb.parser.sql.model.CreateJournalModel;
import com.questdb.parser.sql.model.ExprNode;
import com.questdb.parser.sql.model.IntrinsicModel;
import com.questdb.parser.sql.model.JoinContext;
import com.questdb.parser.sql.model.ParsedModel;
import com.questdb.parser.sql.model.QueryColumn;
import com.questdb.parser.sql.model.QueryModel;
import com.questdb.parser.sql.model.RenameJournalModel;
import com.questdb.ql.AggregatorFunction;
import com.questdb.ql.AllRowSource;
import com.questdb.ql.FilteredRecordSource;
import com.questdb.ql.FilteredRowSource;
import com.questdb.ql.JournalPartitionSource;
import com.questdb.ql.JournalRecordSource;
import com.questdb.ql.NoOpJournalPartitionSource;
import com.questdb.ql.NoOpJournalRecordSource;
import com.questdb.ql.NoRowIdRecordSource;
import com.questdb.ql.PartitionSource;
import com.questdb.ql.RecordSource;
import com.questdb.ql.RowSource;
import com.questdb.ql.TimestampRelocatingRecordSource;
import com.questdb.ql.TopRecordSource;
import com.questdb.ql.aggregation.AggregatedRecordSource;
import com.questdb.ql.aggregation.CountRecordSource;
import com.questdb.ql.aggregation.ResampledRecordSource;
import com.questdb.ql.aggregation.SamplerFactory;
import com.questdb.ql.aggregation.TimestampSampler;
import com.questdb.ql.analytic.AnalyticFunction;
import com.questdb.ql.analytic.AnalyticFunctionFactories;
import com.questdb.ql.analytic.AnalyticRecordSource;
import com.questdb.ql.analytic.CachedAnalyticRecordSource;
import com.questdb.ql.analytic.CachedRowAnalyticRecordSource;
import com.questdb.ql.interval.IntervalRecordSource;
import com.questdb.ql.interval.MultiIntervalPartitionSource;
import com.questdb.ql.join.AsOfJoinRecordSource;
import com.questdb.ql.join.AsOfPartitionedJoinRecordSource;
import com.questdb.ql.join.CrossJoinRecordSource;
import com.questdb.ql.join.HashJoinRecordSource;
import com.questdb.ql.lambda.KvIndexIntLambdaHeadRowSource;
import com.questdb.ql.lambda.KvIndexStrStrLambdaHeadRowSource;
import com.questdb.ql.lambda.KvIndexStrSymLambdaHeadRowSource;
import com.questdb.ql.lambda.KvIndexSymStrLambdaHeadRowSource;
import com.questdb.ql.lambda.KvIndexSymSymLambdaHeadRowSource;
import com.questdb.ql.lambda.LatestByLambdaRowSourceFactory;
import com.questdb.ql.latest.HeapMergingRowSource;
import com.questdb.ql.latest.KvIndexIntListHeadRowSource;
import com.questdb.ql.latest.KvIndexIntLookupRowSource;
import com.questdb.ql.latest.KvIndexLongListHeadRowSource;
import com.questdb.ql.latest.KvIndexLongLookupRowSource;
import com.questdb.ql.latest.KvIndexStrListHeadRowSource;
import com.questdb.ql.latest.KvIndexStrLookupRowSource;
import com.questdb.ql.latest.KvIndexSymAllHeadRowSource;
import com.questdb.ql.latest.KvIndexSymListHeadRowSource;
import com.questdb.ql.latest.KvIndexSymLookupRowSource;
import com.questdb.ql.latest.MergingRowSource;
import com.questdb.ql.map.RecordKeyCopierCompiler;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.ql.ops.FunctionFactories;
import com.questdb.ql.ops.Parameter;
import com.questdb.ql.ops.Signature;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.constant.LongConstant;
import com.questdb.ql.select.SelectedColumnsRecordSource;
import com.questdb.ql.sort.ComparatorCompiler;
import com.questdb.ql.sort.RBTreeSortedRecordSource;
import com.questdb.ql.sort.RecordComparator;
import com.questdb.ql.sys.SysFactories;
import com.questdb.ql.sys.SystemViewFactory;
import com.questdb.ql.virtual.VirtualColumnRecordSource;
import com.questdb.std.BytecodeAssembler;
import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.CharSequenceObjHashMap;
import com.questdb.std.Chars;
import com.questdb.std.IntHashSet;
import com.questdb.std.IntList;
import com.questdb.std.IntPriorityQueue;
import com.questdb.std.LongHashSet;
import com.questdb.std.Misc;
import com.questdb.std.Numbers;
import com.questdb.std.ObjHashSet;
import com.questdb.std.ObjList;
import com.questdb.std.ObjObjHashMap;
import com.questdb.std.ObjectPool;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.FlyweightCharSequence;
import com.questdb.std.str.StringSink;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.Factory;
import com.questdb.store.factory.configuration.ColumnMetadata;
import com.questdb.store.factory.configuration.JournalMetadata;
import com.questdb.store.factory.configuration.JournalStructure;
import java.util.ArrayDeque;

public class QueryCompiler {
    private static final CharSequenceObjHashMap<Parameter> EMPTY_PARAMS = new CharSequenceObjHashMap();
    private static final CharSequenceHashSet nullConstants = new CharSequenceHashSet();
    private static final ObjObjHashMap<Signature, LatestByLambdaRowSourceFactory> LAMBDA_ROW_SOURCE_FACTORIES = new ObjObjHashMap();
    private static final LongConstant LONG_ZERO_CONST = new LongConstant(0L, 0);
    private static final IntHashSet joinBarriers = new IntHashSet();
    private static final int ORDER_BY_UNKNOWN = 0;
    private static final int ORDER_BY_REQUIRED = 1;
    private static final int ORDER_BY_INVARIANT = 2;
    private final BytecodeAssembler asm = new BytecodeAssembler();
    private final QueryParser parser = new QueryParser();
    private final QueryFilterAnalyser queryFilterAnalyser = new QueryFilterAnalyser();
    private final StringSink columnNameAssembly = new StringSink();
    private final int columnNamePrefixLen;
    private final ObjectPool<FlyweightCharSequence> csPool = new ObjectPool<FlyweightCharSequence>(FlyweightCharSequence.FACTORY, 64);
    private final ObjectPool<ExprNode> exprNodePool = new ObjectPool<ExprNode>(ExprNode.FACTORY, 16);
    private final IntHashSet deletedContexts = new IntHashSet();
    private final ObjList<JoinContext> joinClausesSwap1 = new ObjList();
    private final ObjList<JoinContext> joinClausesSwap2 = new ObjList();
    private final ObjectPool<JoinContext> contextPool = new ObjectPool<JoinContext>(JoinContext.FACTORY, 16);
    private final PostOrderTreeTraversalAlgo traversalAlgo = new PostOrderTreeTraversalAlgo();
    private final VirtualColumnBuilder virtualColumnBuilder;
    private final IntList clausesToSteal = new IntList();
    private final IntList literalCollectorAIndexes = new IntList();
    private final ObjList<CharSequence> literalCollectorANames = new ObjList();
    private final IntList literalCollectorBIndexes = new IntList();
    private final ObjList<CharSequence> literalCollectorBNames = new ObjList();
    private final LiteralCollector literalCollector = new LiteralCollector();
    private final IntPriorityQueue orderingStack = new IntPriorityQueue();
    private final IntList tempCrosses = new IntList();
    private final IntList tempCrossIndexes = new IntList();
    private final IntHashSet postFilterRemoved = new IntHashSet();
    private final IntHashSet journalsSoFar = new IntHashSet();
    private final ObjList<IntList> postFilterJournalRefs = new ObjList();
    private final ObjectPool<IntList> intListPool = new ObjectPool<IntList>(IntList::new, 16);
    private final ArrayDeque<ExprNode> exprNodeStack = new ArrayDeque();
    private final IntList nullCounts = new IntList();
    private final ObjList<CharSequence> selectedColumns = new ObjList();
    private final CharSequenceHashSet selectedColumnAliases = new CharSequenceHashSet();
    private final CharSequenceIntHashMap constNameToIndex = new CharSequenceIntHashMap();
    private final CharSequenceObjHashMap<ExprNode> constNameToNode = new CharSequenceObjHashMap();
    private final CharSequenceObjHashMap<String> constNameToToken = new CharSequenceObjHashMap();
    private final Signature mutableSig = new Signature();
    private final ObjectPool<QueryColumn> aggregateColumnPool = new ObjectPool<QueryColumn>(QueryColumn.FACTORY, 8);
    private final ObjList<QueryColumn> aggregators = new ObjList();
    private final ObjList<QueryColumn> outerVirtualColumns = new ObjList();
    private final ObjList<QueryColumn> innerVirtualColumn = new ObjList();
    private final ObjList<AnalyticColumn> analyticColumns = new ObjList();
    private final ObjHashSet<String> groupKeyColumns = new ObjHashSet();
    private final ComparatorCompiler cc = new ComparatorCompiler(this.asm);
    private final LiteralMatcher literalMatcher = new LiteralMatcher(this.traversalAlgo);
    private final ServerConfiguration configuration;
    private final ObjObjHashMap<IntList, ObjList<AnalyticFunction>> grouppedAnalytic = new ObjObjHashMap();
    private final CopyHelperCompiler copyHelperCompiler = new CopyHelperCompiler(this.asm);
    private final RecordKeyCopierCompiler recordKeyCopierCompiler = new RecordKeyCopierCompiler(this.asm);
    private final BootstrapEnv env;
    private ObjList<JoinContext> emittedJoinClauses;
    private int aggregateColumnSequence;

    public QueryCompiler() {
        this(new BootstrapEnv(){
            {
                this.configuration = new ServerConfiguration();
            }
        });
    }

    public QueryCompiler(BootstrapEnv env) {
        this.env = env;
        this.configuration = env.configuration;
        this.virtualColumnBuilder = new VirtualColumnBuilder(this.traversalAlgo, env);
        this.columnNameAssembly.put("col");
        this.columnNamePrefixLen = 3;
    }

    public RecordSource compile(Factory factory, CharSequence query) throws ParserException {
        return this.compile(factory, this.parse(query));
    }

    public RecordSource compile(Factory factory, ParsedModel model) throws ParserException {
        if (model.getModelType() == 1) {
            this.clearState();
            QueryModel qm = (QueryModel)model;
            qm.setParameterMap(EMPTY_PARAMS);
            RecordSource rs = this.compile(qm, factory);
            rs.setParameterMap(EMPTY_PARAMS);
            return rs;
        }
        throw new IllegalArgumentException("QueryModel expected");
    }

    public JournalWriter createWriter(Factory factory, ParsedModel model) throws ParserException, JournalException {
        int i;
        int n;
        if (model.getModelType() != 2) {
            throw new IllegalArgumentException("create table statement expected");
        }
        this.clearState();
        CreateJournalModel cm = (CreateJournalModel)model;
        String name = cm.getName().token;
        switch (factory.getConfiguration().exists(name)) {
            case 1: {
                throw QueryError.$(cm.getName().position, "Journal already exists");
            }
            case 4: {
                throw QueryError.$(cm.getName().position, "Name is reserved");
            }
        }
        JournalStructure struct = cm.getStruct();
        QueryModel queryModel = cm.getQueryModel();
        RecordSource rs = queryModel != null ? this.compile(queryModel, factory) : null;
        if (struct == null) {
            assert (rs != null);
            RecordMetadata metadata = rs.getMetadata();
            CharSequenceObjHashMap<ColumnCastModel> castModels = cm.getColumnCastModels();
            n = castModels.size();
            for (i = 0; i < n; ++i) {
                ColumnCastModel castModel = castModels.valueQuick(i);
                if (metadata.getColumnIndexQuiet(castModel.getName().token) != -1) continue;
                throw QueryError.invalidColumn(castModel.getName().position, castModel.getName().token);
            }
            struct = this.createStructure(name, metadata, castModels);
        }
        try {
            QueryCompiler.validateAndSetTimestamp(struct, cm.getTimestamp());
            QueryCompiler.validateAndSetPartitionBy(struct, cm.getPartitionBy());
            ExprNode recordHint = cm.getRecordHint();
            if (recordHint != null) {
                try {
                    struct.recordCountHint(Numbers.parseInt(recordHint.token));
                }
                catch (NumericException e) {
                    throw QueryError.$(recordHint.position, "Bad int");
                }
            }
            ObjList<ColumnIndexModel> columnIndexModels = cm.getColumnIndexModels();
            n = columnIndexModels.size();
            block14: for (i = 0; i < n; ++i) {
                ColumnIndexModel cim = columnIndexModels.getQuick(i);
                ExprNode nn = cim.getName();
                ColumnMetadata m = struct.getColumnMetadata(nn.token);
                if (m == null) {
                    throw QueryError.invalidColumn(nn.position, nn.token);
                }
                switch (m.getType()) {
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        m.indexed = true;
                        m.distinctCountHint = cim.getBuckets();
                        continue block14;
                    }
                    default: {
                        throw QueryError.$(nn.position, "Type index not supported");
                    }
                }
            }
            JournalWriter<Object> w = factory.writer(struct);
            w.setSequentialAccess(true);
            if (rs != null) {
                try {
                    this.copy(factory, rs, w);
                }
                catch (Throwable e) {
                    w.close();
                    throw e;
                }
            }
            return w;
        }
        catch (Throwable e) {
            Misc.free(rs);
            throw e;
        }
    }

    public JournalWriter createWriter(Factory factory, CharSequence statement) throws ParserException, JournalException {
        return this.createWriter(factory, this.parse(statement));
    }

    public void execute(Factory factory, CharSequence statement) throws ParserException, JournalException {
        this.execute(factory, this.parse(statement));
    }

    public void execute(Factory factory, ParsedModel model) throws ParserException, JournalException {
        switch (model.getModelType()) {
            case 2: {
                this.createWriter(factory, model).close();
                break;
            }
            case 1: {
                throw new IllegalArgumentException("Statement expected");
            }
            case 3: {
                this.renameJournal(factory, (RenameJournalModel)model);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown statement");
            }
        }
    }

    public ParsedModel parse(CharSequence statement) throws ParserException {
        return this.parser.parse(statement);
    }

    private static void validateAndSetPartitionBy(JournalStructure struct, ExprNode partitionBy) throws ParserException {
        int p;
        if (partitionBy == null) {
            return;
        }
        if (struct.hasTimestamp()) {
            p = PartitionBy.fromString(partitionBy.token);
            if (p == -1) {
                throw QueryError.$(partitionBy.position, "Invalid partition type");
            }
        } else {
            throw QueryError.$(partitionBy.position, "No timestamp");
        }
        struct.partitionBy(p);
    }

    private static void validateAndSetTimestamp(JournalStructure struct, ExprNode timestamp) throws ParserException {
        if (timestamp == null) {
            return;
        }
        int index = struct.getColumnIndex(timestamp.token);
        if (index == -1) {
            throw QueryError.invalidColumn(timestamp.position, timestamp.token);
        }
        if (struct.getColumnMetadata(index).getType() != 10) {
            throw QueryError.$(timestamp.position, "Not a DATE");
        }
        struct.$ts(index);
    }

    private static Signature lbs(int masterType, int lambdaType) {
        return new Signature().setName("").setParamCount(2).paramType(0, masterType, true).paramType(1, lambdaType, false);
    }

    private static IntHashSet toIntHashSet(IntrinsicModel im) throws ParserException {
        IntHashSet set = null;
        int n = im.keyValues.size();
        for (int i = 0; i < n; ++i) {
            try {
                int v = Numbers.parseInt(im.keyValues.get(i));
                if (set == null) {
                    set = new IntHashSet(n);
                }
                set.add(v);
                continue;
            }
            catch (NumericException e) {
                throw QueryError.$(im.keyValuePositions.get(i), "int value expected");
            }
        }
        return set;
    }

    private static LongHashSet toLongHashSet(IntrinsicModel im) throws ParserException {
        LongHashSet set = null;
        int n = im.keyValues.size();
        for (int i = 0; i < n; ++i) {
            try {
                long v = Numbers.parseLong(im.keyValues.get(i));
                if (set == null) {
                    set = new LongHashSet(n);
                }
                set.add(v);
                continue;
            }
            catch (NumericException e) {
                throw QueryError.$(im.keyValuePositions.get(i), "int value expected");
            }
        }
        return set;
    }

    private static void assertNotNull(ExprNode node, int position, String message) throws ParserException {
        if (node == null) {
            throw QueryError.$(position, message);
        }
    }

    private void addAlias(int position, String alias) throws ParserException {
        if (this.selectedColumnAliases.add(alias)) {
            return;
        }
        throw QueryError.$(position, "Duplicate alias");
    }

    private void addFilterOrEmitJoin(QueryModel parent, int idx, int ai, CharSequence an, ExprNode ao, int bi, CharSequence bn, ExprNode bo) {
        if (ai == bi && Chars.equals(an, bn)) {
            this.deletedContexts.add(idx);
            return;
        }
        if (ai == bi) {
            ExprNode node = this.exprNodePool.next().of(1, "=", 0, 0);
            node.paramCount = 2;
            node.lhs = ao;
            node.rhs = bo;
            this.addWhereClause(parent, ai, node);
        } else {
            JoinContext jc = this.contextPool.next();
            jc.aIndexes.add(ai);
            jc.aNames.add(an);
            jc.aNodes.add(ao);
            jc.bIndexes.add(bi);
            jc.bNames.add(bn);
            jc.bNodes.add(bo);
            jc.slaveIndex = ai > bi ? ai : bi;
            jc.parents.add(ai < bi ? ai : bi);
            this.emittedJoinClauses.add(jc);
        }
        this.deletedContexts.add(idx);
    }

    private void addJoinContext(QueryModel parent, JoinContext context) {
        QueryModel jm = parent.getJoinModels().getQuick(context.slaveIndex);
        JoinContext other = jm.getContext();
        if (other == null) {
            jm.setContext(context);
        } else {
            jm.setContext(this.mergeContexts(parent, other, context));
        }
    }

    private void addTransitiveFilters(QueryModel parent) {
        ObjList<QueryModel> joinModels = parent.getJoinModels();
        int n = joinModels.size();
        for (int i = 0; i < n; ++i) {
            JoinContext jc = joinModels.getQuick(i).getContext();
            if (jc == null) continue;
            int kn = jc.bNames.size();
            for (int k = 0; k < kn; ++k) {
                CharSequence name = jc.bNames.getQuick(k);
                if (this.constNameToIndex.get(name) != jc.bIndexes.getQuick(k)) continue;
                ExprNode node = this.exprNodePool.next().of(1, this.constNameToToken.get(name), 0, 0);
                node.lhs = jc.aNodes.getQuick(k);
                node.rhs = this.constNameToNode.get(name);
                node.paramCount = 2;
                this.addWhereClause(parent, jc.slaveIndex, node);
            }
        }
    }

    private void addWhereClause(QueryModel parent, int index, ExprNode filter) {
        QueryModel m = parent.getJoinModels().getQuick(index);
        m.setWhereClause(this.concatFilters(m.getWhereClause(), filter));
    }

    private void alignJoinClauses(QueryModel parent) {
        ObjList<QueryModel> joinModels = parent.getJoinModels();
        int n = joinModels.size();
        for (int i = 0; i < n; ++i) {
            JoinContext jc = joinModels.getQuick(i).getContext();
            if (jc == null) continue;
            int index = jc.slaveIndex;
            int kc = jc.aIndexes.size();
            for (int k = 0; k < kc; ++k) {
                if (jc.aIndexes.getQuick(k) == index) continue;
                int idx = jc.aIndexes.getQuick(k);
                CharSequence name = jc.aNames.getQuick(k);
                ExprNode node = jc.aNodes.getQuick(k);
                jc.aIndexes.setQuick(k, jc.bIndexes.getQuick(k));
                jc.aNames.setQuick(k, jc.bNames.getQuick(k));
                jc.aNodes.setQuick(k, jc.bNodes.getQuick(k));
                jc.bIndexes.setQuick(k, idx);
                jc.bNames.setQuick(k, name);
                jc.bNodes.setQuick(k, node);
            }
        }
    }

    private RecordSource analyseAndCompileOrderBy(QueryModel model, RecordSource recordSource) throws ParserException {
        this.literalCollectorANames.clear();
        this.literalCollectorAIndexes.clear();
        this.literalCollector.withParent(model);
        this.literalCollector.resetNullCount();
        CharSequenceObjHashMap<QueryColumn> columnHashMap = new CharSequenceObjHashMap<QueryColumn>();
        ObjList<QueryColumn> columns = model.getColumns();
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            QueryColumn c = columns.getQuick(i);
            columnHashMap.put(c.getAlias() == null ? c.getName() : c.getAlias(), c);
        }
        ObjList<ExprNode> orderBy = model.getOrderBy();
        this.innerVirtualColumn.clear();
        int n2 = orderBy.size();
        for (int i = 0; i < n2; ++i) {
            QueryColumn col = (QueryColumn)columnHashMap.get(orderBy.getQuick((int)i).token);
            if (col != null) {
                this.traversalAlgo.traverse(col.getAst(), this.literalCollector.lhs());
                if (col.getAst().type == 4) continue;
                this.innerVirtualColumn.add(col);
                continue;
            }
            this.traversalAlgo.traverse(orderBy.getQuick(i), this.literalCollector.lhs());
        }
        boolean canUseOrderByHere = true;
        int n3 = this.literalCollectorAIndexes.size();
        for (int i = 0; i < n3; ++i) {
            if (this.literalCollectorAIndexes.getQuick(i) == 0) continue;
            canUseOrderByHere = false;
            break;
        }
        if (canUseOrderByHere) {
            RecordSource rs = recordSource;
            if (this.innerVirtualColumn.size() > 0) {
                ObjList<VirtualColumn> virtualColumns = new ObjList<VirtualColumn>();
                int n4 = this.innerVirtualColumn.size();
                for (int i = 0; i < n4; ++i) {
                    QueryColumn qc = this.innerVirtualColumn.getQuick(i);
                    VirtualColumn vc = this.virtualColumnBuilder.createVirtualColumn(model, qc.getAst(), rs.getMetadata());
                    vc.setName(qc.getAlias());
                    virtualColumns.add(vc);
                    ExprNode expr = qc.getAst();
                    expr.type = 4;
                    expr.token = qc.getAlias();
                    expr.args.clear();
                    expr.lhs = null;
                    expr.rhs = null;
                    expr.position = qc.getAliasPosition();
                    expr.paramCount = 0;
                }
                rs = new VirtualColumnRecordSource(rs, virtualColumns);
            }
            int n5 = orderBy.size();
            for (int i = 0; i < n5; ++i) {
                QueryColumn col = (QueryColumn)columnHashMap.get(orderBy.getQuick((int)i).token);
                if (col == null || col.getAst().type != 4 || col.getAlias() == null) continue;
                orderBy.getQuick((int)i).token = col.getAst().token;
            }
            rs = this.order(rs, model);
            model.getOrderBy().clear();
            return rs;
        }
        return recordSource;
    }

    private void analyseEquals(QueryModel parent, ExprNode node) throws ParserException {
        this.traverseNamesAndIndices(parent, node);
        int aSize = this.literalCollectorAIndexes.size();
        int bSize = this.literalCollectorBIndexes.size();
        switch (aSize) {
            case 0: {
                if (bSize == 1 && this.literalCollector.nullCount == 0 && !joinBarriers.contains(parent.getJoinModels().get(this.literalCollectorBIndexes.getQuick(0)).getJoinType())) {
                    JoinContext jc = this.contextPool.next();
                    jc.slaveIndex = this.literalCollectorBIndexes.getQuick(0);
                    this.addWhereClause(parent, jc.slaveIndex, node);
                    this.addJoinContext(parent, jc);
                    CharSequence cs = this.literalCollectorBNames.getQuick(0);
                    this.constNameToIndex.put(cs, jc.slaveIndex);
                    this.constNameToNode.put(cs, node.lhs);
                    this.constNameToToken.put(cs, node.token);
                    break;
                }
                parent.addParsedWhereNode(node);
                break;
            }
            case 1: {
                JoinContext jc = this.contextPool.next();
                int lhi = this.literalCollectorAIndexes.getQuick(0);
                if (bSize == 1) {
                    int rhi = this.literalCollectorBIndexes.getQuick(0);
                    if (lhi == rhi) {
                        jc.slaveIndex = lhi;
                        this.addWhereClause(parent, lhi, node);
                    } else {
                        jc.aNodes.add(node.lhs);
                        jc.bNodes.add(node.rhs);
                        jc.aNames.add(this.literalCollectorANames.getQuick(0));
                        jc.bNames.add(this.literalCollectorBNames.getQuick(0));
                        jc.aIndexes.add(lhi);
                        jc.bIndexes.add(rhi);
                        int max = lhi > rhi ? lhi : rhi;
                        int min = lhi < rhi ? lhi : rhi;
                        jc.slaveIndex = max;
                        jc.parents.add(min);
                        this.linkDependencies(parent, min, max);
                    }
                    this.addJoinContext(parent, jc);
                    break;
                }
                if (bSize == 0 && this.literalCollector.nullCount == 0 && !joinBarriers.contains(parent.getJoinModels().get(this.literalCollectorAIndexes.getQuick(0)).getJoinType())) {
                    jc.slaveIndex = lhi;
                    this.addWhereClause(parent, lhi, node);
                    this.addJoinContext(parent, jc);
                    CharSequence cs = this.literalCollectorANames.getQuick(0);
                    this.constNameToIndex.put(cs, lhi);
                    this.constNameToNode.put(cs, node.rhs);
                    this.constNameToToken.put(cs, node.token);
                    break;
                }
                parent.addParsedWhereNode(node);
                break;
            }
            default: {
                parent.addParsedWhereNode(node);
            }
        }
    }

    private void analyseRegex(QueryModel parent, ExprNode node) throws ParserException {
        this.traverseNamesAndIndices(parent, node);
        if (this.literalCollector.nullCount == 0) {
            int aSize = this.literalCollectorAIndexes.size();
            int bSize = this.literalCollectorBIndexes.size();
            if (aSize == 1 && bSize == 0) {
                CharSequence name = this.literalCollectorANames.getQuick(0);
                this.constNameToIndex.put(name, this.literalCollectorAIndexes.getQuick(0));
                this.constNameToNode.put(name, node.rhs);
                this.constNameToToken.put(name, node.token);
            }
        }
    }

    private void applyLimit(QueryModel model) throws ParserException {
        if (model.getLimitLo() != null || model.getLimitHi() != null) {
            ExprNode lo = model.getLimitLo();
            ExprNode hi = model.getLimitHi();
            if (hi == null) {
                model.setLimitVc(LONG_ZERO_CONST, this.limitToVirtualColumn(model, lo));
            } else {
                model.setLimitVc(this.limitToVirtualColumn(model, lo), this.limitToVirtualColumn(model, hi));
            }
        }
    }

    private void assignFilters(QueryModel parent) throws ParserException {
        this.journalsSoFar.clear();
        this.postFilterRemoved.clear();
        this.postFilterJournalRefs.clear();
        this.nullCounts.clear();
        this.literalCollector.withParent(parent);
        ObjList<ExprNode> filterNodes = parent.getParsedWhere();
        int pc = filterNodes.size();
        for (int i = 0; i < pc; ++i) {
            IntList indexes = this.intListPool.next();
            this.literalCollector.resetNullCount();
            this.traversalAlgo.traverse(filterNodes.getQuick(i), this.literalCollector.to(indexes));
            this.postFilterJournalRefs.add(indexes);
            this.nullCounts.add(this.literalCollector.nullCount);
        }
        IntList ordered = parent.getOrderedJoinModels();
        int n = ordered.size();
        for (int i = 0; i < n; ++i) {
            int index = ordered.getQuick(i);
            this.journalsSoFar.add(index);
            for (int k = 0; k < pc; ++k) {
                if (this.postFilterRemoved.contains(k)) continue;
                IntList refs = this.postFilterJournalRefs.getQuick(k);
                int rs = refs.size();
                if (rs == 0) {
                    this.postFilterRemoved.add(k);
                    parent.addParsedWhereConst(k);
                    continue;
                }
                if (rs == 1 && this.nullCounts.getQuick(k) == 0 && !joinBarriers.contains(parent.getJoinModels().getQuick(refs.getQuick(0)).getJoinType())) {
                    this.addWhereClause(parent, refs.getQuick(0), filterNodes.getQuick(k));
                    this.postFilterRemoved.add(k);
                    continue;
                }
                boolean qualifies = true;
                for (int y = 0; y < rs; ++y) {
                    if (this.journalsSoFar.contains(refs.getQuick(y))) continue;
                    qualifies = false;
                    break;
                }
                if (!qualifies) continue;
                this.postFilterRemoved.add(k);
                QueryModel m = parent.getJoinModels().getQuick(index);
                m.setPostJoinWhereClause(this.concatFilters(m.getPostJoinWhereClause(), filterNodes.getQuick(k)));
            }
        }
        assert (this.postFilterRemoved.size() == pc);
    }

    private RowSource buildRowSourceForInt(IntrinsicModel im) throws ParserException {
        int nSrc = im.keyValues.size();
        switch (nSrc) {
            case 1: {
                return new KvIndexIntLookupRowSource(im.keyColumn, this.toInt(im.keyValues.getLast(), im.keyValuePositions.getLast()));
            }
            case 2: {
                return new MergingRowSource(new KvIndexIntLookupRowSource(im.keyColumn, this.toInt(im.keyValues.get(0), im.keyValuePositions.getQuick(0)), true), new KvIndexIntLookupRowSource(im.keyColumn, this.toInt(im.keyValues.get(1), im.keyValuePositions.getQuick(1)), true));
            }
        }
        RowSource[] sources = new RowSource[nSrc];
        for (int i = 0; i < nSrc; ++i) {
            Unsafe.arrayPut(sources, i, new KvIndexIntLookupRowSource(im.keyColumn, this.toInt(im.keyValues.get(i), im.keyValuePositions.getQuick(i)), true));
        }
        return new HeapMergingRowSource(sources);
    }

    private RowSource buildRowSourceForLong(IntrinsicModel im) throws ParserException {
        int nSrc = im.keyValues.size();
        switch (nSrc) {
            case 1: {
                return new KvIndexLongLookupRowSource(im.keyColumn, this.toLong(im.keyValues.getLast(), im.keyValuePositions.getLast()));
            }
            case 2: {
                return new MergingRowSource(new KvIndexLongLookupRowSource(im.keyColumn, this.toLong(im.keyValues.get(0), im.keyValuePositions.getQuick(0)), true), new KvIndexLongLookupRowSource(im.keyColumn, this.toLong(im.keyValues.get(1), im.keyValuePositions.getQuick(1)), true));
            }
        }
        RowSource[] sources = new RowSource[nSrc];
        for (int i = 0; i < nSrc; ++i) {
            Unsafe.arrayPut(sources, i, new KvIndexLongLookupRowSource(im.keyColumn, this.toLong(im.keyValues.get(i), im.keyValuePositions.getQuick(i)), true));
        }
        return new HeapMergingRowSource(sources);
    }

    private RowSource buildRowSourceForStr(IntrinsicModel im) {
        int nSrc = im.keyValues.size();
        switch (nSrc) {
            case 1: {
                return new KvIndexStrLookupRowSource(im.keyColumn, Chars.toString(im.keyValues.getLast()));
            }
            case 2: {
                return new MergingRowSource(new KvIndexStrLookupRowSource(im.keyColumn, Chars.toString(im.keyValues.get(0)), true), new KvIndexStrLookupRowSource(im.keyColumn, Chars.toString(im.keyValues.get(1)), true));
            }
        }
        RowSource[] sources = new RowSource[nSrc];
        for (int i = 0; i < nSrc; ++i) {
            Unsafe.arrayPut(sources, i, new KvIndexStrLookupRowSource(im.keyColumn, Chars.toString(im.keyValues.get(i)), true));
        }
        return new HeapMergingRowSource(sources);
    }

    private RowSource buildRowSourceForSym(IntrinsicModel im) {
        int nSrc = im.keyValues.size();
        switch (nSrc) {
            case 1: {
                return new KvIndexSymLookupRowSource(im.keyColumn, Chars.toString(im.keyValues.getLast()));
            }
            case 2: {
                return new MergingRowSource(new KvIndexSymLookupRowSource(im.keyColumn, Chars.toString(im.keyValues.get(0)), true), new KvIndexSymLookupRowSource(im.keyColumn, Chars.toString(im.keyValues.get(1)), true));
            }
        }
        RowSource[] sources = new RowSource[nSrc];
        for (int i = 0; i < nSrc; ++i) {
            Unsafe.arrayPut(sources, i, new KvIndexSymLookupRowSource(im.keyColumn, Chars.toString(im.keyValues.get(i)), true));
        }
        return new HeapMergingRowSource(sources);
    }

    private void clearState() {
        this.csPool.clear();
        this.exprNodePool.clear();
        this.contextPool.clear();
        this.intListPool.clear();
        this.joinClausesSwap1.clear();
        this.joinClausesSwap2.clear();
        this.queryFilterAnalyser.reset();
        this.constNameToIndex.clear();
        this.constNameToNode.clear();
        this.constNameToToken.clear();
    }

    private RecordSource compile(QueryModel model, Factory factory) throws ParserException {
        this.optimiseInvertedBooleans(model);
        this.optimiseOrderBy(model, 0);
        this.optimiseSubQueries(model, factory);
        this.createOrderHash(model);
        return this.compileNoOptimise(model, factory);
    }

    private RecordSource compileAggregates(RecordSource rs, QueryModel model) throws ParserException {
        AbstractCombinedRecordSource out;
        int n = this.aggregators.size();
        ExprNode sampleBy = model.getSampleBy();
        ObjList<AggregatorFunction> af = new ObjList<AggregatorFunction>(n);
        for (int i = 0; i < n; ++i) {
            QueryColumn qc = this.aggregators.get(i);
            VirtualColumn vc = this.virtualColumnBuilder.createVirtualColumn(model, qc.getAst(), rs.getMetadata());
            if (!(vc instanceof AggregatorFunction)) {
                throw QueryError.$(qc.getAst().position, "Internal configuration error. Not an aggregate");
            }
            vc.setName(qc.getAlias());
            af.add((AggregatorFunction)((Object)vc));
        }
        if (sampleBy == null) {
            out = new AggregatedRecordSource(rs, this.groupKeyColumns, af, this.configuration.getDbAggregatePage(), this.recordKeyCopierCompiler);
        } else {
            TimestampSampler sampler = SamplerFactory.from(sampleBy.token);
            if (sampler == null) {
                throw QueryError.$(sampleBy.position, "Invalid sample");
            }
            out = new ResampledRecordSource(rs, this.getTimestampIndex(model, model.getTimestamp(), rs.getMetadata()), this.groupKeyColumns, af, sampler, this.configuration.getDbAggregatePage(), this.recordKeyCopierCompiler);
        }
        return out;
    }

    private RecordSource compileAnalytic(RecordSource rs, QueryModel model) throws ParserException {
        int n = this.analyticColumns.size();
        this.grouppedAnalytic.clear();
        RecordMetadata metadata = rs.getMetadata();
        ObjList<AnalyticFunction> naturalOrderFunctions = null;
        boolean needCache = false;
        for (int i = 0; i < n; ++i) {
            boolean dismissOrder;
            VirtualColumn valueColumn;
            AnalyticColumn col = this.analyticColumns.getQuick(i);
            ObjList<VirtualColumn> partitionBy = null;
            int n2 = col.getPartitionBy().size();
            if (n2 > 0) {
                partitionBy = new ObjList<VirtualColumn>(n2);
                for (int j = 0; j < n2; ++j) {
                    partitionBy.add(this.virtualColumnBuilder.createVirtualColumn(model, col.getPartitionBy().getQuick(j), metadata));
                }
            }
            ExprNode ast = col.getAst();
            if (ast.paramCount > 1) {
                throw QueryError.$(col.getAst().position, "Too many arguments");
            }
            if (ast.paramCount == 1) {
                valueColumn = this.virtualColumnBuilder.createVirtualColumn(model, col.getAst().rhs, metadata);
                valueColumn.setName(col.getAlias());
            } else {
                valueColumn = null;
            }
            int osz = col.getOrderBy().size();
            AnalyticFunction f = AnalyticFunctionFactories.newInstance(this.configuration, ast.token, valueColumn, col.getAlias(), partitionBy, rs.supportsRowIdAccess(), osz > 0);
            if (f == null) {
                Misc.free(rs);
                throw QueryError.$(col.getAst().position, "Unknown function");
            }
            CharSequenceIntHashMap orderHash = model.getOrderHash();
            if (osz > 0 && orderHash.size() > 0) {
                dismissOrder = true;
                for (int j = 0; j < osz; ++j) {
                    ExprNode node = col.getOrderBy().getQuick(j);
                    int direction = col.getOrderByDirection().getQuick(j);
                    if (orderHash.get(node.token) == direction) continue;
                    dismissOrder = false;
                }
            } else {
                dismissOrder = false;
            }
            if (osz > 0 && !dismissOrder) {
                IntList order = this.toOrderIndices(metadata, col.getOrderBy(), col.getOrderByDirection());
                ObjList<AnalyticFunction> funcs = this.grouppedAnalytic.get(order);
                if (funcs == null) {
                    funcs = new ObjList();
                    this.grouppedAnalytic.put(order, funcs);
                }
                funcs.add(f);
                needCache = true;
                continue;
            }
            if (naturalOrderFunctions == null) {
                naturalOrderFunctions = new ObjList<AnalyticFunction>();
            }
            needCache = needCache || f.getType() != 1;
            naturalOrderFunctions.add(f);
        }
        if (needCache) {
            ObjList<RecordComparator> analyticComparators = new ObjList<RecordComparator>(this.grouppedAnalytic.size());
            ObjList<ObjList<AnalyticFunction>> functionGroups = new ObjList<ObjList<AnalyticFunction>>(this.grouppedAnalytic.size());
            for (ObjObjHashMap.Entry<IntList, ObjList<AnalyticFunction>> entry : this.grouppedAnalytic) {
                analyticComparators.add(this.cc.compile(metadata, (IntList)entry.key));
                functionGroups.add((ObjList<AnalyticFunction>)entry.value);
            }
            if (naturalOrderFunctions != null) {
                analyticComparators.add(null);
                functionGroups.add(naturalOrderFunctions);
            }
            if (rs.supportsRowIdAccess()) {
                return new CachedRowAnalyticRecordSource(this.configuration.getDbAnalyticWindowPage(), rs, analyticComparators, functionGroups);
            }
            return new CachedAnalyticRecordSource(this.configuration.getDbAnalyticWindowPage(), this.configuration.getDbSortKeyPage(), rs, analyticComparators, functionGroups);
        }
        return new AnalyticRecordSource(rs, naturalOrderFunctions);
    }

    private RecordSource compileJoins(QueryModel model, Factory factory) throws ParserException {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        IntList ordered = model.getOrderedJoinModels();
        RecordSource master = null;
        try {
            boolean needColumnNameHistogram = model.getColumns().size() > 0;
            model.getColumnNameHistogram().clear();
            int n = ordered.size();
            for (int i = 0; i < n; ++i) {
                int index = ordered.getQuick(i);
                QueryModel m = joinModels.getQuick(index);
                RecordSource slave = m.getRecordSource();
                slave = slave == null ? this.compileJournal(m, factory) : this.filter(m, slave);
                if (m.getAlias() != null) {
                    slave.getMetadata().setAlias(m.getAlias().token);
                }
                if (needColumnNameHistogram) {
                    model.createColumnNameHistogram(slave);
                }
                if (master == null) {
                    master = this.analyseAndCompileOrderBy(model, slave);
                } else {
                    switch (m.getJoinType()) {
                        case 3: {
                            master = new CrossJoinRecordSource(master, slave);
                            break;
                        }
                        case 4: {
                            master = this.createAsOfJoin(model.getTimestamp(), m, master, slave);
                            break;
                        }
                        default: {
                            master = this.createHashJoin(m, master, slave);
                        }
                    }
                }
                ExprNode filter = m.getPostJoinWhereClause();
                if (filter == null) continue;
                master = new FilteredRecordSource(master, this.virtualColumnBuilder.createVirtualColumn(model, filter, master.getMetadata()), filter);
            }
            if (this.joinModelIsFalse(model)) {
                return new NoOpJournalRecordSource(master);
            }
            return master;
        }
        catch (ParserException e) {
            Misc.free(master);
            throw e;
        }
    }

    private RecordSource compileJournal(QueryModel model, Factory factory) throws ParserException {
        SystemViewFactory systemViewFactory = SysFactories.getFactory(model.getJournalName().token);
        if (systemViewFactory != null) {
            return this.compileSysView(model, factory, systemViewFactory);
        }
        return this.compileJournal0(model, factory);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private RecordSource compileJournal0(QueryModel model, Factory factory) throws ParserException {
        void var5_9;
        void var6_25;
        block48: {
            ExprNode latestByNode;
            RecordColumnMetadata latestByMetadata;
            String latestByCol;
            Object t;
            block49: {
                RecordColumnMetadata filter;
                IntrinsicModel im;
                JournalPartitionSource journalPartitionSource;
                JournalMetadata journalMetadata;
                block50: {
                    ExprNode where;
                    this.applyLimit(model);
                    RecordMetadata metadata = model.getMetadata();
                    if (metadata == null) {
                        metadata = model.collectJournalMetadata(factory);
                    }
                    if (!(metadata instanceof JournalMetadata)) throw QueryError.$(0, "Internal error: invalid metadata");
                    journalMetadata = (JournalMetadata)metadata;
                    if (model.getAlias() != null) {
                        journalMetadata.setAlias(model.getAlias().token);
                    } else {
                        journalMetadata.setAlias(QueryModel.stripMarker(model.getJournalName().token));
                    }
                    journalPartitionSource = new JournalPartitionSource(journalMetadata, true);
                    t = null;
                    latestByCol = null;
                    latestByMetadata = null;
                    latestByNode = null;
                    if (model.getLatestBy() != null) {
                        latestByNode = model.getLatestBy();
                        if (latestByNode.type != 4) {
                            throw QueryError.$(latestByNode.position, "Column name expected");
                        }
                        latestByCol = model.translateAlias(latestByNode.token).toString();
                        int colIndex = journalMetadata.getColumnIndexQuiet(latestByCol);
                        if (colIndex == -1) {
                            throw QueryError.invalidColumn(latestByNode.position, latestByNode.token);
                        }
                        latestByMetadata = journalMetadata.getColumnQuick(colIndex);
                        int type = latestByMetadata.getType();
                        if (type != 8 && type != 7 && type != 4 && type != 5) {
                            throw QueryError.position(latestByNode.position).$("Expected symbol, string, int or long column, found: ").$(ColumnType.nameOf(type)).$();
                        }
                        if (!latestByMetadata.isIndexed()) {
                            throw QueryError.position(latestByNode.position).$("Column is not indexed").$();
                        }
                    }
                    if ((where = model.getWhereClause()) == null) break block49;
                    im = this.queryFilterAnalyser.extract(model, where, journalMetadata, latestByCol, this.getTimestampIndexQuiet(model.getTimestamp(), journalMetadata));
                    RecordColumnMetadata recordColumnMetadata = filter = im.filter != null ? this.virtualColumnBuilder.createVirtualColumn(model, im.filter, journalMetadata) : null;
                    if (filter != null) {
                        if (filter.getType() != 0) {
                            throw QueryError.$(im.filter.position, "Boolean expression expected");
                        }
                        if (filter.isConstant()) {
                            if (filter.getBool(null)) {
                                filter = null;
                            } else {
                                im.intrinsicValue = 2;
                            }
                        }
                    }
                    if (im.intrinsicValue != 2) break block50;
                    NoOpJournalPartitionSource noOpJournalPartitionSource = new NoOpJournalPartitionSource(journalMetadata);
                    break block48;
                }
                if (im.intervals != null) {
                    MultiIntervalPartitionSource multiIntervalPartitionSource = new MultiIntervalPartitionSource(journalPartitionSource, im.intervals);
                }
                if (latestByCol == null) {
                    if (im.keyColumn != null) {
                        switch (journalMetadata.getColumn(im.keyColumn).getType()) {
                            case 8: {
                                RowSource rowSource = this.buildRowSourceForSym(im);
                                break;
                            }
                            case 7: {
                                RowSource rowSource = this.buildRowSourceForStr(im);
                                break;
                            }
                            case 4: {
                                RowSource rowSource = this.buildRowSourceForInt(im);
                                break;
                            }
                            case 5: {
                                RowSource rowSource = this.buildRowSourceForLong(im);
                                break;
                            }
                        }
                    }
                    if (filter != null) {
                        void var6_15;
                        FilteredRowSource filteredRowSource = new FilteredRowSource((RowSource)(var6_15 == null ? new AllRowSource() : var6_15), (VirtualColumn)filter);
                    }
                    break block48;
                } else if (im.keyColumn != null && im.keyValuesIsLambda) {
                    int lambdaColIndex;
                    RecordSource lambda = this.compileSourceInternal(factory, im.keyValues.get(0));
                    RecordMetadata m = lambda.getMetadata();
                    switch (m.getColumnCount()) {
                        case 0: {
                            Misc.free(lambda);
                            throw QueryError.$(im.keyValuePositions.getQuick(0), "Query must select at least one column");
                        }
                        case 1: {
                            lambdaColIndex = 0;
                            break;
                        }
                        default: {
                            lambdaColIndex = m.getColumnIndexQuiet(latestByCol);
                            if (lambdaColIndex != -1) break;
                            Misc.free(lambda);
                            throw QueryError.$(im.keyValuePositions.getQuick(0), "Ambiguous column names in lambda query. Specify select clause");
                        }
                    }
                    int lambdaColType = m.getColumnQuick(lambdaColIndex).getType();
                    this.mutableSig.setParamCount(2).setName("").paramType(0, latestByMetadata.getType(), true).paramType(1, lambdaColType, false);
                    LatestByLambdaRowSourceFactory fact = LAMBDA_ROW_SOURCE_FACTORIES.get(this.mutableSig);
                    if (fact == null) {
                        Misc.free(lambda);
                        throw QueryError.$(im.keyValuePositions.getQuick(0), "Mismatched types");
                    }
                    RowSource rowSource = fact.newInstance(latestByCol, lambda, lambdaColIndex, (VirtualColumn)filter);
                    break block48;
                } else {
                    switch (latestByMetadata.getType()) {
                        case 8: {
                            if (im.keyColumn != null) {
                                KvIndexSymListHeadRowSource kvIndexSymListHeadRowSource = new KvIndexSymListHeadRowSource(latestByCol, new CharSequenceHashSet(im.keyValues), (VirtualColumn)filter);
                                break;
                            }
                            KvIndexSymAllHeadRowSource kvIndexSymAllHeadRowSource = new KvIndexSymAllHeadRowSource(latestByCol, (VirtualColumn)filter);
                            break;
                        }
                        case 7: {
                            if (im.keyColumn == null) {
                                Misc.free(t);
                                throw QueryError.$(latestByNode.position, "Filter on string column expected");
                            }
                            KvIndexStrListHeadRowSource kvIndexStrListHeadRowSource = new KvIndexStrListHeadRowSource(latestByCol, new CharSequenceHashSet(im.keyValues), (VirtualColumn)filter);
                            break;
                        }
                        case 5: {
                            if (im.keyColumn == null) {
                                Misc.free(t);
                                throw QueryError.$(latestByNode.position, "Filter on long column expected");
                            }
                            KvIndexLongListHeadRowSource kvIndexLongListHeadRowSource = new KvIndexLongListHeadRowSource(latestByCol, QueryCompiler.toLongHashSet(im), (VirtualColumn)filter);
                            break;
                        }
                        case 4: {
                            if (im.keyColumn == null) {
                                Misc.free(t);
                                throw QueryError.$(latestByNode.position, "Filter on int column expected");
                            }
                            KvIndexIntListHeadRowSource kvIndexIntListHeadRowSource = new KvIndexIntListHeadRowSource(latestByCol, QueryCompiler.toIntHashSet(im), (VirtualColumn)filter);
                            break;
                        }
                    }
                }
                break block48;
            }
            if (latestByCol != null) {
                switch (latestByMetadata.getType()) {
                    case 8: {
                        KvIndexSymAllHeadRowSource kvIndexSymAllHeadRowSource = new KvIndexSymAllHeadRowSource(latestByCol, null);
                        break;
                    }
                    default: {
                        Misc.free(t);
                        throw QueryError.$(latestByNode.position, "Only SYM columns can be used here without filter");
                    }
                }
            }
        }
        if (var6_25 == null && model.getColumns().size() == 1) {
            QueryColumn qc = model.getColumns().getQuick(0);
            if ("count".equals(qc.getAst().token) && qc.getAst().paramCount == 0) {
                String string;
                model.getOrderBy().clear();
                model.getColumns().clear();
                if (qc.getAlias() == null) {
                    string = "count";
                    return new CountRecordSource(string, (PartitionSource)var5_9);
                }
                string = qc.getAlias();
                return new CountRecordSource(string, (PartitionSource)var5_9);
            }
        }
        JournalRecordSource recordSource = new JournalRecordSource((PartitionSource)var5_9, (RowSource)(var6_25 == null ? new AllRowSource() : var6_25));
        if (!QueryModel.hasMarker(model.getJournalName().token)) return recordSource;
        return new NoRowIdRecordSource().of(recordSource);
    }

    private RecordSource compileNoOptimise(QueryModel model, Factory factory) throws ParserException {
        try {
            RecordSource rs;
            if (model.getJoinModels().size() > 1) {
                this.optimiseJoins(model, factory);
                rs = this.compileJoins(model, factory);
            } else if (model.getJournalName() != null) {
                rs = this.compileJournal(model, factory);
            } else {
                rs = this.compileSubQuery(model, factory);
                QueryModel nm = model.getNestedModel();
                if (nm != null) {
                    nm.setRecordSource(rs);
                }
            }
            return this.limit(this.timestamp(this.order(this.selectColumns(rs, model), model), model), model);
        }
        catch (ParserException e) {
            this.freeModelRecordSources(model);
            throw e;
        }
    }

    private RecordSource compileOuterVirtualColumns(RecordSource rs, QueryModel model) throws ParserException {
        ObjList<VirtualColumn> outer = new ObjList<VirtualColumn>(this.outerVirtualColumns.size());
        int n = this.outerVirtualColumns.size();
        for (int i = 0; i < n; ++i) {
            QueryColumn qc = this.outerVirtualColumns.get(i);
            VirtualColumn vc = this.virtualColumnBuilder.createVirtualColumn(model, qc.getAst(), rs.getMetadata());
            vc.setName(qc.getAlias());
            outer.add(vc);
        }
        return new VirtualColumnRecordSource(rs, outer);
    }

    private RecordSource compileSourceInternal(Factory factory, CharSequence query) throws ParserException {
        return this.compile((QueryModel)this.parser.parseInternal(query), factory);
    }

    private RecordSource compileSubQuery(QueryModel model, Factory factory) throws ParserException {
        this.applyLimit(model);
        return this.filter(model, this.compileNoOptimise(model.getNestedModel(), factory));
    }

    private RecordSource compileSysView(QueryModel model, Factory factory, SystemViewFactory systemViewFactory) throws ParserException {
        this.applyLimit(model);
        return this.filter(model, systemViewFactory.create(factory, this.env));
    }

    private ExprNode concatFilters(ExprNode old, ExprNode filter) {
        if (filter == null || filter == old) {
            return old;
        }
        if (old == null) {
            return filter;
        }
        ExprNode n = this.exprNodePool.next().of(1, "and", 0, 0);
        n.paramCount = 2;
        n.lhs = old;
        n.rhs = filter;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(Factory factory, RecordSource rs, JournalWriter w) throws JournalException {
        int tsIndex = w.getMetadata().getTimestampIndex();
        RecordCursor cursor = rs.prepareCursor(factory);
        try {
            if (tsIndex == -1) {
                this.copyNonPartitioned(cursor, w, this.copyHelperCompiler.compile(rs.getMetadata(), w.getMetadata()));
            } else {
                this.copyPartitioned(cursor, w, this.copyHelperCompiler.compile(rs.getMetadata(), w.getMetadata()), tsIndex);
            }
            w.commit();
        }
        finally {
            cursor.releaseCursor();
        }
    }

    private void copyNonPartitioned(RecordCursor cursor, JournalWriter w, CopyHelper helper) throws JournalException {
        while (cursor.hasNext()) {
            Record r = (Record)cursor.next();
            JournalEntryWriter ew = w.entryWriter();
            helper.copy(r, ew);
            ew.append();
        }
    }

    private void copyPartitioned(RecordCursor cursor, JournalWriter w, CopyHelper helper, int tsIndex) throws JournalException {
        while (cursor.hasNext()) {
            Record r = (Record)cursor.next();
            JournalEntryWriter ew = w.entryWriter(r.getDate(tsIndex));
            helper.copy(r, ew);
            ew.append();
        }
    }

    private String createAlias(int index) {
        this.columnNameAssembly.clear(this.columnNamePrefixLen);
        Numbers.append((CharSink)this.columnNameAssembly, index);
        return this.columnNameAssembly.toString();
    }

    private RecordSource createAsOfJoin(ExprNode masterTimestampNode, QueryModel model, RecordSource master, RecordSource slave) throws ParserException {
        JoinContext jc = model.getContext();
        ExprNode slaveTimestampNode = model.getTimestamp();
        RecordMetadata masterMetadata = master.getMetadata();
        RecordMetadata slaveMetadata = slave.getMetadata();
        int slaveTimestampIndex = this.getTimestampIndex(model, slaveTimestampNode, slaveMetadata);
        int masterTimestampIndex = this.getTimestampIndex(model, masterTimestampNode, masterMetadata);
        if (jc.bIndexes.size() == 0) {
            return new AsOfJoinRecordSource(master, masterTimestampIndex, slave, slaveTimestampIndex);
        }
        int sz = jc.aNames.size();
        CharSequenceHashSet slaveKeys = new CharSequenceHashSet();
        CharSequenceHashSet masterKeys = new CharSequenceHashSet();
        for (int i = 0; i < sz; ++i) {
            slaveKeys.add(jc.aNames.getQuick(i));
            masterKeys.add(jc.bNames.getQuick(i));
        }
        return new AsOfPartitionedJoinRecordSource(master, masterTimestampIndex, slave, slaveTimestampIndex, masterKeys, slaveKeys, this.configuration.getDbAsOfDataPage(), this.configuration.getDbAsOfIndexPage(), this.configuration.getDbAsOfRowPage(), this.recordKeyCopierCompiler);
    }

    private RecordSource createHashJoin(QueryModel model, RecordSource master, RecordSource slave) throws ParserException {
        JoinContext jc = model.getContext();
        RecordMetadata bm = master.getMetadata();
        RecordMetadata am = slave.getMetadata();
        IntList masterColIndices = null;
        IntList slaveColIndices = null;
        int kn = jc.aIndexes.size();
        for (int k = 0; k < kn; ++k) {
            CharSequence ca = jc.aNames.getQuick(k);
            CharSequence cb = jc.bNames.getQuick(k);
            int ia = am.getColumnIndex(ca);
            int ib = bm.getColumnIndex(cb);
            if (am.getColumnQuick(ia).getType() != bm.getColumnQuick(ib).getType()) {
                Misc.free(master);
                Misc.free(slave);
                throw QueryError.$(jc.aNodes.getQuick((int)k).position, "Column type mismatch");
            }
            if (masterColIndices == null) {
                masterColIndices = new IntList();
                slaveColIndices = new IntList();
            }
            masterColIndices.add(ib);
            slaveColIndices.add(ia);
        }
        return new HashJoinRecordSource(master, masterColIndices, slave, slaveColIndices, model.getJoinType() == 2, this.configuration.getDbHashKeyPage(), this.configuration.getDbHashDataPage(), this.configuration.getDbHashRowPage(), new RecordKeyCopierCompiler(new BytecodeAssembler()));
    }

    private void createImpliedDependencies(QueryModel parent) {
        ObjList<QueryModel> models = parent.getJoinModels();
        int n = models.size();
        for (int i = 0; i < n; ++i) {
            QueryModel m = models.getQuick(i);
            if (m.getJoinType() != 4) continue;
            this.linkDependencies(parent, 0, i);
            if (m.getContext() != null) continue;
            JoinContext jc = this.contextPool.next();
            m.setContext(jc);
            jc.parents.add(0);
            jc.slaveIndex = i;
        }
    }

    private void createOrderHash(QueryModel model) {
        block4: {
            QueryModel nestedModel;
            int m;
            ObjList<QueryColumn> columns;
            CharSequenceIntHashMap hash;
            block3: {
                hash = model.getOrderHash();
                hash.clear();
                ObjList<ExprNode> orderBy = model.getOrderBy();
                int n = orderBy.size();
                columns = model.getColumns();
                m = columns.size();
                nestedModel = model.getNestedModel();
                if (n <= 0) break block3;
                IntList orderByDirection = model.getOrderByDirection();
                for (int i = 0; i < n; ++i) {
                    hash.put(orderBy.getQuick((int)i).token, orderByDirection.getQuick(i));
                }
                break block4;
            }
            if (nestedModel == null || m <= 0) break block4;
            this.createOrderHash(nestedModel);
            CharSequenceIntHashMap thatHash = nestedModel.getOrderHash();
            if (thatHash.size() > 0) {
                for (int i = 0; i < m; ++i) {
                    int direction;
                    QueryColumn column = columns.getQuick(i);
                    ExprNode node = column.getAst();
                    if (node.type != 4 || (direction = thatHash.get(node.token)) == -1) continue;
                    hash.put(column.getName(), direction);
                }
            }
        }
    }

    private JournalStructure createStructure(String location, RecordMetadata rm, CharSequenceObjHashMap<ColumnCastModel> castModels) throws ParserException {
        int n = rm.getColumnCount();
        ObjList<ColumnMetadata> m = new ObjList<ColumnMetadata>(n);
        for (int i = 0; i < n; ++i) {
            ColumnMetadata cm = new ColumnMetadata();
            RecordColumnMetadata im = rm.getColumnQuick(i);
            cm.name = im.getName();
            int srcType = im.getType();
            ColumnCastModel castModel = castModels.get(cm.name);
            if (castModel != null) {
                this.validateTypeCastCompatibility(srcType, castModel);
                cm.type = castModel.getColumnType();
                if (cm.type == 8) {
                    cm.distinctCountHint = Numbers.ceilPow2(castModel.getCount()) - 1;
                }
            } else {
                cm.type = srcType;
            }
            switch (cm.type) {
                case 7: {
                    cm.size = cm.avgSize + 4;
                    break;
                }
                default: {
                    cm.size = ColumnType.sizeOf(cm.type);
                }
            }
            m.add(cm);
        }
        return new JournalStructure(location, m).$ts(rm.getTimestampIndex());
    }

    private CharSequence extractColumnName(CharSequence token, int dot) {
        return dot == -1 ? token : this.csPool.next().of(token, dot + 1, token.length() - dot - 1);
    }

    private RecordSource filter(QueryModel model, RecordSource rs) throws ParserException {
        try {
            if (model.getWhereClause() == null) {
                return rs;
            }
            RecordMetadata m = rs.getMetadata();
            if (model.getAlias() != null) {
                m.setAlias(model.getAlias().token);
            }
            int timestampIndex = this.getTimestampIndexQuiet(model.getTimestamp(), m);
            IntrinsicModel im = this.queryFilterAnalyser.extract(model, model.getWhereClause(), m, null, timestampIndex);
            if (im.intrinsicValue == 2) {
                return new NoOpJournalRecordSource(rs);
            }
            if (im.intervals != null) {
                rs = new IntervalRecordSource(rs, im.intervals, timestampIndex);
            }
            if (im.filter != null) {
                VirtualColumn vc = this.virtualColumnBuilder.createVirtualColumn(model, im.filter, m);
                if (vc.isConstant()) {
                    if (vc.getBool(null)) {
                        return rs;
                    }
                    return new NoOpJournalRecordSource(rs);
                }
                return new FilteredRecordSource(rs, vc, im.filter);
            }
            return rs;
        }
        catch (ParserException e) {
            Misc.free(rs);
            throw e;
        }
    }

    private void freeModelRecordSources(QueryModel model) {
        if (model == null) {
            return;
        }
        Misc.free(model.getRecordSource());
        this.freeModelRecordSources(model.getNestedModel());
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                this.freeModelRecordSources(joinModels.getQuick(i));
            }
        }
    }

    private int getTimestampIndex(QueryModel model, ExprNode node, RecordMetadata m) throws ParserException {
        int index = this.getTimestampIndexQuiet(node, m);
        int pos = model.getJournalName() != null ? model.getJournalName().position : 0;
        switch (index) {
            case -1: {
                throw QueryError.position(pos).$("Missing timestamp").$();
            }
            case -2: {
                throw QueryError.position(pos).$("Ambiguous timestamp column").$();
            }
        }
        return index;
    }

    private int getTimestampIndexQuiet(ExprNode node, RecordMetadata m) throws ParserException {
        if (node != null) {
            if (node.type != 4) {
                throw QueryError.position(node.position).$("Literal expression expected").$();
            }
            int index = m.getColumnIndexQuiet(node.token);
            if (index == -1) {
                throw QueryError.position(node.position).$("Invalid column: ").$(node.token).$();
            }
            return index;
        }
        return m.getTimestampIndex();
    }

    private boolean hasAggregates(ExprNode node) {
        this.exprNodeStack.clear();
        block4: while (!this.exprNodeStack.isEmpty() || node != null) {
            if (node != null) {
                switch (node.type) {
                    case 4: {
                        node = null;
                        continue block4;
                    }
                    case 8: {
                        if (!FunctionFactories.isAggregate(node.token)) break;
                        return true;
                    }
                    default: {
                        if (node.rhs == null) break;
                        this.exprNodeStack.push(node.rhs);
                    }
                }
                node = node.lhs;
                continue;
            }
            node = this.exprNodeStack.poll();
        }
        return false;
    }

    private void homogenizeCrossJoins(QueryModel parent) {
        ObjList<QueryModel> joinModels = parent.getJoinModels();
        int n = joinModels.size();
        for (int i = 0; i < n; ++i) {
            QueryModel m = joinModels.getQuick(i);
            JoinContext c = m.getContext();
            if (m.getJoinType() == 3) {
                if (c == null || c.parents.size() <= 0) continue;
                m.setJoinType(1);
                continue;
            }
            if (m.getJoinType() == 4 || c != null && c.parents.size() != 0) continue;
            m.setJoinType(3);
        }
    }

    private boolean joinModelIsFalse(QueryModel model) throws ParserException {
        ExprNode current = null;
        IntHashSet constants = model.getParsedWhereConsts();
        ObjList<ExprNode> whereNodes = model.getParsedWhere();
        int n = constants.size();
        for (int i = 0; i < n; ++i) {
            current = this.concatFilters(current, whereNodes.getQuick(constants.get(i)));
        }
        if (current == null) {
            return false;
        }
        VirtualColumn col = this.virtualColumnBuilder.createVirtualColumn(model, current, null);
        if (col.isConstant()) {
            if (col.getType() != 0) {
                throw QueryError.$(current.position, "Boolean expression expected");
            }
            return !col.getBool(null);
        }
        throw QueryError.$(0, "Internal error: expected constant");
    }

    private RecordSource limit(RecordSource rs, QueryModel model) {
        if (model.getLimitLoVc() == null || model.getLimitHiVc() == null) {
            return rs;
        }
        return new TopRecordSource(rs, model.getLimitLoVc(), model.getLimitHiVc());
    }

    private VirtualColumn limitToVirtualColumn(QueryModel model, ExprNode node) throws ParserException {
        switch (node.type) {
            case 4: {
                if (!Chars.startsWith((CharSequence)node.token, ':')) break;
                return Parameter.getOrCreate(node, model.getParameterMap());
            }
            case 2: {
                try {
                    return new LongConstant(Numbers.parseLong(node.token), node.position);
                }
                catch (NumericException e) {
                    throw QueryError.$(node.position, "Long number expected");
                }
            }
        }
        throw QueryError.$(node.position, "Constant expected");
    }

    private void linkDependencies(QueryModel model, int parent, int child) {
        model.getJoinModels().getQuick(parent).addDependency(child);
    }

    private JoinContext mergeContexts(QueryModel parent, JoinContext a, JoinContext b) {
        int i;
        assert (a.slaveIndex == b.slaveIndex);
        this.deletedContexts.clear();
        JoinContext r = this.contextPool.next();
        int n = b.aNames.size();
        for (i = 0; i < n; ++i) {
            CharSequence ban = b.aNames.getQuick(i);
            int bai = b.aIndexes.getQuick(i);
            ExprNode bao = b.aNodes.getQuick(i);
            CharSequence bbn = b.bNames.getQuick(i);
            int bbi = b.bIndexes.getQuick(i);
            ExprNode bbo = b.bNodes.getQuick(i);
            int z = a.aNames.size();
            for (int k = 0; k < z; ++k) {
                if (this.deletedContexts.contains(k)) continue;
                CharSequence aan = a.aNames.getQuick(k);
                int aai = a.aIndexes.getQuick(k);
                ExprNode aao = a.aNodes.getQuick(k);
                CharSequence abn = a.bNames.getQuick(k);
                int abi = a.bIndexes.getQuick(k);
                ExprNode abo = a.bNodes.getQuick(k);
                if (aai == bai && Chars.equals(aan, ban)) {
                    this.addFilterOrEmitJoin(parent, k, abi, abn, abo, bbi, bbn, bbo);
                    break;
                }
                if (abi == bai && Chars.equals(abn, ban)) {
                    this.addFilterOrEmitJoin(parent, k, aai, aan, aao, bbi, bbn, bbo);
                    break;
                }
                if (aai == bbi && Chars.equals(aan, bbn)) {
                    this.addFilterOrEmitJoin(parent, k, abi, abn, abo, bai, ban, bao);
                    break;
                }
                if (abi != bbi || !Chars.equals(abn, bbn)) continue;
                this.addFilterOrEmitJoin(parent, k, aai, aan, aao, bai, ban, bao);
                break;
            }
            r.aIndexes.add(bai);
            r.aNames.add(ban);
            r.aNodes.add(bao);
            r.bIndexes.add(bbi);
            r.bNames.add(bbn);
            r.bNodes.add(bbo);
            int max = bai > bbi ? bai : bbi;
            int min = bai < bbi ? bai : bbi;
            r.slaveIndex = max;
            r.parents.add(min);
            this.linkDependencies(parent, min, max);
        }
        n = a.aNames.size();
        for (i = 0; i < n; ++i) {
            int max;
            int min;
            int abi;
            int aai = a.aIndexes.getQuick(i);
            if (aai < (abi = a.bIndexes.getQuick(i))) {
                min = aai;
                max = abi;
            } else {
                min = abi;
                max = aai;
            }
            if (this.deletedContexts.contains(i)) {
                if (r.parents.contains(min)) continue;
                this.unlinkDependencies(parent, min, max);
                continue;
            }
            r.aNames.add(a.aNames.getQuick(i));
            r.bNames.add(a.bNames.getQuick(i));
            r.aIndexes.add(aai);
            r.bIndexes.add(abi);
            r.aNodes.add(a.aNodes.getQuick(i));
            r.bNodes.add(a.bNodes.getQuick(i));
            r.parents.add(min);
            this.linkDependencies(parent, min, max);
        }
        return r;
    }

    private JoinContext moveClauses(QueryModel parent, JoinContext from, JoinContext to, IntList positions) {
        int p = 0;
        int m = positions.size();
        if (m == 0) {
            return from;
        }
        JoinContext result = this.contextPool.next();
        result.slaveIndex = from.slaveIndex;
        int n = from.aIndexes.size();
        for (int i = 0; i < n; ++i) {
            JoinContext t = p < m && i == positions.getQuick(p) ? to : result;
            int ai = from.aIndexes.getQuick(i);
            int bi = from.bIndexes.getQuick(i);
            t.aIndexes.add(ai);
            t.aNames.add(from.aNames.getQuick(i));
            t.aNodes.add(from.aNodes.getQuick(i));
            t.bIndexes.add(bi);
            t.bNames.add(from.bNames.getQuick(i));
            t.bNodes.add(from.bNodes.getQuick(i));
            if (ai != t.slaveIndex) {
                t.parents.add(ai);
                this.linkDependencies(parent, ai, bi);
                continue;
            }
            t.parents.add(bi);
            this.linkDependencies(parent, bi, ai);
        }
        return result;
    }

    ExprNode optimiseInvertedBooleans(ExprNode node, boolean reverse) throws ParserException {
        switch (node.token) {
            case "not": {
                if (reverse) {
                    return this.optimiseInvertedBooleans(node.rhs, false);
                }
                switch (node.rhs.type) {
                    case 2: 
                    case 4: {
                        return node;
                    }
                }
                QueryCompiler.assertNotNull(node.rhs, node.position, "Missing right argument");
                return this.optimiseInvertedBooleans(node.rhs, true);
            }
            case "and": {
                if (reverse) {
                    node.token = "or";
                }
                QueryCompiler.assertNotNull(node.lhs, node.position, "Missing left argument");
                QueryCompiler.assertNotNull(node.rhs, node.position, "Missing right argument");
                node.lhs = this.optimiseInvertedBooleans(node.lhs, reverse);
                node.rhs = this.optimiseInvertedBooleans(node.rhs, reverse);
                return node;
            }
            case "or": {
                if (reverse) {
                    node.token = "and";
                }
                QueryCompiler.assertNotNull(node.lhs, node.position, "Missing left argument");
                QueryCompiler.assertNotNull(node.rhs, node.position, "Missing right argument");
                node.lhs = this.optimiseInvertedBooleans(node.lhs, reverse);
                node.rhs = this.optimiseInvertedBooleans(node.rhs, reverse);
                return node;
            }
            case ">": {
                if (reverse) {
                    node.token = "<=";
                }
                return node;
            }
            case ">=": {
                if (reverse) {
                    node.token = "<";
                }
                return node;
            }
            case "<": {
                if (reverse) {
                    node.token = ">=";
                }
                return node;
            }
            case "<=": {
                if (reverse) {
                    node.token = ">";
                }
                return node;
            }
            case "=": {
                if (reverse) {
                    node.token = "!=";
                }
                return node;
            }
            case "!=": {
                if (reverse) {
                    node.token = "=";
                }
                return node;
            }
        }
        if (reverse) {
            ExprNode n = this.exprNodePool.next();
            n.token = "not";
            n.paramCount = 1;
            n.rhs = node;
            n.type = 1;
            return n;
        }
        return node;
    }

    private void optimiseInvertedBooleans(QueryModel model) throws ParserException {
        ExprNode where = model.getWhereClause();
        if (where != null) {
            model.setWhereClause(this.optimiseInvertedBooleans(where, false));
        }
        if (model.getNestedModel() != null) {
            this.optimiseInvertedBooleans(model.getNestedModel());
        }
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        for (int i = 0; i < n; ++i) {
            QueryModel m = joinModels.getQuick(i);
            if (m == model) continue;
            this.optimiseInvertedBooleans(joinModels.getQuick(i));
        }
    }

    private void optimiseJoins(QueryModel parent, Factory factory) throws ParserException {
        ObjList<QueryModel> joinModels = parent.getJoinModels();
        int n = joinModels.size();
        if (n > 1) {
            for (int i = 0; i < n; ++i) {
                this.resolveJoinMetadata(parent, i, factory);
            }
            this.emittedJoinClauses = this.joinClausesSwap1;
            ExprNode where = parent.getWhereClause();
            parent.setWhereClause(null);
            this.processJoinConditions(parent, where);
            for (int i = 1; i < n; ++i) {
                this.processJoinConditions(parent, joinModels.getQuick(i).getJoinCriteria());
            }
            if (this.emittedJoinClauses.size() > 0) {
                this.processEmittedJoinClauses(parent);
            }
            this.createImpliedDependencies(parent);
            this.reorderJournals(parent);
            this.homogenizeCrossJoins(parent);
            this.assignFilters(parent);
            this.alignJoinClauses(parent);
            this.addTransitiveFilters(parent);
        }
    }

    private void optimiseOrderBy(QueryModel model, int orderByState) {
        int subQueryOrderByState;
        ObjList<QueryColumn> columns = model.getColumns();
        int n = columns.size();
        block0 : switch (orderByState) {
            case 0: {
                subQueryOrderByState = 1;
                if (model.getSampleBy() != null) break;
                for (int i = 0; i < n; ++i) {
                    QueryColumn col = columns.getQuick(i);
                    if (!this.hasAggregates(col.getAst())) continue;
                    subQueryOrderByState = 2;
                    break block0;
                }
                break;
            }
            case 1: {
                if (model.getOrderBy().size() > 0) {
                    subQueryOrderByState = 2;
                    break;
                }
                subQueryOrderByState = 1;
                break;
            }
            default: {
                model.getOrderBy().clear();
                subQueryOrderByState = model.getSampleBy() != null ? 1 : 2;
            }
        }
        ObjList<QueryModel> jm = model.getJoinModels();
        int k = jm.size();
        for (int i = 0; i < k; ++i) {
            QueryModel qm = jm.getQuick(i).getNestedModel();
            if (qm == null) continue;
            this.optimiseOrderBy(qm, subQueryOrderByState);
        }
    }

    private void optimiseSubQueries(QueryModel model, Factory factory) throws ParserException {
        QueryModel nm;
        int i;
        ObjList<QueryModel> jm = model.getJoinModels();
        ObjList<ExprNode> where = model.parseWhereClause();
        ExprNode thisWhere = null;
        int n = jm.size();
        for (i = 0; i < n; ++i) {
            nm = jm.getQuick(i).getNestedModel();
            if (nm == null) continue;
            nm.createColumnNameHistogram(factory);
        }
        int k = where.size();
        for (int j = 0; j < k; ++j) {
            ExprNode node = where.getQuick(j);
            int matchModel = -1;
            int n2 = jm.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                QueryModel qm = jm.getQuick(i2);
                nm = qm.getNestedModel();
                if (nm == null || !this.literalMatcher.matches(node, nm.getColumnNameHistogram(), qm.getAlias() != null ? qm.getAlias().token : null)) continue;
                if (matchModel > -1) {
                    throw QueryError.ambiguousColumn(node.position);
                }
                matchModel = i2;
            }
            if (matchModel > -1) {
                nm = jm.getQuick(matchModel).getNestedModel();
                nm.setWhereClause(this.concatFilters(nm.getWhereClause(), node));
                continue;
            }
            thisWhere = this.concatFilters(thisWhere, node);
        }
        model.getParsedWhere().clear();
        model.setWhereClause(thisWhere);
        n = jm.size();
        for (i = 0; i < n; ++i) {
            QueryModel qm = jm.getQuick(i);
            nm = qm.getNestedModel();
            if (nm == null) continue;
            this.optimiseSubQueries(nm, factory);
        }
    }

    private RecordSource order(RecordSource rs, QueryModel model) throws ParserException {
        ObjList<ExprNode> orderBy = model.getOrderBy();
        if (orderBy.size() > 0) {
            try {
                RecordMetadata m = rs.getMetadata();
                return new RBTreeSortedRecordSource(rs, this.cc.compile(m, this.toOrderIndices(m, orderBy, model.getOrderByDirection())), this.configuration.getDbSortKeyPage(), this.configuration.getDbSortDataPage());
            }
            catch (ParserException e) {
                Misc.free(rs);
                throw e;
            }
        }
        return rs;
    }

    CharSequence plan(Factory factory, CharSequence query) throws ParserException {
        QueryModel model = (QueryModel)this.parser.parse(query);
        this.resetAndOptimise(model, factory);
        return model.plan();
    }

    private void processEmittedJoinClauses(QueryModel model) {
        do {
            ObjList<JoinContext> clauses;
            this.emittedJoinClauses = (clauses = this.emittedJoinClauses) == this.joinClausesSwap1 ? this.joinClausesSwap2 : this.joinClausesSwap1;
            this.emittedJoinClauses.clear();
            int k = clauses.size();
            for (int i = 0; i < k; ++i) {
                this.addJoinContext(model, clauses.getQuick(i));
            }
        } while (this.emittedJoinClauses.size() > 0);
    }

    private void processJoinConditions(QueryModel parent, ExprNode node) throws ParserException {
        ExprNode n = node;
        this.exprNodeStack.clear();
        block12: while (!this.exprNodeStack.isEmpty() || n != null) {
            if (n != null) {
                switch (n.token) {
                    case "and": {
                        if (n.rhs != null) {
                            this.exprNodeStack.push(n.rhs);
                        }
                        n = n.lhs;
                        continue block12;
                    }
                    case "=": {
                        this.analyseEquals(parent, n);
                        n = null;
                        continue block12;
                    }
                    case "or": {
                        this.processOrConditions(parent, n);
                        n = null;
                        continue block12;
                    }
                    case "~": {
                        this.analyseRegex(parent, n);
                    }
                }
                parent.addParsedWhereNode(n);
                n = null;
                continue;
            }
            n = this.exprNodeStack.poll();
        }
    }

    private void processOrConditions(QueryModel parent, ExprNode node) {
        parent.addParsedWhereNode(node);
    }

    private void renameJournal(Factory factory, RenameJournalModel model) throws ParserException {
        String from = Chars.stripQuotes(model.getFrom().token);
        String to = Chars.stripQuotes(model.getTo().token);
        try {
            factory.rename(from, to);
        }
        catch (JournalException e) {
            throw QueryError.position(model.getFrom().position).$(e.getMessage()).$();
        }
    }

    private void reorderJournals(QueryModel parent) throws ParserException {
        ObjList<QueryModel> joinModels = parent.getJoinModels();
        int n = joinModels.size();
        this.tempCrosses.clear();
        for (int i = 0; i < n; ++i) {
            QueryModel q = joinModels.getQuick(i);
            if (q.getContext() != null && q.getContext().parents.size() != 0) continue;
            this.tempCrosses.add(i);
        }
        int cost = Integer.MAX_VALUE;
        int root = -1;
        int zc = this.tempCrosses.size();
        for (int z = 0; z < zc; ++z) {
            for (int i = 0; i < zc; ++i) {
                int k;
                if (z == i) continue;
                int to = this.tempCrosses.getQuick(i);
                JoinContext jc = joinModels.getQuick(to).getContext();
                for (k = i - 1; k > -1 && this.swapJoinOrder(parent, to, k, jc); --k) {
                }
                for (k = i + 1; k < n && this.swapJoinOrder(parent, to, k, jc); ++k) {
                }
            }
            IntList ordered = parent.nextOrderedJoinModels();
            int thisCost = this.reorderJournals0(parent, ordered);
            if (thisCost >= cost) continue;
            root = z;
            cost = thisCost;
            parent.setOrderedJoinModels(ordered);
        }
        if (root == -1) {
            throw QueryError.$(0, "Cycle");
        }
    }

    private int reorderJournals0(QueryModel parent, IntList ordered) {
        int i;
        this.tempCrossIndexes.clear();
        ordered.clear();
        this.orderingStack.clear();
        ObjList<QueryModel> joinModels = parent.getJoinModels();
        int cost = 0;
        int n = joinModels.size();
        for (i = 0; i < n; ++i) {
            QueryModel q = joinModels.getQuick(i);
            if (q.getJoinType() == 3 || q.getContext() == null || q.getContext().parents.size() == 0) {
                if (q.getDependencies().size() > 0) {
                    this.orderingStack.push(i);
                    continue;
                }
                this.tempCrossIndexes.add(i);
                continue;
            }
            q.getContext().inCount = q.getContext().parents.size();
        }
        while (this.orderingStack.notEmpty()) {
            int index = this.orderingStack.pop();
            ordered.add(index);
            QueryModel m = joinModels.getQuick(index);
            switch (m.getJoinType()) {
                case 3: {
                    cost += 10;
                    break;
                }
                default: {
                    cost += 5;
                }
            }
            IntHashSet dependencies = m.getDependencies();
            int k = dependencies.size();
            for (int i2 = 0; i2 < k; ++i2) {
                int depIndex = dependencies.get(i2);
                JoinContext jc = joinModels.getQuick(depIndex).getContext();
                if (--jc.inCount != 0) continue;
                this.orderingStack.push(depIndex);
            }
        }
        n = joinModels.size();
        for (i = 0; i < n; ++i) {
            QueryModel m = joinModels.getQuick(i);
            if (m.getContext() == null || m.getContext().inCount <= 0) continue;
            return Integer.MAX_VALUE;
        }
        n = this.tempCrossIndexes.size();
        for (i = 0; i < n; ++i) {
            ordered.add(this.tempCrossIndexes.getQuick(i));
        }
        return cost;
    }

    private ExprNode replaceIfAggregate(ExprNode node, ObjList<QueryColumn> aggregateColumns) {
        if (node != null && FunctionFactories.isAggregate(node.token)) {
            QueryColumn c = this.aggregateColumnPool.next().of(this.createAlias(this.aggregateColumnSequence++), node.position, node);
            aggregateColumns.add(c);
            return this.exprNodePool.next().of(4, c.getAlias(), 0, 0);
        }
        return node;
    }

    private void resetAndOptimise(QueryModel model, Factory factory) throws ParserException {
        this.clearState();
        this.optimiseJoins(model, factory);
    }

    private void resolveJoinMetadata(QueryModel parent, int index, Factory factory) throws ParserException {
        RecordMetadata metadata;
        QueryModel model = parent.getJoinModels().getQuick(index);
        if (model.getJournalName() != null) {
            metadata = model.collectJournalMetadata(factory);
            model.setMetadata(metadata);
        } else {
            RecordSource rs = this.compileNoOptimise(model.getNestedModel(), factory);
            metadata = rs.getMetadata();
            model.setMetadata(metadata);
            model.setRecordSource(rs);
        }
        if (model.getAlias() != null) {
            if (!parent.addAliasIndex(model.getAlias(), index)) {
                throw QueryError.$(model.getAlias().position, "Duplicate alias");
            }
            metadata.setAlias(model.getAlias().token);
        } else if (model.getJournalName() != null) {
            parent.addAliasIndex(model.getJournalName(), index);
            metadata.setAlias(model.getJournalName().token);
        }
    }

    private int resolveJournalIndex(QueryModel parent, CharSequence alias, CharSequence col, int position) throws ParserException {
        CharSequence column = parent.translateAlias(col);
        ObjList<QueryModel> joinModels = parent.getJoinModels();
        int index = -1;
        if (alias == null) {
            int n = joinModels.size();
            for (int i = 0; i < n; ++i) {
                RecordMetadata m = joinModels.getQuick(i).getMetadata();
                if (m.getColumnIndexQuiet(column) == -1) continue;
                if (index > -1) {
                    throw QueryError.ambiguousColumn(position);
                }
                index = i;
            }
            if (index == -1) {
                throw QueryError.invalidColumn(position, column);
            }
            return index;
        }
        index = parent.getAliasIndex(alias);
        if (index == -1) {
            throw QueryError.$(position, "Invalid journal name/alias");
        }
        RecordMetadata m = joinModels.getQuick(index).getMetadata();
        if (m.getColumnIndexQuiet(column) == -1) {
            throw QueryError.invalidColumn(position, column);
        }
        return index;
    }

    private RecordSource selectColumns(RecordSource rs, QueryModel model) throws ParserException {
        return model.getColumns().size() == 0 ? rs : this.selectColumns0(rs, model);
    }

    private RecordSource selectColumns0(RecordSource recordSource, QueryModel model) throws ParserException {
        ObjList<QueryColumn> columns = model.getColumns();
        CharSequenceIntHashMap columnNameHistogram = model.getColumnNameHistogram();
        RecordMetadata meta = recordSource.getMetadata();
        this.outerVirtualColumns.clear();
        this.innerVirtualColumn.clear();
        this.aggregators.clear();
        this.selectedColumns.clear();
        this.selectedColumnAliases.clear();
        this.groupKeyColumns.clear();
        this.aggregateColumnSequence = 0;
        this.analyticColumns.clear();
        RecordSource rs = recordSource;
        try {
            int k = columns.size();
            for (int i = 0; i < k; ++i) {
                QueryColumn qc = columns.getQuick(i);
                ExprNode node = qc.getAst();
                boolean analytic = qc instanceof AnalyticColumn;
                if (!analytic && node.type == 4) {
                    if (meta.getColumnIndexQuiet(node.token) == -1) {
                        throw QueryError.invalidColumn(node.position, node.token);
                    }
                    if (columnNameHistogram.get(node.token) > 0) {
                        throw QueryError.ambiguousColumn(node.position);
                    }
                    this.selectedColumns.add(node.token);
                    this.addAlias(node.position, qc.getName());
                    this.groupKeyColumns.add(node.token);
                    continue;
                }
                if (qc.getAlias() == null) {
                    qc.of(this.createAlias(this.aggregateColumnSequence++), node.position, node);
                }
                this.selectedColumns.add(qc.getAlias());
                this.addAlias(node.position, qc.getAlias());
                if (!analytic && node.type == 8 && FunctionFactories.isAggregate(node.token)) {
                    this.aggregators.add(qc);
                    continue;
                }
                if (node.type == 1 || node.type == 8) {
                    int beforeSplit = this.aggregators.size();
                    this.splitAggregates(node, this.aggregators);
                    if (beforeSplit < this.aggregators.size()) {
                        this.outerVirtualColumns.add(qc);
                        continue;
                    }
                }
                if (analytic) {
                    if (qc.getAst().type != 8) {
                        throw QueryError.$(qc.getAst().position, "Analytic function expected");
                    }
                    if (this.aggregators.size() > 0) {
                        throw QueryError.$(qc.getAst().position, "Analytic function is not allowed in context of aggregation. Use sub-query.");
                    }
                    AnalyticColumn ac = (AnalyticColumn)qc;
                    this.analyticColumns.add(ac);
                    continue;
                }
                this.innerVirtualColumn.add(qc);
            }
            if (this.innerVirtualColumn.size() > 0) {
                ObjList<VirtualColumn> virtualColumns = new ObjList<VirtualColumn>();
                String timestampName = model.getSampleBy() != null ? meta.getColumnName(this.getTimestampIndex(model, model.getTimestamp(), meta)) : null;
                int n = this.innerVirtualColumn.size();
                for (int i = 0; i < n; ++i) {
                    QueryColumn qc = this.innerVirtualColumn.getQuick(i);
                    if (Chars.equalsNc(qc.getAlias(), timestampName)) {
                        throw QueryError.$(qc.getAliasPosition() == -1 ? qc.getAst().position : qc.getAliasPosition(), "Alias clashes with implicit sample column name");
                    }
                    VirtualColumn vc = this.virtualColumnBuilder.createVirtualColumn(model, qc.getAst(), meta);
                    vc.setName(qc.getAlias());
                    virtualColumns.add(vc);
                    this.groupKeyColumns.add(qc.getAlias());
                }
                rs = new VirtualColumnRecordSource(rs, virtualColumns);
            }
            if (this.aggregators.size() > 0) {
                rs = this.compileAggregates(rs, model);
            } else {
                ExprNode sampleBy = model.getSampleBy();
                if (sampleBy != null) {
                    throw QueryError.$(sampleBy.position, "There are no aggregation columns");
                }
            }
            if (this.outerVirtualColumns.size() > 0) {
                rs = this.compileOuterVirtualColumns(rs, model);
            }
            if (this.analyticColumns.size() > 0) {
                rs = this.compileAnalytic(rs, model);
            }
            if (this.selectedColumns.size() > 0) {
                rs = new SelectedColumnsRecordSource(rs, this.selectedColumns, this.selectedColumnAliases);
            }
            return rs;
        }
        catch (ParserException e) {
            Misc.free(rs);
            throw e;
        }
    }

    private void splitAggregates(ExprNode node, ObjList<QueryColumn> aggregateColumns) {
        this.exprNodeStack.clear();
        while (!this.exprNodeStack.isEmpty() || node != null) {
            if (node != null) {
                ExprNode n;
                if (node.rhs != null) {
                    n = this.replaceIfAggregate(node.rhs, aggregateColumns);
                    if (node.rhs == n) {
                        this.exprNodeStack.push(node.rhs);
                    } else {
                        node.rhs = n;
                    }
                }
                if ((n = this.replaceIfAggregate(node.lhs, aggregateColumns)) == node.lhs) {
                    node = node.lhs;
                    continue;
                }
                node.lhs = n;
                node = null;
                continue;
            }
            node = this.exprNodeStack.poll();
        }
    }

    private boolean swapJoinOrder(QueryModel parent, int to, int from, JoinContext context) {
        ObjList<QueryModel> joinModels = parent.getJoinModels();
        QueryModel jm = joinModels.getQuick(from);
        if (joinBarriers.contains(jm.getJoinType())) {
            return false;
        }
        JoinContext jc = context;
        this.clausesToSteal.clear();
        JoinContext that = jm.getContext();
        if (that != null && that.parents.contains(to)) {
            int zc = that.aIndexes.size();
            for (int z = 0; z < zc; ++z) {
                if (that.aIndexes.getQuick(z) != to && that.bIndexes.getQuick(z) != to) continue;
                this.clausesToSteal.add(z);
            }
            if (this.clausesToSteal.size() < zc) {
                QueryModel target = joinModels.getQuick(to);
                target.getDependencies().clear();
                if (jc == null) {
                    jc = this.contextPool.next();
                    target.setContext(jc);
                }
                jc.slaveIndex = to;
                jm.setContext(this.moveClauses(parent, that, jc, this.clausesToSteal));
                if (target.getJoinType() == 3) {
                    target.setJoinType(1);
                }
            }
        }
        return true;
    }

    private RecordSource timestamp(RecordSource rs, QueryModel model) throws ParserException {
        try {
            ExprNode timestamp = model.getTimestamp();
            if (timestamp == null) {
                return rs;
            }
            int index = rs.getMetadata().getColumnIndexQuiet(timestamp.token);
            if (index == -1) {
                throw QueryError.invalidColumn(timestamp.position, timestamp.token);
            }
            return new TimestampRelocatingRecordSource(rs, index);
        }
        catch (ParserException e) {
            Misc.free(rs);
            throw e;
        }
    }

    private int toInt(CharSequence cs, int pos) throws ParserException {
        try {
            return Numbers.parseInt(cs);
        }
        catch (NumericException e) {
            throw QueryError.$(pos, "int value expected");
        }
    }

    private long toLong(CharSequence cs, int pos) throws ParserException {
        try {
            return Numbers.parseLong(cs);
        }
        catch (NumericException e) {
            throw QueryError.$(pos, "long value expected");
        }
    }

    private IntList toOrderIndices(RecordMetadata m, ObjList<ExprNode> orderBy, IntList orderByDirection) throws ParserException {
        IntList indices = this.intListPool.next();
        int n = orderBy.size();
        for (int i = 0; i < n; ++i) {
            ExprNode tok = orderBy.getQuick(i);
            int index = m.getColumnIndexQuiet(tok.token);
            if (index == -1) {
                throw QueryError.invalidColumn(tok.position, tok.token);
            }
            ++index;
            if (orderByDirection.getQuick(i) == 1) {
                index = -index;
            }
            indices.add(index);
        }
        return indices;
    }

    private void traverseNamesAndIndices(QueryModel parent, ExprNode node) throws ParserException {
        this.literalCollectorAIndexes.clear();
        this.literalCollectorBIndexes.clear();
        this.literalCollectorANames.clear();
        this.literalCollectorBNames.clear();
        this.literalCollector.withParent(parent);
        this.literalCollector.resetNullCount();
        this.traversalAlgo.traverse(node.lhs, this.literalCollector.lhs());
        this.traversalAlgo.traverse(node.rhs, this.literalCollector.rhs());
    }

    private void unlinkDependencies(QueryModel model, int parent, int child) {
        model.getJoinModels().getQuick(parent).removeDependency(child);
    }

    private void validateTypeCastCompatibility(int srcType, ColumnCastModel castModel) throws ParserException {
        boolean incompatible;
        int dstType = castModel.getColumnType();
        block0 : switch (srcType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                switch (dstType) {
                    case 0: 
                    case 7: 
                    case 8: 
                    case 9: {
                        incompatible = true;
                        break block0;
                    }
                }
                incompatible = false;
                break;
            }
            case 7: 
            case 8: {
                switch (dstType) {
                    case 7: 
                    case 8: {
                        incompatible = false;
                        break block0;
                    }
                }
                incompatible = true;
                break;
            }
            default: {
                incompatible = true;
            }
        }
        if (incompatible) {
            throw QueryError.position(castModel.getColumnTypePos()).$("Incompatible cast: ").$(ColumnType.nameOf(srcType)).$(" as ").$(ColumnType.nameOf(dstType)).$();
        }
    }

    static {
        joinBarriers.add(2);
        joinBarriers.add(4);
        LAMBDA_ROW_SOURCE_FACTORIES.put(QueryCompiler.lbs(8, 8), KvIndexSymSymLambdaHeadRowSource.FACTORY);
        LAMBDA_ROW_SOURCE_FACTORIES.put(QueryCompiler.lbs(8, 7), KvIndexSymStrLambdaHeadRowSource.FACTORY);
        LAMBDA_ROW_SOURCE_FACTORIES.put(QueryCompiler.lbs(4, 4), KvIndexIntLambdaHeadRowSource.FACTORY);
        LAMBDA_ROW_SOURCE_FACTORIES.put(QueryCompiler.lbs(7, 7), KvIndexStrStrLambdaHeadRowSource.FACTORY);
        LAMBDA_ROW_SOURCE_FACTORIES.put(QueryCompiler.lbs(7, 8), KvIndexStrSymLambdaHeadRowSource.FACTORY);
        nullConstants.add("null");
        nullConstants.add("NaN");
    }

    private class LiteralCollector
    implements PostOrderTreeTraversalAlgo.Visitor {
        private IntList indexes;
        private ObjList<CharSequence> names;
        private int nullCount;
        private QueryModel parent;

        private LiteralCollector() {
        }

        @Override
        public void visit(ExprNode node) throws ParserException {
            switch (node.type) {
                case 4: {
                    int dot = node.token.indexOf(46);
                    CharSequence name = QueryCompiler.this.extractColumnName(node.token, dot);
                    this.indexes.add(QueryCompiler.this.resolveJournalIndex(this.parent, dot == -1 ? null : ((FlyweightCharSequence)QueryCompiler.this.csPool.next()).of(node.token, 0, dot), name, node.position));
                    if (this.names == null) break;
                    this.names.add(name);
                    break;
                }
                case 2: {
                    if (!nullConstants.contains(node.token)) break;
                    ++this.nullCount;
                    break;
                }
            }
        }

        private PostOrderTreeTraversalAlgo.Visitor lhs() {
            this.indexes = QueryCompiler.this.literalCollectorAIndexes;
            this.names = QueryCompiler.this.literalCollectorANames;
            return this;
        }

        private void resetNullCount() {
            this.nullCount = 0;
        }

        private PostOrderTreeTraversalAlgo.Visitor rhs() {
            this.indexes = QueryCompiler.this.literalCollectorBIndexes;
            this.names = QueryCompiler.this.literalCollectorBNames;
            return this;
        }

        private PostOrderTreeTraversalAlgo.Visitor to(IntList indexes) {
            this.indexes = indexes;
            this.names = null;
            return this;
        }

        private void withParent(QueryModel parent) {
            this.parent = parent;
        }
    }
}

