/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryErrorBuilder;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;

public final class QueryError
implements QueryErrorBuilder {
    private static final QueryError INSTANCE = new QueryError();
    private final ThreadLocalDetails tl = new ThreadLocalDetails();

    private QueryError() {
    }

    public static ParserException $(int position, String message) {
        return QueryError.position(position).$(message).$();
    }

    public static ParserException ambiguousColumn(int position) {
        return QueryError.position(position).$("Ambiguous column name").$();
    }

    public static CharSequence getMessage() {
        return ((Holder)QueryError.INSTANCE.tl.get()).sink;
    }

    public static int getPosition() {
        return ((Holder)QueryError.INSTANCE.tl.get()).position;
    }

    public static ParserException invalidColumn(int position, CharSequence column) {
        return QueryError.position(position).$("Invalid column: ").$(column).$();
    }

    public static QueryErrorBuilder position(int position) {
        Holder h = (Holder)QueryError.INSTANCE.tl.get();
        h.position = position;
        h.sink.clear();
        return INSTANCE;
    }

    @Override
    public ParserException $() {
        return ParserException.INSTANCE;
    }

    @Override
    public QueryErrorBuilder $(CharSequence sequence) {
        this.sink().put(sequence);
        return this;
    }

    @Override
    public QueryErrorBuilder $(int x) {
        this.sink().put(x);
        return this;
    }

    @Override
    public QueryErrorBuilder $(double x) {
        this.sink().put(x, 2);
        return this;
    }

    @Override
    public QueryErrorBuilder $(long x) {
        this.sink().put(x);
        return this;
    }

    @Override
    public QueryErrorBuilder $(char c) {
        this.sink().put(c);
        return this;
    }

    @Override
    public QueryErrorBuilder $(Enum e) {
        this.sink().put(e.name());
        return this;
    }

    private CharSink sink() {
        return ((Holder)this.tl.get()).sink;
    }

    private static class ThreadLocalDetails
    extends ThreadLocal<Holder> {
        private ThreadLocalDetails() {
        }

        @Override
        protected Holder initialValue() {
            return new Holder();
        }
    }

    private static class Holder {
        private final StringSink sink = new StringSink();
        private int position;

        private Holder() {
        }
    }
}

