/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.common.NumericException;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.common.RecordMetadata;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryError;
import com.questdb.parser.sql.model.AliasTranslator;
import com.questdb.parser.sql.model.ExprNode;
import com.questdb.parser.sql.model.IntrinsicModel;
import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.Chars;
import com.questdb.std.IntList;
import com.questdb.std.ObjList;
import com.questdb.std.ObjectPool;
import com.questdb.std.str.FlyweightCharSequence;
import com.questdb.std.time.DateFormatUtils;
import java.util.ArrayDeque;

final class QueryFilterAnalyser {
    private final ArrayDeque<ExprNode> stack = new ArrayDeque();
    private final FlyweightCharSequence quoteEraser = new FlyweightCharSequence();
    private final ObjList<ExprNode> keyNodes = new ObjList();
    private final ObjList<ExprNode> keyExclNodes = new ObjList();
    private final ObjectPool<IntrinsicModel> models = new ObjectPool<IntrinsicModel>(IntrinsicModel.FACTORY, 8);
    private final CharSequenceHashSet tempKeys = new CharSequenceHashSet();
    private final IntList tempPos = new IntList();
    private final CharSequenceHashSet tempK = new CharSequenceHashSet();
    private final IntList tempP = new IntList();
    private String timestamp;
    private String preferredKeyColumn;

    QueryFilterAnalyser() {
    }

    private static void checkNodeValid(ExprNode node) throws ParserException {
        if (node.lhs == null || node.rhs == null) {
            throw QueryError.$(node.position, "Argument expected");
        }
    }

    private boolean analyzeEquals(AliasTranslator translator, IntrinsicModel model, ExprNode node, RecordMetadata m) throws ParserException {
        QueryFilterAnalyser.checkNodeValid(node);
        return this.analyzeEquals0(translator, model, node, node.lhs, node.rhs, m) || this.analyzeEquals0(translator, model, node, node.rhs, node.lhs, m);
    }

    private boolean analyzeEquals0(AliasTranslator translator, IntrinsicModel model, ExprNode node, ExprNode a, ExprNode b, RecordMetadata m) throws ParserException {
        if (Chars.equals((CharSequence)a.token, b.token)) {
            node.intrinsicValue = 1;
            return true;
        }
        if (a.type == 4 && b.type == 2) {
            if (this.isTimestamp(a)) {
                FlyweightCharSequence seq = this.quoteEraser.ofQuoted(b.token);
                model.intersectIntervals(seq, 0, seq.length(), b.position);
                node.intrinsicValue = 1;
                return true;
            }
            CharSequence column = translator.translateAlias(a.token);
            int index = m.getColumnIndexQuiet(column);
            if (index == -1) {
                throw QueryError.invalidColumn(a.position, a.token);
            }
            RecordColumnMetadata meta = m.getColumnQuick(index);
            switch (meta.getType()) {
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    String value;
                    if (!meta.isIndexed()) break;
                    if (this.preferredKeyColumn != null && !this.preferredKeyColumn.equals(column)) {
                        return false;
                    }
                    boolean newColumn = true;
                    if (model.keyColumn != null && (newColumn = !model.keyColumn.equals(column)) && meta.getBucketCount() <= m.getColumn(model.keyColumn).getBucketCount()) {
                        return false;
                    }
                    String string = value = Chars.equals((CharSequence)"null", b.token) ? null : Chars.stripQuotes(b.token);
                    if (newColumn) {
                        model.keyColumn = column.toString();
                        model.keyValues.clear();
                        model.keyValuePositions.clear();
                        model.keyValues.add(value);
                        model.keyValuePositions.add(b.position);
                        int k = this.keyNodes.size();
                        for (int n = 0; n < k; ++n) {
                            this.keyNodes.getQuick((int)n).intrinsicValue = 0;
                        }
                        this.keyNodes.clear();
                    } else if (model.keyValues.contains(value)) {
                        model.keyValues.clear();
                        model.keyValuePositions.clear();
                        model.keyValues.add(value);
                        model.keyValuePositions.add(b.position);
                    } else {
                        model.intrinsicValue = 2;
                        return false;
                    }
                    this.keyNodes.add(node);
                    node.intrinsicValue = 1;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean analyzeGreater(IntrinsicModel model, ExprNode node, int increment) throws ParserException {
        QueryFilterAnalyser.checkNodeValid(node);
        if (Chars.equals((CharSequence)node.lhs.token, node.rhs.token)) {
            model.intrinsicValue = 2;
            return false;
        }
        if (this.timestamp == null) {
            return false;
        }
        if (node.lhs.type == 4 && node.lhs.token.equals(this.timestamp)) {
            if (node.rhs.type != 2) {
                return false;
            }
            try {
                model.intersectIntervals(DateFormatUtils.tryParse(this.quoteEraser.ofQuoted(node.rhs.token)) + (long)increment, Long.MAX_VALUE);
                node.intrinsicValue = 1;
                return true;
            }
            catch (NumericException e) {
                throw QueryError.$(node.rhs.position, "Not a date");
            }
        }
        if (node.rhs.type == 4 && node.rhs.token.equals(this.timestamp)) {
            if (node.lhs.type != 2) {
                return false;
            }
            try {
                model.intersectIntervals(Long.MIN_VALUE, DateFormatUtils.tryParse(this.quoteEraser.ofQuoted(node.lhs.token)) - (long)increment);
                return true;
            }
            catch (NumericException e) {
                throw QueryError.$(node.lhs.position, "Not a date");
            }
        }
        return false;
    }

    private boolean analyzeIn(AliasTranslator translator, IntrinsicModel model, ExprNode node, RecordMetadata metadata) throws ParserException {
        ExprNode col;
        if (node.paramCount < 2) {
            throw QueryError.$(node.position, "Too few arguments for 'in'");
        }
        ExprNode exprNode = col = node.paramCount < 3 ? node.lhs : node.args.getLast();
        if (col.type != 4) {
            throw QueryError.$(col.position, "Column name expected");
        }
        String column = translator.translateAlias(col.token).toString();
        if (metadata.getColumnIndexQuiet(column) == -1) {
            throw QueryError.invalidColumn(col.position, col.token);
        }
        return this.analyzeInInterval(model, col, node) || this.analyzeListOfValues(model, column, metadata, node) || this.analyzeInLambda(model, column, metadata, node);
    }

    private boolean analyzeInInterval(IntrinsicModel model, ExprNode col, ExprNode in) throws ParserException {
        if (!this.isTimestamp(col)) {
            return false;
        }
        if (in.paramCount > 3) {
            throw QueryError.$(in.args.getQuick((int)0).position, "Too many args");
        }
        if (in.paramCount < 3) {
            throw QueryError.$(in.position, "Too few args");
        }
        ExprNode lo = in.args.getQuick(1);
        ExprNode hi = in.args.getQuick(0);
        if (lo.type == 2 && hi.type == 2) {
            long hiMillis;
            long loMillis;
            try {
                loMillis = DateFormatUtils.tryParse(this.quoteEraser.ofQuoted(lo.token));
            }
            catch (NumericException ignore) {
                throw QueryError.$(lo.position, "Unknown date format");
            }
            try {
                hiMillis = DateFormatUtils.tryParse(this.quoteEraser.ofQuoted(hi.token));
            }
            catch (NumericException ignore) {
                throw QueryError.$(hi.position, "Unknown date format");
            }
            model.intersectIntervals(loMillis, hiMillis);
            in.intrinsicValue = 1;
            return true;
        }
        return false;
    }

    private boolean analyzeInLambda(IntrinsicModel model, String col, RecordMetadata meta, ExprNode node) throws ParserException {
        RecordColumnMetadata colMeta = meta.getColumn(col);
        if (colMeta.isIndexed()) {
            if (this.preferredKeyColumn != null && !col.equals(this.preferredKeyColumn)) {
                return false;
            }
            if (node.rhs == null || node.rhs.type != 65) {
                return false;
            }
            if (model.keyColumn != null && !model.keyColumn.equals(col) && colMeta.getBucketCount() <= meta.getColumn(model.keyColumn).getBucketCount()) {
                return false;
            }
            if (col.equals(model.keyColumn) && model.keyValuesIsLambda || node.paramCount > 2) {
                throw QueryError.$(node.position, "Multiple lambda expressions not supported");
            }
            model.keyValues.clear();
            model.keyValuePositions.clear();
            model.keyValues.add(Chars.stripQuotes(node.rhs.token));
            model.keyValuePositions.add(node.position);
            model.keyValuesIsLambda = true;
            int k = this.keyNodes.size();
            for (int n = 0; n < k; ++n) {
                this.keyNodes.getQuick((int)n).intrinsicValue = 0;
            }
            this.keyNodes.clear();
            model.keyColumn = col;
            this.keyNodes.add(node);
            node.intrinsicValue = 1;
            return true;
        }
        return false;
    }

    private boolean analyzeLess(IntrinsicModel model, ExprNode node, int inc) throws ParserException {
        QueryFilterAnalyser.checkNodeValid(node);
        if (Chars.equals((CharSequence)node.lhs.token, node.rhs.token)) {
            model.intrinsicValue = 2;
            return false;
        }
        if (this.timestamp == null) {
            return false;
        }
        if (node.lhs.type == 4 && node.lhs.token.equals(this.timestamp)) {
            try {
                if (node.rhs.type != 2) {
                    return false;
                }
                long hi = DateFormatUtils.tryParse(this.quoteEraser.ofQuoted(node.rhs.token)) - (long)inc;
                model.intersectIntervals(Long.MIN_VALUE, hi);
                node.intrinsicValue = 1;
                return true;
            }
            catch (NumericException e) {
                throw QueryError.$(node.rhs.position, "Not a date");
            }
        }
        if (node.rhs.type == 4 && node.rhs.token.equals(this.timestamp)) {
            try {
                if (node.lhs.type != 2) {
                    return false;
                }
                long lo = DateFormatUtils.tryParse(this.quoteEraser.ofQuoted(node.lhs.token)) + (long)inc;
                model.intersectIntervals(lo, Long.MAX_VALUE);
                node.intrinsicValue = 1;
                return true;
            }
            catch (NumericException e) {
                throw QueryError.$(node.lhs.position, "Not a date");
            }
        }
        return false;
    }

    private boolean analyzeListOfValues(IntrinsicModel model, String col, RecordMetadata meta, ExprNode node) {
        RecordColumnMetadata colMeta = meta.getColumn(col);
        if (colMeta.isIndexed()) {
            boolean newColumn = true;
            if (this.preferredKeyColumn != null && !col.equals(this.preferredKeyColumn)) {
                return false;
            }
            if (model.keyColumn != null && (newColumn = !model.keyColumn.equals(col)) && colMeta.getBucketCount() <= meta.getColumn(model.keyColumn).getBucketCount()) {
                return false;
            }
            int i = node.paramCount - 1;
            this.tempKeys.clear();
            this.tempPos.clear();
            if (i == 1) {
                if (node.rhs == null || node.rhs.type != 2) {
                    return false;
                }
                if (this.tempKeys.add(Chars.stripQuotes(node.rhs.token))) {
                    this.tempPos.add(node.position);
                }
            } else {
                --i;
                while (i > -1) {
                    ExprNode c = node.args.getQuick(i);
                    if (c.type != 2) {
                        return false;
                    }
                    if (this.tempKeys.add(Chars.stripQuotes(c.token))) {
                        this.tempPos.add(c.position);
                    }
                    --i;
                }
            }
            if (newColumn) {
                model.keyValues.clear();
                model.keyValuePositions.clear();
                model.keyValues.addAll(this.tempKeys);
                model.keyValuePositions.addAll(this.tempPos);
                int k = this.keyNodes.size();
                for (int n = 0; n < k; ++n) {
                    this.keyNodes.getQuick((int)n).intrinsicValue = 0;
                }
                this.keyNodes.clear();
                model.keyColumn = col;
                this.keyNodes.add(node);
                node.intrinsicValue = 1;
                return true;
            }
            if (!model.keyValuesIsLambda) {
                this.replaceAllWithOverlap(model);
                this.keyNodes.add(node);
                node.intrinsicValue = 1;
                return true;
            }
        }
        return false;
    }

    private boolean analyzeNotEquals(AliasTranslator translator, IntrinsicModel model, ExprNode node, RecordMetadata m) throws ParserException {
        QueryFilterAnalyser.checkNodeValid(node);
        return this.analyzeNotEquals0(translator, model, node, node.lhs, node.rhs, m) || this.analyzeNotEquals0(translator, model, node, node.rhs, node.lhs, m);
    }

    private boolean analyzeNotEquals0(AliasTranslator translator, IntrinsicModel model, ExprNode node, ExprNode a, ExprNode b, RecordMetadata m) throws ParserException {
        if (Chars.equals((CharSequence)a.token, b.token)) {
            model.intrinsicValue = 2;
            return true;
        }
        if (a.type == 4 && b.type == 2) {
            if (this.isTimestamp(a)) {
                FlyweightCharSequence seq = this.quoteEraser.ofQuoted(b.token);
                model.subtractIntervals(seq, 0, seq.length(), b.position);
                node.intrinsicValue = 1;
                return true;
            }
            String column = translator.translateAlias(a.token).toString();
            int index = m.getColumnIndexQuiet(column);
            if (index == -1) {
                throw QueryError.invalidColumn(a.position, a.token);
            }
            RecordColumnMetadata meta = m.getColumnQuick(index);
            switch (meta.getType()) {
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    if (!meta.isIndexed()) break;
                    if (this.preferredKeyColumn != null && !this.preferredKeyColumn.equals(column)) {
                        return false;
                    }
                    this.keyExclNodes.add(node);
                    return false;
                }
            }
        }
        return false;
    }

    private boolean analyzeNotIn(AliasTranslator translator, IntrinsicModel model, ExprNode notNode, RecordMetadata m) throws ParserException {
        ExprNode col;
        ExprNode node = notNode.rhs;
        if (node.paramCount < 2) {
            throw QueryError.$(node.position, "Too few arguments for 'in'");
        }
        ExprNode exprNode = col = node.paramCount < 3 ? node.lhs : node.args.getLast();
        if (col.type != 4) {
            throw QueryError.$(col.position, "Column name expected");
        }
        String column = translator.translateAlias(col.token).toString();
        if (m.getColumnIndexQuiet(column) == -1) {
            throw QueryError.invalidColumn(col.position, col.token);
        }
        boolean ok = this.analyzeNotInInterval(model, col, node);
        if (ok) {
            notNode.intrinsicValue = 1;
        } else {
            this.analyzeNotListOfValues(column, m, notNode);
        }
        return ok;
    }

    private boolean analyzeNotInInterval(IntrinsicModel model, ExprNode col, ExprNode in) throws ParserException {
        if (!this.isTimestamp(col)) {
            return false;
        }
        if (in.paramCount > 3) {
            throw QueryError.$(in.args.getQuick((int)0).position, "Too many args");
        }
        if (in.paramCount < 3) {
            throw QueryError.$(in.position, "Too few args");
        }
        ExprNode lo = in.args.getQuick(1);
        ExprNode hi = in.args.getQuick(0);
        if (lo.type == 2 && hi.type == 2) {
            long hiMillis;
            long loMillis;
            try {
                loMillis = DateFormatUtils.tryParse(this.quoteEraser.ofQuoted(lo.token));
            }
            catch (NumericException ignore) {
                throw QueryError.$(lo.position, "Unknown date format");
            }
            try {
                hiMillis = DateFormatUtils.tryParse(this.quoteEraser.ofQuoted(hi.token));
            }
            catch (NumericException ignore) {
                throw QueryError.$(hi.position, "Unknown date format");
            }
            model.subtractIntervals(loMillis, hiMillis);
            in.intrinsicValue = 1;
            return true;
        }
        return false;
    }

    private void analyzeNotListOfValues(String column, RecordMetadata m, ExprNode notNode) {
        RecordColumnMetadata meta = m.getColumn(column);
        switch (meta.getType()) {
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                if (!meta.isIndexed() || this.preferredKeyColumn != null && !this.preferredKeyColumn.equals(column)) break;
                this.keyExclNodes.add(notNode);
                break;
            }
        }
    }

    private void applyKeyExclusions(AliasTranslator translator, IntrinsicModel model) {
        if (model.keyColumn != null && this.keyExclNodes.size() > 0) {
            int n = this.keyExclNodes.size();
            block0: for (int i = 0; i < n; ++i) {
                ExprNode col;
                ExprNode node;
                ExprNode parent = this.keyExclNodes.getQuick(i);
                ExprNode exprNode = node = "not".equals(parent.token) ? parent.rhs : parent;
                if (node.paramCount == 2) {
                    ExprNode val;
                    if (node.lhs.type == 4) {
                        col = node.lhs;
                        val = node.rhs;
                    } else {
                        col = node.rhs;
                        val = node.lhs;
                    }
                    String column = translator.translateAlias(col.token).toString();
                    if (column.equals(model.keyColumn)) {
                        model.excludeValue(val);
                        parent.intrinsicValue = 1;
                        if (model.intrinsicValue == 2) break;
                    }
                }
                if (node.paramCount <= 2) continue;
                col = node.args.getQuick(node.paramCount - 1);
                String column = translator.translateAlias(col.token).toString();
                if (!column.equals(model.keyColumn)) continue;
                for (int j = node.paramCount - 2; j > -1; --j) {
                    ExprNode val = node.args.getQuick(j);
                    model.excludeValue(val);
                    if (model.intrinsicValue == 2) break block0;
                }
                parent.intrinsicValue = 1;
            }
        }
        this.keyExclNodes.clear();
    }

    private ExprNode collapseIntrinsicNodes(ExprNode node) {
        if (node == null || node.intrinsicValue == 1) {
            return null;
        }
        node.lhs = this.collapseIntrinsicNodes(this.collapseNulls0(node.lhs));
        node.rhs = this.collapseIntrinsicNodes(this.collapseNulls0(node.rhs));
        return this.collapseNulls0(node);
    }

    private ExprNode collapseNulls0(ExprNode node) {
        if (node == null || node.intrinsicValue == 1) {
            return null;
        }
        if ("and".equals(node.token)) {
            if (node.lhs == null || node.lhs.intrinsicValue == 1) {
                return node.rhs;
            }
            if (node.rhs == null || node.rhs.intrinsicValue == 1) {
                return node.lhs;
            }
        }
        return node;
    }

    IntrinsicModel extract(AliasTranslator translator, ExprNode node, RecordMetadata m, String preferredKeyColumn, int timestampIndex) throws ParserException {
        this.stack.clear();
        this.keyNodes.clear();
        this.timestamp = timestampIndex < 0 ? null : m.getColumnName(timestampIndex);
        this.preferredKeyColumn = preferredKeyColumn;
        IntrinsicModel model = this.models.next();
        if (this.removeAndIntrinsics(translator, model, node, m)) {
            return model;
        }
        ExprNode root = node;
        block6: while (!this.stack.isEmpty() || node != null) {
            if (node != null) {
                switch (node.token) {
                    case "and": {
                        if (!this.removeAndIntrinsics(translator, model, node.rhs, m)) {
                            this.stack.push(node.rhs);
                        }
                        node = this.removeAndIntrinsics(translator, model, node.lhs, m) ? null : node.lhs;
                        continue block6;
                    }
                }
                node = this.stack.poll();
                continue;
            }
            node = this.stack.poll();
        }
        this.applyKeyExclusions(translator, model);
        model.filter = this.collapseIntrinsicNodes(root);
        return model;
    }

    private boolean isTimestamp(ExprNode n) {
        return this.timestamp != null && this.timestamp.equals(n.token);
    }

    private boolean removeAndIntrinsics(AliasTranslator translator, IntrinsicModel model, ExprNode node, RecordMetadata m) throws ParserException {
        switch (node.token) {
            case "in": {
                return this.analyzeIn(translator, model, node, m);
            }
            case ">": {
                return this.analyzeGreater(model, node, 1);
            }
            case ">=": {
                return this.analyzeGreater(model, node, 0);
            }
            case "<": {
                return this.analyzeLess(model, node, 1);
            }
            case "<=": {
                return this.analyzeLess(model, node, 0);
            }
            case "=": {
                return this.analyzeEquals(translator, model, node, m);
            }
            case "!=": {
                return this.analyzeNotEquals(translator, model, node, m);
            }
            case "not": {
                return "in".equals(node.rhs.token) && this.analyzeNotIn(translator, model, node, m);
            }
        }
        return false;
    }

    private void replaceAllWithOverlap(IntrinsicModel model) {
        this.tempK.clear();
        this.tempP.clear();
        int k = this.tempKeys.size();
        for (int i = 0; i < k; ++i) {
            if (!model.keyValues.contains(this.tempKeys.get(i)) || !this.tempK.add(this.tempKeys.get(i))) continue;
            this.tempP.add(this.tempPos.get(i));
        }
        if (this.tempK.size() > 0) {
            model.keyValues.clear();
            model.keyValuePositions.clear();
            model.keyValues.addAll(this.tempK);
            model.keyValuePositions.addAll(this.tempP);
        } else {
            model.intrinsicValue = 2;
        }
    }

    void reset() {
        this.models.clear();
    }
}

