/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.common.ColumnType;
import com.questdb.common.NumericException;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.ExprAstBuilder;
import com.questdb.parser.sql.ExprParser;
import com.questdb.parser.sql.QueryError;
import com.questdb.parser.sql.model.AnalyticColumn;
import com.questdb.parser.sql.model.ColumnCastModel;
import com.questdb.parser.sql.model.ColumnIndexModel;
import com.questdb.parser.sql.model.CreateJournalModel;
import com.questdb.parser.sql.model.ExprNode;
import com.questdb.parser.sql.model.ParsedModel;
import com.questdb.parser.sql.model.QueryColumn;
import com.questdb.parser.sql.model.QueryModel;
import com.questdb.parser.sql.model.RenameJournalModel;
import com.questdb.parser.sql.model.WithClauseModel;
import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.Chars;
import com.questdb.std.Lexer;
import com.questdb.std.Misc;
import com.questdb.std.Numbers;
import com.questdb.std.ObjList;
import com.questdb.std.ObjectPool;
import com.questdb.std.str.StringSink;
import com.questdb.store.factory.configuration.GenericIndexedBuilder;
import com.questdb.store.factory.configuration.JournalStructure;

public final class QueryParser {
    public static final int MAX_ORDER_BY_COLUMNS = 1560;
    private static final CharSequenceHashSet journalAliasStop = new CharSequenceHashSet();
    private static final CharSequenceHashSet columnAliasStop = new CharSequenceHashSet();
    private static final CharSequenceHashSet groupByStopSet = new CharSequenceHashSet();
    private static final CharSequenceIntHashMap joinStartSet = new CharSequenceIntHashMap();
    private final ObjectPool<ExprNode> exprNodePool = new ObjectPool<ExprNode>(ExprNode.FACTORY, 128);
    private final ExprAstBuilder astBuilder = new ExprAstBuilder();
    private final ObjectPool<QueryModel> queryModelPool = new ObjectPool<QueryModel>(QueryModel.FACTORY, 8);
    private final ObjectPool<QueryColumn> queryColumnPool = new ObjectPool<QueryColumn>(QueryColumn.FACTORY, 64);
    private final ObjectPool<AnalyticColumn> analyticColumnPool = new ObjectPool<AnalyticColumn>(AnalyticColumn.FACTORY, 8);
    private final ObjectPool<CreateJournalModel> createJournalModelPool = new ObjectPool<CreateJournalModel>(CreateJournalModel.FACTORY, 4);
    private final ObjectPool<ColumnIndexModel> columnIndexModelPool = new ObjectPool<ColumnIndexModel>(ColumnIndexModel.FACTORY, 8);
    private final ObjectPool<ColumnCastModel> columnCastModelPool = new ObjectPool<ColumnCastModel>(ColumnCastModel.FACTORY, 8);
    private final ObjectPool<RenameJournalModel> renameJournalModelPool = new ObjectPool<RenameJournalModel>(RenameJournalModel.FACTORY, 8);
    private final ObjectPool<WithClauseModel> withClauseModelPool = new ObjectPool<WithClauseModel>(WithClauseModel.FACTORY, 16);
    private final Lexer secondaryLexer = new Lexer();
    private final ExprParser exprParser = new ExprParser(this.exprNodePool);
    private Lexer lexer = new Lexer();

    public QueryParser() {
        ExprParser.configureLexer(this.lexer);
        ExprParser.configureLexer(this.secondaryLexer);
    }

    public ParsedModel parse(CharSequence query) throws ParserException {
        this.clear();
        return this.parseInternal(query);
    }

    private void clear() {
        this.queryModelPool.clear();
        this.queryColumnPool.clear();
        this.exprNodePool.clear();
        this.analyticColumnPool.clear();
        this.createJournalModelPool.clear();
        this.columnIndexModelPool.clear();
        this.columnCastModelPool.clear();
        this.renameJournalModelPool.clear();
        this.withClauseModelPool.clear();
    }

    private ParserException err(String msg) {
        return QueryError.$(this.lexer.position(), msg);
    }

    private ExprNode expectExpr() throws ParserException {
        ExprNode n = this.expr();
        if (n == null) {
            throw QueryError.$(this.lexer.position(), "Expression expected");
        }
        return n;
    }

    private ExprNode expectLiteral() throws ParserException {
        CharSequence tok = this.tok();
        int pos = this.lexer.position();
        this.validateLiteral(pos, tok);
        ExprNode node = this.exprNodePool.next();
        node.token = tok.toString();
        node.type = 4;
        node.position = pos;
        return node;
    }

    private void expectTok(CharSequence tok, CharSequence expected) throws ParserException {
        if (tok == null || !Chars.equals(tok, expected)) {
            throw QueryError.position(this.lexer.position()).$('\'').$(expected).$("' expected").$();
        }
    }

    private void expectTok(char expected) throws ParserException {
        this.expectTok(this.tok(), this.lexer.position(), expected);
    }

    private void expectTok(CharSequence tok, int pos, char expected) throws ParserException {
        if (tok == null || !Chars.equals(tok, expected)) {
            throw QueryError.position(pos).$('\'').$(expected).$("' expected").$();
        }
    }

    private ExprNode expr() throws ParserException {
        this.astBuilder.reset();
        this.exprParser.parseExpr(this.lexer, this.astBuilder);
        return this.astBuilder.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryModel getOrParseQueryModelFromWithClause(WithClauseModel wcm) throws ParserException {
        QueryModel m = wcm.popModel();
        if (m != null) {
            return m;
        }
        this.secondaryLexer.setContent(this.lexer.getContent(), wcm.getLo(), wcm.getHi());
        Lexer tmp = this.lexer;
        this.lexer = this.secondaryLexer;
        try {
            QueryModel queryModel = this.parseQuery(true);
            return queryModel;
        }
        finally {
            this.lexer = tmp;
        }
    }

    private boolean isFieldTerm(CharSequence tok) {
        return Chars.equals(tok, ')') || Chars.equals(tok, ',');
    }

    private ExprNode literal() {
        CharSequence tok = this.lexer.optionTok();
        if (tok == null) {
            return null;
        }
        return this.exprNodePool.next().of(4, Chars.stripQuotes(tok.toString()), 0, this.lexer.position());
    }

    private ExprNode makeJoinAlias(int index) {
        StringSink b = Misc.getThreadLocalBuilder();
        ExprNode node = this.exprNodePool.next();
        node.token = b.put("_xQdbA").put(index).toString();
        node.type = 4;
        return node;
    }

    private ExprNode makeModelAlias(String modelAlias, ExprNode node) {
        StringSink b = Misc.getThreadLocalBuilder();
        ExprNode exprNode = this.exprNodePool.next();
        b.put(modelAlias).put('.').put(node.token);
        exprNode.token = ((Object)b).toString();
        exprNode.type = 4;
        exprNode.position = node.position;
        return exprNode;
    }

    private ExprNode makeOperation(String token, ExprNode lhs, ExprNode rhs) {
        ExprNode expr = this.exprNodePool.next();
        expr.token = token;
        expr.type = 1;
        expr.position = 0;
        expr.paramCount = 2;
        expr.lhs = lhs;
        expr.rhs = rhs;
        return expr;
    }

    private CharSequence notTermTok() throws ParserException {
        CharSequence tok = this.tok();
        if (this.isFieldTerm(tok)) {
            throw this.err("Invalid column definition");
        }
        return tok;
    }

    private ParsedModel parseCreateJournal() throws ParserException {
        ExprNode hint;
        ExprNode partitionBy;
        JournalStructure struct;
        QueryModel queryModel;
        ExprNode name = this.exprNodePool.next();
        name.token = Chars.stripQuotes(this.tok().toString());
        name.position = this.lexer.position();
        name.type = 4;
        CharSequence tok = this.tok();
        if (Chars.equals(tok, '(')) {
            queryModel = null;
            struct = new JournalStructure(name.token);
            this.lexer.unparse();
            this.parseJournalFields(struct);
        } else if (Chars.equals(tok, "as")) {
            this.expectTok('(');
            queryModel = this.parseQuery(true);
            struct = null;
            this.expectTok(')');
        } else {
            throw QueryError.position(this.lexer.position()).$("Unexpected token").$();
        }
        CreateJournalModel model = this.createJournalModelPool.next();
        model.setStruct(struct);
        model.setQueryModel(queryModel);
        model.setName(name);
        tok = this.lexer.optionTok();
        while (tok != null && Chars.equals(tok, ',')) {
            int pos = this.lexer.position();
            tok = this.tok();
            if (Chars.equals(tok, "index")) {
                this.expectTok('(');
                ColumnIndexModel columnIndexModel = this.columnIndexModelPool.next();
                columnIndexModel.setName(this.expectLiteral());
                pos = this.lexer.position();
                tok = this.tok();
                if (Chars.equals(tok, "buckets")) {
                    try {
                        columnIndexModel.setBuckets(Numbers.ceilPow2(Numbers.parseInt(this.tok())) - 1);
                    }
                    catch (NumericException e) {
                        throw QueryError.$(pos, "Int constant expected");
                    }
                    pos = this.lexer.position();
                    tok = this.tok();
                }
                this.expectTok(tok, pos, ')');
                model.addColumnIndexModel(columnIndexModel);
                tok = this.lexer.optionTok();
                continue;
            }
            if (Chars.equals(tok, "cast")) {
                this.expectTok('(');
                ColumnCastModel columnCastModel = this.columnCastModelPool.next();
                columnCastModel.setName(this.expectLiteral());
                this.expectTok(this.tok(), "as");
                ExprNode node = this.expectLiteral();
                int type = ColumnType.columnTypeOf(node.token);
                if (type == -1) {
                    throw QueryError.$(node.position, "invalid type");
                }
                columnCastModel.setType(type, node.position);
                if (type == 8) {
                    tok = this.lexer.optionTok();
                    pos = this.lexer.position();
                    if (Chars.equals(tok, "count")) {
                        try {
                            columnCastModel.setCount(Numbers.parseInt(this.tok()));
                            tok = this.tok();
                        }
                        catch (NumericException e) {
                            throw QueryError.$(pos, "int value expected");
                        }
                    }
                } else {
                    pos = this.lexer.position();
                    tok = this.tok();
                }
                this.expectTok(tok, pos, ')');
                if (!model.addColumnCastModel(columnCastModel)) {
                    throw QueryError.$(columnCastModel.getName().position, "duplicate cast");
                }
                tok = this.lexer.optionTok();
                continue;
            }
            throw QueryError.$(pos, "Unexpected token");
        }
        ExprNode timestamp = this.parseTimestamp(tok);
        if (timestamp != null) {
            model.setTimestamp(timestamp);
            tok = this.lexer.optionTok();
        }
        if ((partitionBy = this.parsePartitionBy(tok)) != null) {
            model.setPartitionBy(partitionBy);
            tok = this.lexer.optionTok();
        }
        if ((hint = this.parseRecordHint(tok)) != null) {
            model.setRecordHint(hint);
            tok = this.lexer.optionTok();
        }
        if (tok != null) {
            throw QueryError.$(this.lexer.position(), "Unexpected token");
        }
        return model;
    }

    private ParsedModel parseCreateStatement() throws ParserException {
        CharSequence tok = this.tok();
        if (Chars.equals(tok, "table")) {
            return this.parseCreateJournal();
        }
        throw this.err("table expected");
    }

    private CharSequence parseIndexDefinition(GenericIndexedBuilder builder) throws ParserException {
        CharSequence tok = this.tok();
        if (this.isFieldTerm(tok)) {
            return tok;
        }
        this.expectTok(tok, "index");
        builder.index();
        tok = this.tok();
        if (this.isFieldTerm(tok)) {
            return tok;
        }
        this.expectTok(tok, "buckets");
        try {
            builder.buckets(Numbers.parseInt(this.tok()));
        }
        catch (NumericException e) {
            throw this.err("bad int");
        }
        return null;
    }

    ParsedModel parseInternal(CharSequence query) throws ParserException {
        this.lexer.setContent(query);
        CharSequence tok = this.tok();
        if (Chars.equals(tok, "create")) {
            return this.parseCreateStatement();
        }
        if (Chars.equals(tok, "rename")) {
            return this.parseRenameStatement();
        }
        this.lexer.unparse();
        return this.parseQuery(false);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private QueryModel parseJoin(CharSequence tok, int joinType, QueryModel parent) throws ParserException {
        joinModel = this.queryModelPool.next();
        joinModel.setJoinType(joinType);
        if (!Chars.equals(tok, "join")) {
            this.expectTok(this.tok(), "join");
        }
        if (Chars.equals(tok = this.tok(), '(')) {
            joinModel.setNestedModel(this.parseQuery(true));
            this.expectTok(')');
        } else {
            this.lexer.unparse();
            this.parseWithClauseOrJournalName(joinModel, parent);
        }
        tok = this.lexer.optionTok();
        if (tok != null && !QueryParser.journalAliasStop.contains(tok)) {
            this.lexer.unparse();
            joinModel.setAlias(this.expr());
        } else {
            this.lexer.unparse();
        }
        tok = this.lexer.optionTok();
        if (joinType == 3 && tok != null && Chars.equals(tok, "on")) {
            throw QueryError.$(this.lexer.position(), "Cross joins cannot have join clauses");
        }
        switch (joinType) {
            case 4: {
                if (tok == null || !Chars.equals((CharSequence)"on", tok)) {
                    this.lexer.unparse();
                    return joinModel;
                }
            }
            case 1: 
            case 2: {
                this.expectTok(tok, "on");
                this.astBuilder.reset();
                this.exprParser.parseExpr(this.lexer, this.astBuilder);
                switch (this.astBuilder.size()) {
                    case 0: {
                        throw QueryError.$(this.lexer.position(), "Expression expected");
                    }
                    case 1: {
                        expr = this.astBuilder.poll();
                        if (expr.type != 4) {
                            joinModel.setJoinCriteria(expr);
                            return joinModel;
                        }
                        do {
                            joinModel.addJoinColumn(expr);
                        } while ((expr = this.astBuilder.poll()) != null);
                        return joinModel;
                    }
                }
                break;
            }
            default: {
                this.lexer.unparse();
                return joinModel;
            }
        }
        while (true) {
            expr = this.astBuilder.poll();
            if (expr == null) return joinModel;
            if (expr.type != 4) {
                throw QueryError.$(this.lexer.position(), "Column name expected");
            }
            joinModel.addJoinColumn(expr);
            ** break;
lbl52:
            // 1 sources

        }
    }

    private void parseJournalFields(JournalStructure struct) throws ParserException {
        block16: {
            CharSequence tok;
            if (!Chars.equals(this.tok(), '(')) {
                throw this.err("( expected");
            }
            do {
                String name = this.notTermTok().toString();
                tok = null;
                switch (ColumnType.columnTypeOf(this.notTermTok())) {
                    case 1: {
                        struct.$byte(name);
                        break;
                    }
                    case 4: {
                        tok = this.parseIndexDefinition(struct.$int(name));
                        break;
                    }
                    case 2: {
                        struct.$double(name);
                        break;
                    }
                    case 0: {
                        struct.$bool(name);
                        break;
                    }
                    case 3: {
                        struct.$float(name);
                        break;
                    }
                    case 5: {
                        tok = this.parseIndexDefinition(struct.$long(name));
                        break;
                    }
                    case 6: {
                        struct.$short(name);
                        break;
                    }
                    case 7: {
                        tok = this.parseIndexDefinition(struct.$str(name));
                        break;
                    }
                    case 8: {
                        tok = this.parseIndexDefinition(struct.$sym(name));
                        break;
                    }
                    case 9: {
                        struct.$bin(name);
                        break;
                    }
                    case 10: {
                        struct.$date(name);
                        break;
                    }
                    default: {
                        throw this.err("Unsupported type");
                    }
                }
                if (tok == null) {
                    tok = this.tok();
                }
                if (Chars.equals(tok, ')')) break block16;
            } while (Chars.equals(tok, ','));
            throw this.err(", or ) expected");
        }
    }

    private void parseLatestBy(QueryModel model) throws ParserException {
        this.expectTok(this.tok(), "by");
        model.setLatestBy(this.expr());
    }

    private ExprNode parsePartitionBy(CharSequence tok) throws ParserException {
        if (Chars.equalsNc("partition", tok)) {
            this.expectTok(this.tok(), "by");
            return this.expectLiteral();
        }
        return null;
    }

    private QueryModel parseQuery(boolean subQuery) throws ParserException {
        int joinType;
        QueryModel model = this.queryModelPool.next();
        CharSequence tok = this.tok();
        if (Chars.equals(tok, "with")) {
            this.parseWithClauses(model);
            tok = this.tok();
        }
        if (Chars.equals(tok, "select")) {
            this.parseSelectColumns(model);
            tok = this.tok();
        }
        if (Chars.equals(tok, '(')) {
            ExprNode timestamp;
            model.setNestedModel(this.parseQuery(true));
            this.expectTok(')');
            tok = this.lexer.optionTok();
            if (tok != null && !journalAliasStop.contains(tok)) {
                this.lexer.unparse();
                model.setAlias(this.literal());
                tok = this.lexer.optionTok();
            }
            if ((timestamp = this.parseTimestamp(tok)) != null) {
                model.setTimestamp(timestamp);
                tok = this.lexer.optionTok();
            }
        } else {
            ExprNode timestamp;
            this.lexer.unparse();
            this.parseWithClauseOrJournalName(model, model);
            tok = this.lexer.optionTok();
            if (tok != null && !journalAliasStop.contains(tok)) {
                this.lexer.unparse();
                model.setAlias(this.literal());
                tok = this.lexer.optionTok();
            }
            if ((timestamp = this.parseTimestamp(tok)) != null) {
                model.setTimestamp(timestamp);
                tok = this.lexer.optionTok();
            }
            if (Chars.equalsNc("latest", tok)) {
                this.parseLatestBy(model);
                tok = this.lexer.optionTok();
            }
        }
        while (tok != null && (joinType = joinStartSet.get(tok)) != -1) {
            model.addJoinModel(this.parseJoin(tok, joinType, model));
            tok = this.lexer.optionTok();
        }
        if (tok != null && Chars.equals(tok, "where")) {
            model.setWhereClause(this.expr());
            tok = this.lexer.optionTok();
        }
        if (tok != null && Chars.equals(tok, "sample")) {
            this.expectTok(this.tok(), "by");
            model.setSampleBy(this.expectLiteral());
            tok = this.lexer.optionTok();
        }
        if (tok != null && Chars.equals(tok, "order")) {
            this.expectTok(this.tok(), "by");
            do {
                if (Chars.equals(tok = this.tok(), ')')) {
                    throw this.err("Expression expected");
                }
                this.lexer.unparse();
                ExprNode n = this.expectLiteral();
                tok = this.lexer.optionTok();
                if (tok != null && Chars.equalsIgnoreCase(tok, "desc")) {
                    model.addOrderBy(n, 1);
                    tok = this.lexer.optionTok();
                } else {
                    model.addOrderBy(n, 0);
                    if (tok != null && Chars.equalsIgnoreCase(tok, "asc")) {
                        tok = this.lexer.optionTok();
                    }
                }
                if (model.getOrderBy().size() < 1560) continue;
                throw this.err("Too many columns");
            } while (tok != null && Chars.equals(tok, ','));
        }
        if (tok != null && Chars.equals(tok, "limit")) {
            ExprNode lo = this.expr();
            ExprNode hi = null;
            tok = this.lexer.optionTok();
            if (tok != null && Chars.equals(tok, ',')) {
                hi = this.expr();
                tok = this.lexer.optionTok();
            }
            model.setLimit(lo, hi);
        }
        if (subQuery) {
            this.lexer.unparse();
        } else if (tok != null) {
            throw QueryError.position(this.lexer.position()).$("Unexpected token: ").$(tok).$();
        }
        this.resolveJoinColumns(model);
        return model;
    }

    private ExprNode parseRecordHint(CharSequence tok) throws ParserException {
        if (Chars.equalsNc("record", tok)) {
            this.expectTok(this.tok(), "hint");
            ExprNode hint = this.expectExpr();
            if (hint.type != 2) {
                throw QueryError.$(hint.position, "Constant expected");
            }
            return hint;
        }
        return null;
    }

    private ParsedModel parseRenameStatement() throws ParserException {
        this.expectTok(this.tok(), "table");
        RenameJournalModel model = this.renameJournalModelPool.next();
        ExprNode e = this.expectExpr();
        if (e.type != 4 && e.type != 2) {
            throw QueryError.$(e.position, "literal or constant expected");
        }
        model.setFrom(e);
        this.expectTok(this.tok(), "to");
        e = this.expectExpr();
        if (e.type != 4 && e.type != 2) {
            throw QueryError.$(e.position, "literal or constant expected");
        }
        model.setTo(e);
        return model;
    }

    private void parseSelectColumns(QueryModel model) throws ParserException {
        block12: {
            CharSequence tok;
            do {
                String alias;
                ExprNode expr;
                if ((expr = this.expr()) == null) {
                    throw QueryError.$(this.lexer.position(), "missing column");
                }
                int aliasPosition = this.lexer.position();
                tok = this.tok();
                if (!columnAliasStop.contains(tok)) {
                    alias = tok.toString();
                    tok = this.tok();
                } else {
                    alias = null;
                    aliasPosition = -1;
                }
                if (Chars.equals(tok, "over")) {
                    this.expectTok('(');
                    AnalyticColumn col = this.analyticColumnPool.next().of(alias, aliasPosition, expr);
                    tok = this.tok();
                    if (Chars.equals(tok, "partition")) {
                        this.expectTok(this.tok(), "by");
                        ObjList<ExprNode> partitionBy = col.getPartitionBy();
                        do {
                            partitionBy.add(this.expectLiteral());
                        } while (Chars.equals(tok = this.tok(), ','));
                    }
                    if (Chars.equals(tok, "order")) {
                        this.expectTok(this.tok(), "by");
                        do {
                            ExprNode e = this.expectLiteral();
                            tok = this.tok();
                            if (Chars.equalsIgnoreCase(tok, "desc")) {
                                col.addOrderBy(e, 1);
                                tok = this.tok();
                                continue;
                            }
                            col.addOrderBy(e, 0);
                            if (!Chars.equalsIgnoreCase(tok, "asc")) continue;
                            tok = this.tok();
                        } while (Chars.equals(tok, ','));
                    }
                    if (!Chars.equals(tok, ')')) {
                        throw this.err(") expected");
                    }
                    model.addColumn(col);
                    tok = this.tok();
                } else {
                    model.addColumn(this.queryColumnPool.next().of(alias, aliasPosition, expr));
                }
                if (Chars.equals(tok, "from")) break block12;
            } while (Chars.equals(tok, ','));
            throw this.err(",|from expected");
        }
    }

    private ExprNode parseTimestamp(CharSequence tok) throws ParserException {
        if (Chars.equalsNc("timestamp", tok)) {
            this.expectTok('(');
            ExprNode result = this.expectLiteral();
            this.expectTok(')');
            return result;
        }
        return null;
    }

    private void parseWithClauseOrJournalName(QueryModel target, QueryModel parent) throws ParserException {
        WithClauseModel withClause;
        ExprNode journalName = this.literal();
        WithClauseModel withClauseModel = withClause = journalName != null ? parent.getWithClause(journalName.token) : null;
        if (withClause != null) {
            target.setNestedModel(this.getOrParseQueryModelFromWithClause(withClause));
        } else {
            target.setJournalName(journalName);
        }
    }

    private void parseWithClauses(QueryModel model) throws ParserException {
        CharSequence tok;
        do {
            ExprNode name = this.expectLiteral();
            if (model.getWithClause(name.token) != null) {
                throw QueryError.$(name.position, "duplicate name");
            }
            this.expectTok(this.tok(), "as");
            this.expectTok('(');
            int lo = this.lexer.position();
            QueryModel m = this.parseQuery(true);
            int hi = this.lexer.position();
            WithClauseModel wcm = this.withClauseModelPool.next();
            wcm.of(lo + 1, hi, m);
            this.expectTok(')');
            model.addWithClause(name.token, wcm);
        } while ((tok = this.lexer.optionTok()) != null && Chars.equals(tok, ','));
        this.lexer.unparse();
    }

    private void resolveJoinColumns(QueryModel model) {
        String modelAlias;
        ObjList<QueryModel> joinModels = model.getJoinModels();
        if (joinModels.size() == 0) {
            return;
        }
        if (model.getAlias() != null) {
            modelAlias = model.getAlias().token;
        } else if (model.getJournalName() != null) {
            modelAlias = model.getJournalName().token;
        } else {
            ExprNode alias = this.makeJoinAlias(0);
            model.setAlias(alias);
            modelAlias = alias.token;
        }
        int n = joinModels.size();
        for (int i = 1; i < n; ++i) {
            String jmAlias;
            QueryModel jm = joinModels.getQuick(i);
            ObjList<ExprNode> jc = jm.getJoinColumns();
            if (jc.size() <= 0) continue;
            if (jm.getAlias() != null) {
                jmAlias = jm.getAlias().token;
            } else if (jm.getJournalName() != null) {
                jmAlias = jm.getJournalName().token;
            } else {
                ExprNode alias = this.makeJoinAlias(i);
                jm.setAlias(alias);
                jmAlias = alias.token;
            }
            ExprNode joinCriteria = jm.getJoinCriteria();
            int m = jc.size();
            for (int j = 0; j < m; ++j) {
                ExprNode node = jc.getQuick(j);
                ExprNode eq = this.makeOperation("=", this.makeModelAlias(modelAlias, node), this.makeModelAlias(jmAlias, node));
                joinCriteria = joinCriteria == null ? eq : this.makeOperation("and", joinCriteria, eq);
            }
            jm.setJoinCriteria(joinCriteria);
        }
    }

    private CharSequence tok() throws ParserException {
        CharSequence tok = this.lexer.optionTok();
        if (tok == null) {
            throw this.err("Unexpected end of input");
        }
        return tok;
    }

    private void validateLiteral(int pos, CharSequence tok) throws ParserException {
        switch (tok.charAt(0)) {
            case '\"': 
            case '\'': 
            case '(': 
            case ')': 
            case ',': 
            case '`': {
                throw QueryError.$(pos, "literal expected");
            }
        }
    }

    static {
        journalAliasStop.add("where");
        journalAliasStop.add("latest");
        journalAliasStop.add("join");
        journalAliasStop.add("inner");
        journalAliasStop.add("outer");
        journalAliasStop.add("asof");
        journalAliasStop.add("cross");
        journalAliasStop.add("sample");
        journalAliasStop.add("order");
        journalAliasStop.add("on");
        journalAliasStop.add("timestamp");
        journalAliasStop.add("limit");
        journalAliasStop.add(")");
        columnAliasStop.add("from");
        columnAliasStop.add(",");
        columnAliasStop.add("over");
        groupByStopSet.add("order");
        groupByStopSet.add(")");
        groupByStopSet.add(",");
        joinStartSet.put("join", 1);
        joinStartSet.put("inner", 1);
        joinStartSet.put("outer", 2);
        joinStartSet.put("cross", 3);
        joinStartSet.put("asof", 4);
    }
}

