/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.BootstrapEnv;
import com.questdb.common.NoSuchColumnException;
import com.questdb.common.NumericException;
import com.questdb.common.RecordMetadata;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.PostOrderTreeTraversalAlgo;
import com.questdb.parser.sql.QueryError;
import com.questdb.parser.sql.model.ExprNode;
import com.questdb.parser.sql.model.QueryModel;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.FunctionFactories;
import com.questdb.ql.ops.Parameter;
import com.questdb.ql.ops.Signature;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.ql.ops.col.BinaryRecordSourceColumn;
import com.questdb.ql.ops.col.BoolRecordSourceColumn;
import com.questdb.ql.ops.col.ByteRecordSourceColumn;
import com.questdb.ql.ops.col.DateRecordSourceColumn;
import com.questdb.ql.ops.col.DoubleRecordSourceColumn;
import com.questdb.ql.ops.col.FloatRecordSourceColumn;
import com.questdb.ql.ops.col.IntRecordSourceColumn;
import com.questdb.ql.ops.col.LongRecordSourceColumn;
import com.questdb.ql.ops.col.ShortRecordSourceColumn;
import com.questdb.ql.ops.col.StrRecordSourceColumn;
import com.questdb.ql.ops.col.SymRecordSourceColumn;
import com.questdb.ql.ops.constant.BooleanConstant;
import com.questdb.ql.ops.constant.DateConstant;
import com.questdb.ql.ops.constant.DoubleConstant;
import com.questdb.ql.ops.constant.FloatConstant;
import com.questdb.ql.ops.constant.IntConstant;
import com.questdb.ql.ops.constant.LongConstant;
import com.questdb.ql.ops.constant.NullConstant;
import com.questdb.ql.ops.constant.StrConstant;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.CharSequenceObjHashMap;
import com.questdb.std.Chars;
import com.questdb.std.Numbers;
import com.questdb.std.ObjList;
import java.util.ArrayDeque;

class VirtualColumnBuilder
implements PostOrderTreeTraversalAlgo.Visitor {
    private final ObjList<VirtualColumn> mutableArgs = new ObjList();
    private final Signature mutableSig = new Signature();
    private final ArrayDeque<VirtualColumn> stack = new ArrayDeque();
    private final PostOrderTreeTraversalAlgo algo;
    private final BootstrapEnv env;
    private RecordMetadata metadata;
    private CharSequenceIntHashMap columnNameHistogram;
    private CharSequenceObjHashMap<Parameter> parameterMap;
    private QueryModel model;

    VirtualColumnBuilder(PostOrderTreeTraversalAlgo algo, BootstrapEnv env) {
        this.algo = algo;
        this.env = env;
    }

    @Override
    public void visit(ExprNode node) throws ParserException {
        int argCount = node.paramCount;
        if (argCount == 0) {
            switch (node.type) {
                case 4: {
                    if (Chars.startsWith((CharSequence)node.token, ':')) {
                        this.stack.push(Parameter.getOrCreate(node, this.parameterMap));
                        break;
                    }
                    this.stack.push(this.lookupColumn(node));
                    break;
                }
                case 2: {
                    this.stack.push(this.parseConstant(node));
                    break;
                }
                default: {
                    this.mutableSig.clear();
                    this.stack.push(this.lookupFunction(node, this.mutableSig.setName(node.token).setParamCount(0), null));
                    break;
                }
            }
        } else {
            this.mutableSig.clear();
            this.mutableArgs.clear();
            this.mutableArgs.setPos(argCount);
            this.mutableSig.setName(node.token).setParamCount(argCount);
            for (int n = 0; n < argCount; ++n) {
                VirtualColumn c = this.stack.poll();
                if (c == null) {
                    throw QueryError.$(node.position, "Too few arguments");
                }
                this.mutableSig.paramType(n, c.getType(), c.isConstant());
                this.mutableArgs.setQuick(n, c);
            }
            this.stack.push(this.lookupFunction(node, this.mutableSig, this.mutableArgs));
        }
    }

    VirtualColumn createVirtualColumn(QueryModel model, ExprNode node, RecordMetadata metadata) throws ParserException {
        this.columnNameHistogram = model.getColumnNameHistogram();
        this.parameterMap = model.getParameterMap();
        this.model = model;
        this.metadata = metadata;
        this.algo.traverse(node, this);
        return this.stack.poll();
    }

    private VirtualColumn lookupColumn(ExprNode node) throws ParserException {
        CharSequence column = this.model.translateAlias(node.token);
        try {
            if (this.columnNameHistogram.get(column) > 0) {
                throw QueryError.ambiguousColumn(node.position);
            }
            int index = this.metadata.getColumnIndex(column);
            switch (this.metadata.getColumnQuick(index).getType()) {
                case 2: {
                    return new DoubleRecordSourceColumn(index, node.position);
                }
                case 4: {
                    return new IntRecordSourceColumn(index, node.position);
                }
                case 5: {
                    return new LongRecordSourceColumn(index, node.position);
                }
                case 7: {
                    return new StrRecordSourceColumn(index, node.position);
                }
                case 8: {
                    return new SymRecordSourceColumn(index, node.position);
                }
                case 1: {
                    return new ByteRecordSourceColumn(index, node.position);
                }
                case 3: {
                    return new FloatRecordSourceColumn(index, node.position);
                }
                case 0: {
                    return new BoolRecordSourceColumn(index, node.position);
                }
                case 6: {
                    return new ShortRecordSourceColumn(index, node.position);
                }
                case 9: {
                    return new BinaryRecordSourceColumn(index, node.position);
                }
                case 10: {
                    return new DateRecordSourceColumn(index, node.position);
                }
            }
            throw QueryError.$(node.position, "Not yet supported type");
        }
        catch (NoSuchColumnException e) {
            throw QueryError.invalidColumn(node.position, column);
        }
    }

    private VirtualColumn lookupFunction(ExprNode node, Signature sig, ObjList<VirtualColumn> args) throws ParserException {
        if (node.type == 65) {
            throw QueryError.$(node.position, "Cannot use lambda in this context");
        }
        VirtualColumnFactory<Function> factory = FunctionFactories.find(sig, args);
        if (factory == null) {
            throw QueryError.$(node.position, "No such function: " + sig.userReadable());
        }
        Function f = factory.newInstance(node.position, this.env);
        if (args != null) {
            int n = node.paramCount;
            for (int i = 0; i < n; ++i) {
                f.setArg(i, args.getQuick(i));
            }
        }
        return f.isConstant() ? this.processConstantExpression(f) : f;
    }

    private VirtualColumn parseConstant(ExprNode node) throws ParserException {
        if ("null".equals(node.token)) {
            return new NullConstant(node.position);
        }
        String s = Chars.stripQuotes(node.token);
        if (s != node.token) {
            return new StrConstant(s, node.position);
        }
        try {
            return new IntConstant(Numbers.parseInt(node.token), node.position);
        }
        catch (NumericException numericException) {
            try {
                return new LongConstant(Numbers.parseLong(node.token), node.position);
            }
            catch (NumericException numericException2) {
                try {
                    return new DoubleConstant(Numbers.parseDouble(node.token), node.position);
                }
                catch (NumericException numericException3) {
                    try {
                        return new FloatConstant(Numbers.parseFloat(node.token), node.position);
                    }
                    catch (NumericException numericException4) {
                        throw QueryError.$(node.position, "Unknown value type: " + node.token);
                    }
                }
            }
        }
    }

    private VirtualColumn processConstantExpression(Function f) {
        switch (f.getType()) {
            case 4: {
                return new IntConstant(f.getInt(null), f.getPosition());
            }
            case 2: {
                return new DoubleConstant(f.getDouble(null), f.getPosition());
            }
            case 3: {
                return new FloatConstant(f.getFloat(null), f.getPosition());
            }
            case 0: {
                return new BooleanConstant(f.getBool(null), f.getPosition());
            }
            case 7: {
                CharSequence cs = f.getFlyweightStr(null);
                return cs == null ? new NullConstant(f.getPosition()) : new StrConstant(cs.toString(), f.getPosition());
            }
            case 5: {
                return new LongConstant(f.getLong(null), f.getPosition());
            }
            case 10: {
                return new DateConstant(f.getDate(null), f.getPosition());
            }
        }
        return f;
    }
}

