/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql.model;

import com.questdb.std.Mutable;
import com.questdb.std.ObjList;
import com.questdb.std.ObjectFactory;
import com.questdb.std.Sinkable;
import com.questdb.std.str.CharSink;

public class ExprNode
implements Mutable,
Sinkable {
    public static final ExprNodeFactory FACTORY = new ExprNodeFactory();
    public static final int OPERATION = 1;
    public static final int CONSTANT = 2;
    public static final int LITERAL = 4;
    public static final int FUNCTION = 8;
    public static final int CONTROL = 16;
    public static final int SET_OPERATION = 32;
    public static final int LAMBDA = 65;
    public static final int UNKNOWN = 0;
    public final ObjList<ExprNode> args = new ObjList(4);
    public String token;
    public int precedence;
    public int position;
    public ExprNode lhs;
    public ExprNode rhs;
    public int type;
    public int paramCount;
    public int intrinsicValue = 0;

    private ExprNode() {
    }

    @Override
    public void clear() {
        this.args.clear();
        this.token = null;
        this.precedence = 0;
        this.position = 0;
        this.lhs = null;
        this.rhs = null;
        this.type = 0;
        this.paramCount = 0;
        this.intrinsicValue = 0;
    }

    public ExprNode of(int type, String token, int precedence, int position) {
        this.type = type;
        this.precedence = precedence;
        this.token = token;
        this.position = position;
        return this;
    }

    @Override
    public void toSink(CharSink sink) {
        switch (this.paramCount) {
            case 0: {
                sink.put(this.token);
                break;
            }
            case 1: 
            case 2: {
                if (this.lhs != null) {
                    this.lhs.toSink(sink);
                }
                sink.put(' ');
                sink.put(this.token);
                sink.put(' ');
                if (this.rhs == null) break;
                this.rhs.toSink(sink);
                break;
            }
            default: {
                sink.put(this.token);
                sink.put('(');
                int n = this.args.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        sink.put(',');
                    }
                    this.args.getQuick(i).toSink(sink);
                }
                sink.put(')');
            }
        }
    }

    public String toString() {
        return "ExprNode{token='" + this.token + '\'' + ", precedence=" + this.precedence + ", lhs=" + this.lhs + ", rhs=" + this.rhs + ", type=" + this.type + ", paramCount=" + this.paramCount + ", args=" + this.args + ", position=" + this.position + '}';
    }

    private static final class ExprNodeFactory
    implements ObjectFactory<ExprNode> {
        private ExprNodeFactory() {
        }

        @Override
        public ExprNode newInstance() {
            return new ExprNode();
        }
    }
}

