/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql.model;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.IntervalCompiler;
import com.questdb.parser.sql.model.ExprNode;
import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.Chars;
import com.questdb.std.IntList;
import com.questdb.std.LongList;
import com.questdb.std.Mutable;
import com.questdb.std.ObjectFactory;

public class IntrinsicModel
implements Mutable {
    public static final IntrinsicModelFactory FACTORY = new IntrinsicModelFactory();
    private static final LongList INFINITE_INTERVAL = new LongList();
    public final CharSequenceHashSet keyValues = new CharSequenceHashSet();
    public final IntList keyValuePositions = new IntList();
    private final LongList intervalsA = new LongList();
    private final LongList intervalsB = new LongList();
    private final LongList intervalsC = new LongList();
    public String keyColumn;
    public ExprNode filter;
    public LongList intervals;
    public int intrinsicValue = 0;
    public boolean keyValuesIsLambda = false;

    private IntrinsicModel() {
    }

    @Override
    public void clear() {
        this.keyColumn = null;
        this.keyValues.clear();
        this.keyValuePositions.clear();
        this.clearInterval();
        this.filter = null;
        this.intervals = null;
        this.intrinsicValue = 0;
        this.keyValuesIsLambda = false;
    }

    public void clearInterval() {
        this.intervals = null;
    }

    public void excludeValue(ExprNode val) {
        String value = Chars.equals((CharSequence)"null", val.token) ? null : Chars.stripQuotes(val.token);
        int index = this.keyValues.remove(value);
        if (index > -1) {
            this.keyValuePositions.removeIndex(index);
        }
        if (this.keyValues.size() == 0) {
            this.intrinsicValue = 2;
        }
    }

    public void intersectIntervals(long lo, long hi) {
        LongList temp = this.shuffleTemp();
        temp.clear();
        temp.add(lo);
        temp.add(hi);
        this.intersectIntervals(temp);
    }

    public void intersectIntervals(CharSequence seq, int lo, int lim, int position) throws ParserException {
        LongList temp = this.shuffleTemp();
        temp.clear();
        IntervalCompiler.parseIntervalEx(seq, lo, lim, position, temp);
        this.intersectIntervals(temp);
    }

    public void subtractIntervals(long lo, long hi) {
        LongList temp = this.shuffleTemp();
        temp.clear();
        temp.add(lo);
        temp.add(hi);
        this.subtractIntervals(temp);
    }

    public void subtractIntervals(CharSequence seq, int lo, int lim, int position) throws ParserException {
        LongList temp = this.shuffleTemp();
        temp.clear();
        IntervalCompiler.parseIntervalEx(seq, lo, lim, position, temp);
        this.subtractIntervals(temp);
    }

    public String toString() {
        return "IntrinsicModel{keyValues=" + this.keyValues + ", keyColumn='" + this.keyColumn + '\'' + ", filter=" + this.filter + '}';
    }

    private void intersectIntervals(LongList intervals) {
        if (this.intervals == null) {
            this.intervals = intervals;
        } else {
            LongList dest = this.shuffleDest();
            dest.clear();
            IntervalCompiler.intersect(intervals, this.intervals, dest);
            this.intervals = dest;
        }
        if (this.intervals.size() == 0) {
            this.intrinsicValue = 2;
        }
    }

    private LongList shuffleDest() {
        if (this.intervals == null || this.intervals == this.intervalsA) {
            return this.intervalsB;
        }
        if (this.intervals == this.intervalsB) {
            return this.intervalsC;
        }
        return this.intervalsA;
    }

    private LongList shuffleTemp() {
        if (this.intervals == null || this.intervals == this.intervalsA) {
            return this.intervalsC;
        }
        if (this.intervals == this.intervalsB) {
            return this.intervalsA;
        }
        return this.intervalsB;
    }

    private void subtractIntervals(LongList temp) {
        LongList dest = this.shuffleDest();
        dest.clear();
        if (this.intervals == null) {
            IntervalCompiler.subtract(INFINITE_INTERVAL, temp, dest);
        } else {
            IntervalCompiler.subtract(temp, this.intervals, dest);
        }
        this.intervals = dest;
        if (this.intervals.size() == 0) {
            this.intrinsicValue = 2;
        }
    }

    static {
        INFINITE_INTERVAL.add(Long.MIN_VALUE);
        INFINITE_INTERVAL.add(Long.MAX_VALUE);
    }

    public static final class IntrinsicModelFactory
    implements ObjectFactory<IntrinsicModel> {
        @Override
        public IntrinsicModel newInstance() {
            return new IntrinsicModel();
        }
    }
}

