/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql.model;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.RecordMetadata;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryError;
import com.questdb.parser.sql.model.AliasTranslator;
import com.questdb.parser.sql.model.AnalyticColumn;
import com.questdb.parser.sql.model.ExprNode;
import com.questdb.parser.sql.model.JoinContext;
import com.questdb.parser.sql.model.ParsedModel;
import com.questdb.parser.sql.model.QueryColumn;
import com.questdb.parser.sql.model.WithClauseModel;
import com.questdb.ql.RecordSource;
import com.questdb.ql.ops.Parameter;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.sys.SysFactories;
import com.questdb.ql.sys.SystemViewFactory;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.CharSequenceObjHashMap;
import com.questdb.std.Chars;
import com.questdb.std.IntHashSet;
import com.questdb.std.IntList;
import com.questdb.std.Mutable;
import com.questdb.std.ObjList;
import com.questdb.std.ObjectFactory;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.StringSink;
import com.questdb.store.factory.Factory;
import com.questdb.store.factory.configuration.JournalMetadata;
import java.util.ArrayDeque;

public class QueryModel
implements Mutable,
ParsedModel,
AliasTranslator {
    public static final QueryModelFactory FACTORY = new QueryModelFactory();
    public static final int ORDER_DIRECTION_ASCENDING = 0;
    public static final int ORDER_DIRECTION_DESCENDING = 1;
    public static final String NO_ROWID_MARKER = "*!*";
    public static final int JOIN_INNER = 1;
    public static final int JOIN_OUTER = 2;
    public static final int JOIN_CROSS = 3;
    public static final int JOIN_ASOF = 4;
    private final ObjList<QueryColumn> columns = new ObjList();
    private final CharSequenceObjHashMap<QueryColumn> aliasToColumnMap = new CharSequenceObjHashMap();
    private final ObjList<QueryModel> joinModels = new ObjList();
    private final ObjList<ExprNode> orderBy = new ObjList();
    private final IntList orderByDirection = new IntList();
    private final IntHashSet dependencies = new IntHashSet();
    private final IntList orderedJoinModels1 = new IntList();
    private final IntList orderedJoinModels2 = new IntList();
    private final StringSink planSink = new StringSink();
    private final CharSequenceIntHashMap aliasIndexes = new CharSequenceIntHashMap();
    private final CharSequenceIntHashMap columnNameHistogram = new CharSequenceIntHashMap();
    private final ObjList<ExprNode> parsedWhere = new ObjList();
    private final IntHashSet parsedWhereConsts = new IntHashSet();
    private final ArrayDeque<ExprNode> exprNodeStack = new ArrayDeque();
    private final CharSequenceIntHashMap orderHash = new CharSequenceIntHashMap(4, 0.5, -1);
    private final ObjList<ExprNode> joinColumns = new ObjList(4);
    private final CharSequenceObjHashMap<WithClauseModel> withClauses = new CharSequenceObjHashMap();
    private CharSequenceObjHashMap<Parameter> parameterMap = new CharSequenceObjHashMap();
    private ExprNode whereClause;
    private ExprNode postJoinWhereClause;
    private QueryModel nestedModel;
    private ExprNode journalName;
    private ExprNode alias;
    private ExprNode latestBy;
    private ExprNode timestamp;
    private ExprNode sampleBy;
    private RecordSource recordSource;
    private RecordMetadata metadata;
    private JoinContext context;
    private ExprNode joinCriteria;
    private int joinType;
    private IntList orderedJoinModels = this.orderedJoinModels2;
    private ExprNode limitLo;
    private ExprNode limitHi;
    private VirtualColumn limitLoVc;
    private VirtualColumn limitHiVc;
    private JournalMetadata journalMetadata;

    private QueryModel() {
        this.joinModels.add(this);
    }

    public static boolean hasMarker(String name) {
        return name.indexOf(NO_ROWID_MARKER) == 0;
    }

    public static String stripMarker(String name) {
        return QueryModel.hasMarker(name) ? name.substring(NO_ROWID_MARKER.length()) : name;
    }

    public boolean addAliasIndex(ExprNode node, int index) {
        return this.aliasIndexes.put(node.token, index);
    }

    public void addColumn(QueryColumn column) {
        this.columns.add(column);
        if (column.getAlias() != null) {
            this.aliasToColumnMap.put(column.getAlias(), column);
        }
    }

    public void addDependency(int index) {
        this.dependencies.add(index);
    }

    public void addJoinColumn(ExprNode node) {
        this.joinColumns.add(node);
    }

    public void addJoinModel(QueryModel model) {
        this.joinModels.add(model);
    }

    public void addOrderBy(ExprNode node, int direction) {
        this.orderBy.add(node);
        this.orderByDirection.add(direction);
    }

    public void addParsedWhereConst(int index) {
        this.parsedWhereConsts.add(index);
    }

    public void addParsedWhereNode(ExprNode node) {
        this.parsedWhere.add(node);
    }

    public void addWithClause(String name, WithClauseModel model) {
        this.withClauses.put(name, model);
    }

    @Override
    public void clear() {
        this.columns.clear();
        this.aliasToColumnMap.clear();
        this.joinModels.clear();
        this.joinModels.add(this);
        this.sampleBy = null;
        this.orderBy.clear();
        this.orderByDirection.clear();
        this.dependencies.clear();
        this.parsedWhere.clear();
        this.whereClause = null;
        this.nestedModel = null;
        this.journalName = null;
        this.alias = null;
        this.latestBy = null;
        this.recordSource = null;
        this.metadata = null;
        this.joinCriteria = null;
        this.joinType = 1;
        this.orderedJoinModels1.clear();
        this.orderedJoinModels2.clear();
        this.parsedWhereConsts.clear();
        this.aliasIndexes.clear();
        this.postJoinWhereClause = null;
        this.context = null;
        this.orderedJoinModels = this.orderedJoinModels2;
        this.limitHi = null;
        this.limitLo = null;
        this.limitHiVc = null;
        this.limitLoVc = null;
        this.columnNameHistogram.clear();
        this.parameterMap.clear();
        this.timestamp = null;
        this.exprNodeStack.clear();
        this.journalMetadata = null;
        this.joinColumns.clear();
        this.withClauses.clear();
    }

    public RecordMetadata collectJournalMetadata(Factory factory) throws ParserException {
        if (this.journalMetadata != null) {
            return this.journalMetadata;
        }
        ExprNode readerNode = this.getJournalName();
        if (readerNode.type != 4 && readerNode.type != 2) {
            throw QueryError.$(readerNode.position, "Journal name must be either literal or string constant");
        }
        String reader = QueryModel.stripMarker(Chars.stripQuotes(readerNode.token));
        SystemViewFactory systemViewFactory = SysFactories.getFactory(reader);
        if (systemViewFactory != null) {
            return systemViewFactory.getMetadata();
        }
        int status = factory.getConfiguration().exists(reader);
        if (status == 2) {
            throw QueryError.$(readerNode.position, "Journal does not exist");
        }
        if (status == 4) {
            throw QueryError.$(readerNode.position, "Journal directory is of unknown format");
        }
        try {
            this.journalMetadata = factory.getConfiguration().readMetadata(reader);
            return this.journalMetadata;
        }
        catch (JournalException e) {
            throw QueryError.$(readerNode.position, e.getMessage());
        }
    }

    public void createColumnNameHistogram(Factory factory) throws ParserException {
        this.columnNameHistogram.clear();
        QueryModel.createColumnNameHistogram0(this.columnNameHistogram, this, factory, false);
    }

    public void createColumnNameHistogram(RecordSource rs) {
        RecordMetadata m = rs.getMetadata();
        int n = m.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.columnNameHistogram.increment(m.getColumnName(i));
        }
    }

    public ExprNode getAlias() {
        return this.alias;
    }

    public void setAlias(ExprNode alias) {
        this.alias = alias;
    }

    public int getAliasIndex(CharSequence alias) {
        return this.aliasIndexes.get(alias);
    }

    public CharSequenceIntHashMap getColumnNameHistogram() {
        return this.columnNameHistogram;
    }

    public ObjList<QueryColumn> getColumns() {
        return this.columns;
    }

    public JoinContext getContext() {
        return this.context;
    }

    public void setContext(JoinContext context) {
        this.context = context;
    }

    public IntHashSet getDependencies() {
        return this.dependencies;
    }

    public ObjList<ExprNode> getJoinColumns() {
        return this.joinColumns;
    }

    public ExprNode getJoinCriteria() {
        return this.joinCriteria;
    }

    public void setJoinCriteria(ExprNode joinCriteria) {
        this.joinCriteria = joinCriteria;
    }

    public ObjList<QueryModel> getJoinModels() {
        return this.joinModels;
    }

    public int getJoinType() {
        return this.joinType;
    }

    public void setJoinType(int joinType) {
        this.joinType = joinType;
    }

    public ExprNode getJournalName() {
        return this.journalName;
    }

    public void setJournalName(ExprNode journalName) {
        this.journalName = journalName;
    }

    public ExprNode getLatestBy() {
        return this.latestBy;
    }

    public void setLatestBy(ExprNode latestBy) {
        this.latestBy = latestBy;
    }

    public ExprNode getLimitHi() {
        return this.limitHi;
    }

    public VirtualColumn getLimitHiVc() {
        return this.limitHiVc;
    }

    public ExprNode getLimitLo() {
        return this.limitLo;
    }

    public VirtualColumn getLimitLoVc() {
        return this.limitLoVc;
    }

    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(RecordMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public int getModelType() {
        return 1;
    }

    public QueryModel getNestedModel() {
        return this.nestedModel;
    }

    public void setNestedModel(QueryModel nestedModel) {
        this.nestedModel = nestedModel;
    }

    public ObjList<ExprNode> getOrderBy() {
        return this.orderBy;
    }

    public IntList getOrderByDirection() {
        return this.orderByDirection;
    }

    public CharSequenceIntHashMap getOrderHash() {
        return this.orderHash;
    }

    public IntList getOrderedJoinModels() {
        return this.orderedJoinModels;
    }

    public void setOrderedJoinModels(IntList that) {
        if (that != this.orderedJoinModels1 && that != this.orderedJoinModels2) {
            throw new JournalRuntimeException("Passing foreign list breaks convention", new Object[0]);
        }
        this.orderedJoinModels = that;
    }

    public CharSequenceObjHashMap<Parameter> getParameterMap() {
        return this.parameterMap;
    }

    public void setParameterMap(CharSequenceObjHashMap<Parameter> parameterMap) {
        this.parameterMap = parameterMap;
    }

    public ObjList<ExprNode> getParsedWhere() {
        return this.parsedWhere;
    }

    public IntHashSet getParsedWhereConsts() {
        return this.parsedWhereConsts;
    }

    public ExprNode getPostJoinWhereClause() {
        return this.postJoinWhereClause;
    }

    public void setPostJoinWhereClause(ExprNode postJoinWhereClause) {
        this.postJoinWhereClause = postJoinWhereClause;
    }

    public RecordSource getRecordSource() {
        return this.recordSource;
    }

    public void setRecordSource(RecordSource recordSource) {
        this.recordSource = recordSource;
    }

    public ExprNode getSampleBy() {
        return this.sampleBy;
    }

    public void setSampleBy(ExprNode sampleBy) {
        this.sampleBy = sampleBy;
    }

    public ExprNode getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(ExprNode timestamp) {
        this.timestamp = timestamp;
    }

    public ExprNode getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(ExprNode whereClause) {
        this.whereClause = whereClause;
    }

    public WithClauseModel getWithClause(CharSequence name) {
        return this.withClauses.get(name);
    }

    public IntList nextOrderedJoinModels() {
        IntList ordered = this.orderedJoinModels == this.orderedJoinModels1 ? this.orderedJoinModels2 : this.orderedJoinModels1;
        ordered.clear();
        return ordered;
    }

    public ObjList<ExprNode> parseWhereClause() {
        ExprNode n = this.getWhereClause();
        this.exprNodeStack.clear();
        block6: while (!this.exprNodeStack.isEmpty() || n != null) {
            if (n != null) {
                switch (n.token) {
                    case "and": {
                        if (n.rhs != null) {
                            this.exprNodeStack.push(n.rhs);
                        }
                        n = n.lhs;
                        continue block6;
                    }
                }
                this.addParsedWhereNode(n);
                n = null;
                continue;
            }
            n = this.exprNodeStack.poll();
        }
        return this.getParsedWhere();
    }

    public CharSequence plan() {
        this.planSink.clear();
        this.plan(this.planSink, 0);
        return this.planSink;
    }

    public void removeDependency(int index) {
        this.dependencies.remove(index);
    }

    public void setLimit(ExprNode lo, ExprNode hi) {
        this.limitLo = lo;
        this.limitHi = hi;
    }

    public void setLimitVc(VirtualColumn lo, VirtualColumn hi) {
        this.limitLoVc = lo;
        this.limitHiVc = hi;
    }

    public String toString() {
        return this.alias != null ? this.alias.token : (this.journalName != null ? this.journalName.token : '{' + this.nestedModel.toString() + '}');
    }

    @Override
    public CharSequence translateAlias(CharSequence column) {
        QueryColumn referent = this.aliasToColumnMap.get(column);
        if (referent != null && !(referent instanceof AnalyticColumn) && referent.getAst().type == 4) {
            return referent.getAst().token;
        }
        return column;
    }

    private static void createColumnNameHistogram0(CharSequenceIntHashMap histogram, QueryModel model, Factory factory, boolean ignoreJoins) throws ParserException {
        ObjList<QueryModel> jm = model.getJoinModels();
        int jmSize = ignoreJoins ? 0 : jm.size();
        int n = model.getColumns().size();
        if (n > 0) {
            block3: for (int i = 0; i < n; ++i) {
                QueryColumn qc = model.getColumns().getQuick(i);
                switch (qc.getAst().type) {
                    case 4: {
                        histogram.increment(qc.getName());
                        continue block3;
                    }
                }
            }
        } else if (jmSize > 0) {
            for (int i = 0; i < jmSize; ++i) {
                QueryModel.createColumnNameHistogram0(histogram, jm.getQuick(i), factory, true);
            }
        } else if (model.getJournalName() != null) {
            RecordMetadata m = model.collectJournalMetadata(factory);
            int k = m.getColumnCount();
            for (int i = 0; i < k; ++i) {
                histogram.increment(m.getColumnName(i));
            }
        } else {
            QueryModel.createColumnNameHistogram0(histogram, model.getNestedModel(), factory, false);
        }
    }

    private void plan(StringSink sink, int pad) {
        ObjList<QueryModel> joinModels = this.getJoinModels();
        if (joinModels.size() > 1) {
            IntList ordered = this.getOrderedJoinModels();
            int n = ordered.size();
            for (int i = 0; i < n; ++i) {
                int index = ordered.getQuick(i);
                QueryModel m = joinModels.getQuick(index);
                JoinContext jc = m.getContext();
                sink.put(' ', pad).put('+').put(' ').put(index);
                sink.put('[').put(' ');
                switch (m.getJoinType()) {
                    case 3: {
                        sink.put("cross");
                        break;
                    }
                    case 1: {
                        sink.put("inner");
                        break;
                    }
                    case 2: {
                        sink.put("outer");
                        break;
                    }
                    case 4: {
                        sink.put("asof");
                        break;
                    }
                    default: {
                        sink.put("unknown");
                    }
                }
                sink.put(' ').put(']').put(' ');
                if (m.getAlias() != null) {
                    sink.put(m.getAlias().token);
                } else if (m.getJournalName() != null) {
                    sink.put(m.getJournalName().token);
                } else {
                    sink.put('{').put('\n');
                    m.getNestedModel().plan(sink, pad + 2);
                    sink.put('}');
                }
                ExprNode filter = this.getJoinModels().getQuick(index).getWhereClause();
                if (filter != null) {
                    sink.put(" (filter: ");
                    filter.toSink(sink);
                    sink.put(')');
                }
                if (jc != null && jc.aIndexes.size() > 0) {
                    sink.put(" ON ");
                    int z = jc.aIndexes.size();
                    for (int k = 0; k < z; ++k) {
                        if (k > 0) {
                            sink.put(" and ");
                        }
                        jc.aNodes.getQuick(k).toSink(sink);
                        sink.put(" = ");
                        jc.bNodes.getQuick(k).toSink(sink);
                    }
                }
                if ((filter = m.getPostJoinWhereClause()) != null) {
                    sink.put(" (post-filter: ");
                    filter.toSink(sink);
                    sink.put(')');
                }
                sink.put('\n');
            }
        } else {
            ExprNode latestBy;
            sink.put(' ', pad);
            if (this.getAlias() != null) {
                sink.put(this.getAlias().token);
            } else if (this.getJournalName() != null) {
                sink.put(this.getJournalName().token);
            } else {
                this.getNestedModel().plan(sink, pad + 2);
            }
            ExprNode filter = this.getWhereClause();
            if (filter != null) {
                sink.put(" (filter: ");
                filter.toSink(sink);
                sink.put(')');
            }
            if ((latestBy = this.getLatestBy()) != null) {
                sink.put(" (latest by: ");
                latestBy.toSink(sink);
                sink.put(')');
            }
        }
        sink.put('\n');
    }

    private static final class QueryModelFactory
    implements ObjectFactory<QueryModel> {
        private QueryModelFactory() {
        }

        @Override
        public QueryModel newInstance() {
            return new QueryModel();
        }
    }
}

