/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.typeprobe;

import com.questdb.common.NumericException;
import com.questdb.parser.typeprobe.TypeProbe;
import com.questdb.std.time.DateFormat;
import com.questdb.std.time.DateFormatFactory;
import com.questdb.std.time.DateLocale;

public class DateProbe
implements TypeProbe {
    private final String pattern;
    private final DateLocale dateLocale;
    private final DateFormat format;

    public DateProbe(DateFormatFactory dateFormatFactory, DateLocale dateLocale, String pattern) {
        this.dateLocale = dateLocale;
        this.pattern = pattern;
        this.format = dateFormatFactory.get(pattern);
    }

    @Override
    public DateFormat getDateFormat() {
        return this.format;
    }

    @Override
    public DateLocale getDateLocale() {
        return this.dateLocale;
    }

    @Override
    public String getFormat() {
        return this.pattern;
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    public boolean probe(CharSequence text) {
        try {
            this.format.parse(text, this.dateLocale);
            return true;
        }
        catch (NumericException e) {
            return false;
        }
    }
}

