/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.typeprobe;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.parser.typeprobe.BooleanProbe;
import com.questdb.parser.typeprobe.DateProbe;
import com.questdb.parser.typeprobe.DoubleProbe;
import com.questdb.parser.typeprobe.IntProbe;
import com.questdb.parser.typeprobe.LongProbe;
import com.questdb.parser.typeprobe.TypeProbe;
import com.questdb.std.Files;
import com.questdb.std.ObjList;
import com.questdb.std.Os;
import com.questdb.std.Unsafe;
import com.questdb.std.str.DirectByteCharSequence;
import com.questdb.std.str.Path;
import com.questdb.std.time.DateFormatFactory;
import com.questdb.std.time.DateLocale;
import com.questdb.std.time.DateLocaleFactory;
import java.io.IOException;

public class TypeProbeCollection {
    private static final Log LOG = LogFactory.getLog(TypeProbeCollection.class);
    private static final ObjList<String> DEFAULT_DATE_FORMATS = new ObjList();
    private final ObjList<TypeProbe> probes = new ObjList();
    private final int probeCount;

    public TypeProbeCollection() {
        this.addDefaultProbes();
        DateFormatFactory dateFormatFactory = new DateFormatFactory();
        DateLocale dateLocale = DateLocaleFactory.INSTANCE.getDefaultDateLocale();
        int n = DEFAULT_DATE_FORMATS.size();
        for (int i = 0; i < n; ++i) {
            this.probes.add(new DateProbe(dateFormatFactory, dateLocale, DEFAULT_DATE_FORMATS.getQuick(i)));
        }
        this.probeCount = this.probes.size();
    }

    public TypeProbeCollection(CharSequence file, DateFormatFactory dateFormatFactory, DateLocaleFactory dateLocaleFactory) throws IOException {
        this.addDefaultProbes();
        this.parseFile(file, dateFormatFactory, dateLocaleFactory);
        this.probeCount = this.probes.size();
    }

    public TypeProbe getProbe(int index) {
        return this.probes.getQuick(index);
    }

    public int getProbeCount() {
        return this.probeCount;
    }

    private void addDefaultProbes() {
        this.probes.add(new IntProbe());
        this.probes.add(new LongProbe());
        this.probes.add(new DoubleProbe());
        this.probes.add(new BooleanProbe());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(CharSequence fileName, DateFormatFactory dateFormatFactory, DateLocaleFactory dateLocaleFactory) throws IOException {
        DirectByteCharSequence dbcs = new DirectByteCharSequence();
        try (Path path = new Path().of(fileName).$();){
            long fd = Files.openRO(path);
            if (fd < 0L) {
                throw new IOException("Cannot open " + fileName + " [errno=" + Os.errno() + ']');
            }
            long sz = Files.length(fd);
            long buf = Unsafe.malloc(sz);
            try {
                Files.read(fd, buf, sz, 0L);
                long p = buf;
                long hi = p + sz;
                long _lo = p;
                boolean newline = true;
                boolean comment = false;
                boolean quote = false;
                boolean space = true;
                String pattern = null;
                block18: while (p < hi) {
                    char b = (char)Unsafe.getUnsafe().getByte(p++);
                    switch (b) {
                        case '#': {
                            comment = newline;
                            continue block18;
                        }
                        case '\'': {
                            if (comment) continue block18;
                            if (quote) {
                                if (pattern == null) {
                                    pattern = dbcs.of(_lo, p - 1L).toString();
                                    _lo = p;
                                    space = true;
                                    quote = false;
                                    continue block18;
                                }
                                LOG.error().$("Internal error").$();
                                continue block18;
                            }
                            if (!newline) continue block18;
                            _lo = p;
                            quote = true;
                            continue block18;
                        }
                        case '\t': 
                        case ' ': {
                            if (comment || quote) continue block18;
                            if (space) {
                                _lo = p;
                                continue block18;
                            }
                            space = true;
                            newline = false;
                            String s = dbcs.of(_lo, p - 1L).toString();
                            if (pattern == null) {
                                pattern = s;
                                _lo = p;
                                space = true;
                                continue block18;
                            }
                            DateLocale locale = dateLocaleFactory.getDateLocale(s);
                            if (locale == null) {
                                LOG.error().$("Unknown date locale: ").$(s).$();
                                comment = true;
                                continue block18;
                            }
                            this.probes.add(new DateProbe(dateFormatFactory, locale, pattern));
                            continue block18;
                        }
                        case '\n': 
                        case '\r': {
                            DateLocale locale;
                            String s;
                            if (!comment) {
                                if (_lo < p - 1L) {
                                    s = dbcs.of(_lo, p - 1L).toString();
                                    if (pattern == null) {
                                        this.probes.add(new DateProbe(dateFormatFactory, dateLocaleFactory.getDefaultDateLocale(), s));
                                    } else {
                                        locale = dateLocaleFactory.getDateLocale(s);
                                        if (locale == null) {
                                            LOG.error().$("Unknown date locale: ").$(s).$();
                                        } else {
                                            this.probes.add(new DateProbe(dateFormatFactory, locale, pattern));
                                        }
                                    }
                                } else if (pattern != null) {
                                    this.probes.add(new DateProbe(dateFormatFactory, dateLocaleFactory.getDefaultDateLocale(), pattern));
                                }
                            }
                            newline = true;
                            comment = false;
                            quote = false;
                            pattern = null;
                            space = false;
                            _lo = p;
                            continue block18;
                        }
                    }
                    if (newline) {
                        newline = false;
                    }
                    if (!space) continue;
                    space = false;
                }
            }
            finally {
                Unsafe.free(buf, sz);
            }
        }
    }

    static {
        DEFAULT_DATE_FORMATS.add("yyyy-MM-ddTHH:mm:ss.SSSz");
        DEFAULT_DATE_FORMATS.add("yyyy-MM-dd HH:mm:ss");
        DEFAULT_DATE_FORMATS.add("dd/MM/y");
        DEFAULT_DATE_FORMATS.add("MM/dd/y");
    }
}

