/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.ex.DisconnectedChannelRuntimeException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.ql.CancellationHandler;
import com.questdb.std.Net;
import com.questdb.std.Numbers;

public class ChannelCheckCancellationHandler
implements CancellationHandler {
    private static final Log LOG = LogFactory.getLog(ChannelCheckCancellationHandler.class);
    private final long fd;
    private final long mask;
    private long loop = 0L;

    public ChannelCheckCancellationHandler(long fd, int cyclesBeforeCheck) {
        this.fd = fd;
        this.mask = Numbers.ceilPow2(cyclesBeforeCheck) - 1;
    }

    @Override
    public void check() {
        if (this.loop > 0L && (this.loop & this.mask) == 0L) {
            this.checkChannel();
        }
        ++this.loop;
    }

    public void reset() {
        this.loop = 0L;
    }

    private void checkChannel() {
        if (Net.isDead(this.fd)) {
            LOG.info().$("Socket closed, possibly cancelled request. FD=").$(this.fd).$();
            throw DisconnectedChannelRuntimeException.INSTANCE;
        }
    }
}

