/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.common.AbstractRecordMetadata;
import com.questdb.common.JournalRuntimeException;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.Chars;
import com.questdb.std.ObjList;
import com.questdb.store.factory.configuration.ColumnName;

public class CollectionRecordMetadata
extends AbstractRecordMetadata {
    private final ObjList<RecordColumnMetadata> columns = new ObjList();
    private final CharSequenceIntHashMap nameIndexLookup = new CharSequenceIntHashMap();

    public CollectionRecordMetadata add(RecordColumnMetadata meta) {
        if (this.nameIndexLookup.put(meta.getName(), this.columns.size())) {
            this.columns.add(meta);
            return this;
        }
        throw new JournalRuntimeException("Duplicate column name", new Object[0]);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getColumnIndexQuiet(CharSequence name) {
        int index = this.nameIndexLookup.get(name);
        if (index > -1) {
            return index;
        }
        if (this.getAlias() == null) {
            return -1;
        }
        ColumnName columnName = ColumnName.singleton(name);
        if (columnName.alias().length() == 0) {
            return -1;
        }
        if (Chars.equals(columnName.alias(), this.getAlias())) {
            return this.nameIndexLookup.get(columnName.name());
        }
        return -1;
    }

    @Override
    public RecordColumnMetadata getColumnQuick(int index) {
        return this.columns.getQuick(index);
    }

    @Override
    public int getTimestampIndex() {
        return -1;
    }
}

