/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.parser.sql.model.ExprNode;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.RecordSource;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.Misc;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;

public class FilteredRecordSource
extends AbstractCombinedRecordSource {
    private final RecordSource delegate;
    private final VirtualColumn filter;
    private final ExprNode filterNode;
    private RecordCursor cursor;
    private Record record;

    public FilteredRecordSource(RecordSource delegate, VirtualColumn filter, ExprNode filterNode) {
        this.delegate = delegate;
        this.filter = filter;
        this.filterNode = filterNode;
    }

    @Override
    public void close() {
        Misc.free(this.delegate);
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.delegate.getMetadata();
    }

    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        this.cursor = this.delegate.prepareCursor(factory, cancellationHandler);
        this.filter.prepare(this.cursor.getStorageFacade());
        return this;
    }

    @Override
    public Record getRecord() {
        return this.delegate.getRecord();
    }

    @Override
    public Record newRecord() {
        return this.delegate.newRecord();
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.cursor.getStorageFacade();
    }

    @Override
    public void releaseCursor() {
        this.cursor.releaseCursor();
    }

    @Override
    public void toTop() {
        this.cursor.toTop();
    }

    @Override
    public boolean hasNext() {
        while (this.cursor.hasNext()) {
            this.record = (Record)this.cursor.next();
            if (!this.filter.getBool(this.record)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Record next() {
        return this.record;
    }

    @Override
    public Record recordAt(long rowId) {
        return this.cursor.recordAt(rowId);
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.cursor.recordAt(record, atRowId);
    }

    @Override
    public boolean supportsRowIdAccess() {
        return this.delegate.supportsRowIdAccess();
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("FilteredRecordSource").put(',');
        sink.putQuoted("src").put(':').put(this.delegate).put(',');
        sink.putQuoted("filter").put(':').put('\"').put(this.filterNode).put('\"');
        sink.put('}');
    }
}

