/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.JournalRecord;
import com.questdb.ql.PartitionSlice;
import com.questdb.ql.RowCursor;
import com.questdb.ql.RowSource;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadata;

public class FilteredRowSource
implements RowSource,
RowCursor {
    private final RowSource delegate;
    private final VirtualColumn filter;
    private final JournalRecord rec = new JournalRecord();
    private RowCursor underlying;

    public FilteredRowSource(RowSource delegate, VirtualColumn filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public void configure(JournalMetadata metadata) {
        this.delegate.configure(metadata);
    }

    @Override
    public void prepare(ReaderFactory factory, StorageFacade facade, CancellationHandler cancellationHandler) {
        this.delegate.prepare(factory, facade, cancellationHandler);
        this.filter.prepare(facade);
    }

    @Override
    public RowCursor prepareCursor(PartitionSlice slice) {
        this.underlying = this.delegate.prepareCursor(slice);
        this.rec.partition = slice.partition;
        return this;
    }

    @Override
    public void toTop() {
        this.delegate.toTop();
    }

    @Override
    public boolean hasNext() {
        while (this.underlying.hasNext()) {
            this.rec.rowid = this.underlying.next();
            if (!this.filter.getBool(this.rec)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long next() {
        return this.rec.rowid;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("FilteredRowSource").put(',');
        sink.putQuoted("rsrc").put(':').put(this.delegate);
        sink.put('}');
    }

    public String toString() {
        return "FilteredRowSource{}";
    }
}

