/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.StorageFacade;
import com.questdb.ql.MasterStorageFacade;
import com.questdb.ql.PartitionCursor;
import com.questdb.ql.PartitionSlice;
import com.questdb.ql.PartitionSource;
import com.questdb.std.ImmutableIterator;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.FileNameExtractorCharSequence;
import com.questdb.store.Journal;
import com.questdb.store.Partition;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadata;

public class JournalPartitionSource
implements PartitionSource,
PartitionCursor,
ImmutableIterator<PartitionSlice> {
    private final boolean open;
    private final PartitionSlice slice = new PartitionSlice();
    private final JournalMetadata metadata;
    private final MasterStorageFacade storageFacade = new MasterStorageFacade();
    private Journal journal;
    private int partitionCount;
    private int partitionIndex;

    public JournalPartitionSource(JournalMetadata metadata, boolean open) {
        this.metadata = metadata;
        this.open = open;
    }

    @Override
    public JournalMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public PartitionCursor prepareCursor(ReaderFactory factory) {
        try {
            this.journal = factory.reader(this.metadata);
            this.journal.refresh();
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
        this.storageFacade.of(this.journal.getMetadata());
        this.partitionCount = this.journal.getPartitionCount();
        this.partitionIndex = 0;
        return this;
    }

    @Override
    public Partition getPartition(int index) {
        try {
            return this.journal.getPartition(index, true);
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.storageFacade;
    }

    @Override
    public void releaseCursor() {
        if (this.journal != null) {
            this.journal.close();
            this.journal = null;
        }
    }

    @Override
    public void toTop() {
        this.partitionIndex = 0;
    }

    @Override
    public boolean hasNext() {
        return this.partitionIndex < this.partitionCount;
    }

    @Override
    public PartitionSlice next() {
        try {
            this.slice.partition = this.journal.getPartition(this.partitionIndex++, this.open);
            this.slice.lo = 0L;
            this.slice.calcHi = true;
            return this.slice;
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("JournalPartitionSource").put(',');
        sink.putQuoted("journal").put(':').putQuoted(FileNameExtractorCharSequence.get(this.metadata.getName()));
        sink.put('}');
    }
}

