/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.JournalRecord;
import com.questdb.ql.PartitionCursor;
import com.questdb.ql.PartitionSlice;
import com.questdb.ql.PartitionSource;
import com.questdb.ql.RowCursor;
import com.questdb.ql.RowSource;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.std.Rows;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadata;

public class JournalRecordSource
extends AbstractCombinedRecordSource {
    private final PartitionSource partitionSource;
    private final RowSource rowSource;
    private final JournalRecord record;
    private final JournalMetadata metadata;
    private PartitionCursor partitionCursor;
    private RowCursor cursor;

    public JournalRecordSource(PartitionSource partitionSource, RowSource rowSource) {
        this.metadata = partitionSource.getMetadata();
        this.record = new JournalRecord();
        this.partitionSource = partitionSource;
        rowSource.configure(partitionSource.getMetadata());
        this.rowSource = rowSource;
    }

    @Override
    public void close() {
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        this.rowSource.toTop();
        this.cursor = null;
        this.partitionCursor = this.partitionSource.prepareCursor(factory);
        this.rowSource.prepare(factory, this.partitionCursor.getStorageFacade(), cancellationHandler);
        return this;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record newRecord() {
        return new JournalRecord();
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.partitionCursor.getStorageFacade();
    }

    @Override
    public void releaseCursor() {
        this.partitionCursor.releaseCursor();
    }

    @Override
    public void toTop() {
        this.cursor = null;
        this.partitionCursor.toTop();
    }

    @Override
    public boolean hasNext() {
        return this.cursor != null && this.cursor.hasNext() || this.nextSlice();
    }

    @Override
    public JournalRecord next() {
        this.record.rowid = this.cursor.next();
        return this.record;
    }

    @Override
    public JournalRecord recordAt(long rowId) {
        this.record.rowid = Rows.toLocalRowID(rowId);
        this.setPartition(this.record, rowId);
        return this.record;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        ((JournalRecord)record).rowid = Rows.toLocalRowID(atRowId);
        this.setPartition((JournalRecord)record, atRowId);
    }

    @Override
    public boolean supportsRowIdAccess() {
        return true;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("JournalRecordSource").put(',');
        sink.putQuoted("psrc").put(':').put(this.partitionSource).put(',');
        sink.putQuoted("rsrc").put(':').put(this.rowSource);
        sink.put('}');
    }

    private boolean nextSlice() {
        while (this.partitionCursor.hasNext()) {
            PartitionSlice slice = (PartitionSlice)this.partitionCursor.next();
            this.cursor = this.rowSource.prepareCursor(slice);
            if (this.cursor == null) {
                return false;
            }
            if (!this.cursor.hasNext()) continue;
            this.record.partition = slice.partition;
            this.record.partitionIndex = slice.partition.getPartitionIndex();
            return true;
        }
        return false;
    }

    private void setPartition(JournalRecord record, long rowId) {
        int partIndex = Rows.toPartitionIndex(rowId);
        if (partIndex != record.partitionIndex) {
            record.partitionIndex = partIndex;
            record.partition = this.partitionCursor.getPartition(partIndex);
        }
    }
}

