/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.RecordListRecord;
import com.questdb.std.Chars;
import com.questdb.std.DirectInputStream;
import com.questdb.std.MemoryPages;
import com.questdb.std.Misc;
import com.questdb.std.Mutable;
import com.questdb.std.Unsafe;
import java.io.Closeable;

public class RecordList
implements Closeable,
RecordCursor,
Mutable {
    private final MemoryPages mem;
    private final RecordListRecord record;
    private final RecordMetadata metadata;
    private final int columnCount;
    private final int headerSize;
    private final int recordPrefix;
    private long readAddress = -1L;
    private StorageFacade storageFacade;
    private long hPtr;
    private long wPtr;

    public RecordList(RecordMetadata recordMetadata, int pageSize) {
        this.metadata = recordMetadata;
        this.mem = new MemoryPages(pageSize);
        this.record = new RecordListRecord(recordMetadata, this.mem);
        this.headerSize = this.record.getHeaderSize();
        this.columnCount = recordMetadata.getColumnCount();
        this.recordPrefix = this.headerSize + this.record.getFixedSize();
    }

    public long append(Record record, long prevAddress) {
        long thisAddress = this.beginRecord0(prevAddress);
        this.append0(record, thisAddress);
        return thisAddress;
    }

    public void appendBool(boolean value) {
        this.appendByte((byte)(value ? 1 : 0));
    }

    public void appendByte(byte value) {
        Unsafe.getUnsafe().putByte(this.wPtr, value);
        ++this.wPtr;
    }

    public void appendDouble(double value) {
        Unsafe.getUnsafe().putDouble(this.wPtr, value);
        this.wPtr += 8L;
    }

    public void appendFloat(float value) {
        Unsafe.getUnsafe().putFloat(this.wPtr, value);
        this.wPtr += 4L;
    }

    public void appendInt(int value) {
        Unsafe.getUnsafe().putInt(this.wPtr, value);
        this.wPtr += 4L;
    }

    public void appendLong(long value) {
        Unsafe.getUnsafe().putLong(this.wPtr, value);
        this.wPtr += 8L;
    }

    public void appendStr(CharSequence value) {
        this.writeString(this.hPtr, value);
        this.hPtr += 8L;
    }

    public long beginRecord(long prevAddress) {
        this.hPtr = this.beginRecord0(prevAddress);
        this.wPtr = this.hPtr + (long)this.headerSize;
        return this.hPtr;
    }

    @Override
    public void clear() {
        this.mem.clear();
        this.readAddress = -1L;
    }

    @Override
    public void close() {
        Misc.free(this.mem);
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public RecordListRecord newRecord() {
        RecordListRecord record = new RecordListRecord(this.metadata, this.mem);
        record.setStorageFacade(this.storageFacade);
        return record;
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.storageFacade;
    }

    public void setStorageFacade(StorageFacade storageFacade) {
        this.storageFacade = storageFacade;
        this.record.setStorageFacade(this.storageFacade);
    }

    @Override
    public Record recordAt(long rowId) {
        this.record.of(rowId);
        return this.record;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        ((RecordListRecord)record).of(atRowId);
    }

    @Override
    public void releaseCursor() {
        this.clear();
    }

    @Override
    public void toTop() {
        this.readAddress = this.mem.size() == 0L ? -1L : this.mem.addressOf(0L) + 8L;
    }

    @Override
    public boolean hasNext() {
        return this.readAddress > -1L;
    }

    @Override
    public Record next() {
        this.record.of(this.readAddress);
        this.readAddress = Unsafe.getUnsafe().getLong(this.readAddress - 8L);
        return this.record;
    }

    public void of(long offset) {
        this.readAddress = offset;
    }

    public void putShort(short value) {
        Unsafe.getUnsafe().putShort(this.wPtr, value);
        this.wPtr += 2L;
    }

    private void append0(Record record, long address) {
        long headerAddress = address;
        long writeAddress = headerAddress + (long)this.headerSize;
        block13: for (int i = 0; i < this.columnCount; ++i) {
            switch (this.metadata.getColumnQuick(i).getType()) {
                case 0: {
                    Unsafe.getUnsafe().putByte(writeAddress, (byte)(record.getBool(i) ? 1 : 0));
                    ++writeAddress;
                    continue block13;
                }
                case 1: {
                    Unsafe.getUnsafe().putByte(writeAddress, record.get(i));
                    ++writeAddress;
                    continue block13;
                }
                case 2: {
                    Unsafe.getUnsafe().putDouble(writeAddress, record.getDouble(i));
                    writeAddress += 8L;
                    continue block13;
                }
                case 4: {
                    Unsafe.getUnsafe().putInt(writeAddress, record.getInt(i));
                    writeAddress += 4L;
                    continue block13;
                }
                case 5: {
                    Unsafe.getUnsafe().putLong(writeAddress, record.getLong(i));
                    writeAddress += 8L;
                    continue block13;
                }
                case 6: {
                    Unsafe.getUnsafe().putShort(writeAddress, record.getShort(i));
                    writeAddress += 2L;
                    continue block13;
                }
                case 8: {
                    Unsafe.getUnsafe().putInt(writeAddress, record.getInt(i));
                    writeAddress += 4L;
                    continue block13;
                }
                case 10: {
                    Unsafe.getUnsafe().putLong(writeAddress, record.getDate(i));
                    writeAddress += 8L;
                    continue block13;
                }
                case 3: {
                    Unsafe.getUnsafe().putFloat(writeAddress, record.getFloat(i));
                    writeAddress += 4L;
                    continue block13;
                }
                case 7: {
                    this.writeString(headerAddress, record.getFlyweightStr(i));
                    headerAddress += 8L;
                    continue block13;
                }
                case 9: {
                    this.writeBin(headerAddress, record.getBin(i));
                    headerAddress += 8L;
                    continue block13;
                }
                default: {
                    throw new JournalRuntimeException("Unsupported type: " + this.metadata.getColumnQuick(i).getType(), new Object[0]);
                }
            }
        }
    }

    private long beginRecord0(long prevAddress) {
        long thisAddress = this.mem.allocate(8 + this.recordPrefix) + 8L;
        if (prevAddress != -1L) {
            Unsafe.getUnsafe().putLong(prevAddress - 8L, thisAddress);
        }
        Unsafe.getUnsafe().putLong(thisAddress - 8L, -1L);
        return thisAddress;
    }

    private void writeBin(long headerAddress, DirectInputStream value) {
        int sz;
        long offset = this.mem.allocateOffset(8L);
        long len = value == null ? -1L : value.size();
        Unsafe.getUnsafe().putLong(headerAddress, offset);
        Unsafe.getUnsafe().putLong(this.mem.addressOf(offset), len);
        if (len < 1L) {
            return;
        }
        offset = this.mem.allocateOffset(1L);
        long p = 0L;
        do {
            int remaining;
            sz = (long)(remaining = this.mem.pageRemaining(offset)) < len ? remaining : (int)len;
            value.copyTo(this.mem.addressOf(offset), p, sz);
            p += (long)sz;
            this.mem.allocateOffset(sz);
            offset += (long)sz;
        } while ((len -= (long)sz) > 0L);
    }

    private void writeNullString(long headerAddress) {
        long addr = this.mem.allocate(4L);
        Unsafe.getUnsafe().putLong(headerAddress, addr);
        Unsafe.getUnsafe().putInt(addr, -1);
    }

    private void writeString(long headerAddress, CharSequence value) {
        if (value == null) {
            this.writeNullString(headerAddress);
            return;
        }
        int l = value.length();
        if (l > this.mem.pageSize()) {
            throw new JournalRuntimeException("String larger than pageSize", new Object[0]);
        }
        long addr = this.mem.allocate(l * 2 + 4);
        Unsafe.getUnsafe().putLong(headerAddress, addr);
        Chars.strcpyw(value, addr);
    }
}

