/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.common.ColumnType;
import com.questdb.common.JournalRuntimeException;
import com.questdb.common.Record;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.std.DirectInputStream;
import com.questdb.std.MemoryPages;
import com.questdb.std.Unsafe;
import com.questdb.std.str.DirectCharSequence;
import java.io.IOException;
import java.io.OutputStream;

public class RecordListRecord
implements Record {
    private final MemoryPages mem;
    private final int headerSize;
    private final int[] offsets;
    private final DirectCharSequence[] csA;
    private final DirectCharSequence[] csB;
    private int fixedSize;
    private long address;
    private StorageFacade storageFacade;

    public RecordListRecord(RecordMetadata metadata, MemoryPages mem) {
        this.mem = mem;
        this.offsets = new int[metadata.getColumnCount()];
        DirectCharSequence[] csA = null;
        DirectCharSequence[] csB = null;
        int varColIndex = 0;
        for (int i = 0; i < this.offsets.length; ++i) {
            int ct = metadata.getColumnQuick(i).getType();
            int size = ColumnType.sizeOf(ct);
            if (size != 0) {
                this.offsets[i] = this.fixedSize;
                this.fixedSize += size;
                continue;
            }
            this.offsets[i] = -varColIndex++;
            if (csA == null) {
                csA = new DirectCharSequence[this.offsets.length];
                csB = new DirectCharSequence[this.offsets.length];
            }
            csA[i] = new DirectCharSequence();
            csB[i] = new DirectCharSequence();
        }
        this.csA = csA;
        this.csB = csB;
        this.fixedSize = this.fixedSize + 7 >> 3 << 3;
        this.headerSize = varColIndex * 8;
    }

    @Override
    public byte get(int col) {
        assert (this.offsets[col] >= 0);
        return Unsafe.getUnsafe().getByte(this.address + (long)Unsafe.arrayGet(this.offsets, col));
    }

    @Override
    public void getBin(int col, OutputStream s) {
        long readOffset = this.offsetOf(col);
        long readAddress = this.mem.addressOf(readOffset);
        try {
            long len = Unsafe.getUnsafe().getLong(readAddress);
            if (len > 0L) {
                this.streamBin(s, readAddress + 8L, len);
            }
        }
        catch (IOException ex) {
            throw new JournalRuntimeException("Reading binary column failed", (Throwable)ex, new Object[0]);
        }
    }

    @Override
    public DirectInputStream getBin(int col) {
        long offset = this.offsetOf(col);
        long len = Unsafe.getUnsafe().getLong(this.mem.addressOf(offset));
        if (len < 0L) {
            return null;
        }
        return new DirectPagedBufferStream(this.mem, offset + 8L, len);
    }

    @Override
    public long getBinLen(int col) {
        return Unsafe.getUnsafe().getLong(this.mem.addressOf(this.offsetOf(col)));
    }

    @Override
    public boolean getBool(int col) {
        assert (this.offsets[col] >= 0);
        return Unsafe.getBool(this.address + (long)Unsafe.arrayGet(this.offsets, col));
    }

    @Override
    public long getDate(int col) {
        assert (this.offsets[col] >= 0);
        return Unsafe.getUnsafe().getLong(this.address + (long)Unsafe.arrayGet(this.offsets, col));
    }

    @Override
    public double getDouble(int col) {
        assert (this.offsets[col] >= 0);
        return Unsafe.getUnsafe().getDouble(this.address + (long)Unsafe.arrayGet(this.offsets, col));
    }

    @Override
    public float getFloat(int col) {
        assert (this.offsets[col] >= 0);
        return Unsafe.getUnsafe().getFloat(this.address + (long)Unsafe.arrayGet(this.offsets, col));
    }

    @Override
    public CharSequence getFlyweightStr(int col) {
        assert (col < this.csA.length);
        long readAddress = this.addressOf(col);
        int len = Unsafe.getUnsafe().getInt(readAddress);
        if (len < 0) {
            return null;
        }
        return Unsafe.arrayGet(this.csA, col).of(readAddress + 4L, readAddress + 4L + (long)(len * 2));
    }

    @Override
    public CharSequence getFlyweightStrB(int col) {
        long readAddress = this.addressOf(col);
        int len = Unsafe.getUnsafe().getInt(readAddress);
        if (len < 0) {
            return null;
        }
        return Unsafe.arrayGet(this.csB, col).of(readAddress + 4L, readAddress + 4L + (long)(len * 2));
    }

    @Override
    public int getInt(int col) {
        assert (this.offsets[col] >= 0);
        return Unsafe.getUnsafe().getInt(this.address + (long)Unsafe.arrayGet(this.offsets, col));
    }

    @Override
    public long getLong(int col) {
        assert (this.offsets[col] >= 0);
        return Unsafe.getUnsafe().getLong(this.address + (long)Unsafe.arrayGet(this.offsets, col));
    }

    @Override
    public long getRowId() {
        return this.address - (long)this.headerSize;
    }

    @Override
    public short getShort(int col) {
        assert (this.offsets[col] >= 0);
        return Unsafe.getUnsafe().getShort(this.address + (long)Unsafe.arrayGet(this.offsets, col));
    }

    @Override
    public int getStrLen(int col) {
        return Unsafe.getUnsafe().getInt(this.addressOf(col));
    }

    @Override
    public CharSequence getSym(int col) {
        return this.storageFacade.getSymbolTable(col).value(this.getInt(col));
    }

    public int getFixedSize() {
        return this.fixedSize;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public void of(long address) {
        this.address = address + (long)this.headerSize;
    }

    public void setStorageFacade(StorageFacade storageFacade) {
        this.storageFacade = storageFacade;
    }

    private long addressOf(int index) {
        return this.offsetOf(index);
    }

    private long offsetOf(int index) {
        assert (this.offsets[index] <= 0);
        return Unsafe.getUnsafe().getLong(this.address - (long)this.headerSize + (long)(-Unsafe.arrayGet(this.offsets, index) * 8));
    }

    private void streamBin(OutputStream stream, long offset, long len) throws IOException {
        long position = offset;
        long copied = 0L;
        long l = len;
        while (copied < l) {
            long blockEndOffset = this.mem.pageRemaining(offset);
            long copyEndOffset = Math.min(blockEndOffset, l - copied);
            l += copyEndOffset - position;
            while (position < copyEndOffset) {
                stream.write(Unsafe.getUnsafe().getByte(this.mem.addressOf(offset) + position++));
            }
        }
    }

    private static class DirectPagedBufferStream
    extends DirectInputStream {
        private final long length;
        private final MemoryPages buffer;
        private final long offset;
        private long blockStartAddress;
        private long blockEndOffset;
        private long blockStartOffset;
        private long position;

        private DirectPagedBufferStream(MemoryPages buffer, long offset, long length) {
            this.buffer = buffer;
            this.offset = offset;
            this.blockStartAddress = buffer.addressOf(offset);
            this.blockStartOffset = 0L;
            this.length = length;
        }

        @Override
        public long copyTo(long address, long start, long len) {
            int sz;
            if (start < 0L || len < 0L) {
                throw new IndexOutOfBoundsException();
            }
            long rem = this.length - start;
            long res = len > rem ? rem : len;
            long size = res;
            long offset = this.offset + start;
            long p = address;
            do {
                int remaining;
                sz = size > (long)(remaining = this.buffer.pageRemaining(offset)) ? remaining : (int)size;
                Unsafe.getUnsafe().copyMemory(this.buffer.addressOf(offset), p, sz);
                p += (long)sz;
                offset += (long)sz;
            } while ((size -= (long)sz) > 0L);
            return res;
        }

        @Override
        public long size() {
            return (long)((int)this.length) - this.position;
        }

        @Override
        public int read() throws IOException {
            if (this.position < this.length) {
                if (this.position < this.blockEndOffset) {
                    return Unsafe.getUnsafe().getByte(this.blockStartAddress + this.offset + this.position++ - this.blockStartOffset);
                }
                return this.readFromNextBlock();
            }
            return -1;
        }

        private int readFromNextBlock() {
            this.blockStartOffset = this.offset + this.position;
            this.blockStartAddress = this.buffer.addressOf(this.blockStartOffset);
            long blockLen = this.buffer.pageRemaining(this.blockStartOffset);
            if (blockLen < 0L) {
                return -1;
            }
            this.blockEndOffset += blockLen;
            assert (this.position < this.blockEndOffset);
            return Unsafe.getUnsafe().getByte(this.blockStartAddress + this.offset + this.position++ - this.blockStartOffset);
        }
    }
}

