/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.ql.RecordSource;
import com.questdb.std.Numbers;
import com.questdb.std.str.CharSink;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.factory.ReaderFactory;
import java.io.IOException;

public class RecordSourcePrinter {
    private final CharSink sink;
    private final char delimiter;

    public RecordSourcePrinter(CharSink sink) {
        this.sink = sink;
        this.delimiter = (char)9;
    }

    public RecordSourcePrinter(CharSink sink, char delimiter) {
        this.sink = sink;
        this.delimiter = delimiter;
    }

    public void print(RecordSource src, ReaderFactory factory) throws IOException {
        this.print(src, factory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(RecordSource src, ReaderFactory factory, boolean header) throws IOException {
        RecordCursor cursor = src.prepareCursor(factory);
        try {
            this.print(cursor, header, src.getMetadata());
        }
        finally {
            cursor.releaseCursor();
        }
    }

    public void print(RecordCursor cursor, boolean header, RecordMetadata metadata) throws IOException {
        if (header) {
            this.printHeader(metadata);
        }
        while (cursor.hasNext()) {
            this.print((Record)cursor.next(), metadata);
        }
    }

    private void print(Record r, RecordMetadata m) throws IOException {
        int sz = m.getColumnCount();
        for (int i = 0; i < sz; ++i) {
            if (i > 0) {
                this.sink.put(this.delimiter);
            }
            this.printColumn(r, m, i);
        }
        this.sink.put("\n");
        this.sink.flush();
    }

    private void printColumn(Record r, RecordMetadata m, int i) {
        switch (m.getColumnQuick(i).getType()) {
            case 10: {
                DateFormatUtils.appendDateTime(this.sink, r.getDate(i));
                break;
            }
            case 12: {
                com.questdb.std.microtime.DateFormatUtils.appendDateTime(this.sink, r.getDate(i));
                break;
            }
            case 2: {
                Numbers.append(this.sink, r.getDouble(i), 12);
                break;
            }
            case 3: {
                Numbers.append(this.sink, r.getFloat(i), 4);
                break;
            }
            case 4: {
                Numbers.append(this.sink, r.getInt(i));
                break;
            }
            case 7: {
                r.getStr(i, this.sink);
                break;
            }
            case 8: {
                this.sink.put(r.getSym(i));
                break;
            }
            case 6: {
                Numbers.append(this.sink, r.getShort(i));
                break;
            }
            case 5: {
                Numbers.append(this.sink, r.getLong(i));
                break;
            }
            case 1: {
                Numbers.append(this.sink, r.get(i));
                break;
            }
            case 0: {
                this.sink.put(r.getBool(i) ? "true" : "false");
                break;
            }
        }
    }

    private void printHeader(RecordMetadata metadata) {
        int n = metadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.sink.put(this.delimiter);
            }
            this.sink.put(metadata.getColumnName(i));
        }
        this.sink.put('\n');
    }
}

