/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.common.AbstractRecordMetadata;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.common.RecordMetadata;
import com.questdb.std.Unsafe;

public class SplitRecordMetadata
extends AbstractRecordMetadata {
    private final int columnCount;
    private final RecordColumnMetadata[] columns;
    private final RecordMetadata a;
    private final RecordMetadata b;
    private final int split;

    public SplitRecordMetadata(RecordMetadata a, RecordMetadata b) {
        int i;
        this.a = a;
        this.b = b;
        int split = a.getColumnCount();
        this.columnCount = split + b.getColumnCount();
        this.columns = new RecordColumnMetadata[this.columnCount];
        for (i = 0; i < split; ++i) {
            RecordColumnMetadata m;
            this.columns[i] = m = a.getColumnQuick(i);
        }
        int c = this.columnCount - split;
        for (i = 0; i < c; ++i) {
            RecordColumnMetadata m;
            this.columns[i + split] = m = b.getColumnQuick(i);
        }
        this.split = split;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getColumnIndexQuiet(CharSequence name) {
        int index = this.a.getColumnIndexQuiet(name);
        if (index == -1) {
            index = this.b.getColumnIndexQuiet(name);
            if (index == -1) {
                return index;
            }
            return index + this.split;
        }
        return index;
    }

    @Override
    public RecordColumnMetadata getColumnQuick(int index) {
        return Unsafe.arrayGet(this.columns, index);
    }

    @Override
    public int getTimestampIndex() {
        return this.a.getTimestampIndex();
    }

    @Override
    public void setAlias(String alias) {
        super.setAlias(alias);
        this.a.setAlias(alias);
        this.b.setAlias(alias);
    }
}

