/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.RecordSource;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.Misc;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;

public class TopRecordSource
extends AbstractCombinedRecordSource {
    private final RecordSource delegate;
    private final VirtualColumn lo;
    private final VirtualColumn hi;
    private long _top;
    private long _count;
    private RecordCursor cursor;

    public TopRecordSource(RecordSource delegate, VirtualColumn lo, VirtualColumn hi) {
        this.delegate = delegate;
        this.lo = lo;
        this.hi = hi;
    }

    @Override
    public void close() {
        Misc.free(this.delegate);
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.delegate.getMetadata();
    }

    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        this._top = this.lo.getLong(null);
        this._count = this.hi.getLong(null) - this._top;
        this.cursor = this.delegate.prepareCursor(factory, cancellationHandler);
        return this;
    }

    @Override
    public Record getRecord() {
        return this.delegate.getRecord();
    }

    @Override
    public Record newRecord() {
        return this.delegate.newRecord();
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.cursor.getStorageFacade();
    }

    @Override
    public void releaseCursor() {
        this.cursor.releaseCursor();
    }

    @Override
    public void toTop() {
        this._top = this.lo.getLong(null);
        this._count = this.hi.getLong(null) - this._top;
        this.cursor.toTop();
    }

    @Override
    public boolean hasNext() {
        if (this._top > 0L) {
            return this.scrollToStart();
        }
        return this._count > 0L && this.cursor.hasNext();
    }

    @Override
    public Record next() {
        --this._count;
        return (Record)this.cursor.next();
    }

    @Override
    public Record recordAt(long rowId) {
        return this.cursor.recordAt(rowId);
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.cursor.recordAt(record, atRowId);
    }

    @Override
    public boolean supportsRowIdAccess() {
        return this.delegate.supportsRowIdAccess();
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("TopRecordSource").put(',');
        sink.putQuoted("low").put(':').put(this.lo.getLong(null)).put(',');
        sink.putQuoted("high").put(':').put(this.hi.getLong(null));
        sink.put('}');
    }

    private boolean scrollToStart() {
        if (this._count > 0L) {
            long top;
            for (top = this._top; top > 0L && this.cursor.hasNext(); --top) {
                this.cursor.next();
            }
            this._top = top;
            return this._top == 0L && this.cursor.hasNext();
        }
        return false;
    }
}

