/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.aggregation;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.AggregatorFunction;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.RecordSource;
import com.questdb.ql.aggregation.AggregationUtils;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapEntry;
import com.questdb.ql.map.DirectMapMetadata;
import com.questdb.ql.map.DirectMapRecord;
import com.questdb.ql.map.DirectMapStorageFacade;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.MapRecordValueInterceptor;
import com.questdb.ql.map.MetadataTypeResolver;
import com.questdb.ql.map.RecordKeyCopier;
import com.questdb.ql.map.RecordKeyCopierCompiler;
import com.questdb.ql.map.VirtualColumnTypeResolver;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.std.IntList;
import com.questdb.std.Misc;
import com.questdb.std.ObjHashSet;
import com.questdb.std.ObjList;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;
import java.io.Closeable;
import java.util.Iterator;

public class AggregatedRecordSource
extends AbstractCombinedRecordSource
implements Closeable {
    private static final VirtualColumnTypeResolver.ResolverThreadLocal tlVirtualColumnTypeResolver = new VirtualColumnTypeResolver.ResolverThreadLocal();
    private static final MetadataTypeResolver.MetadataTypeResolverThreadLocal tlMetadataTypeResolver = new MetadataTypeResolver.MetadataTypeResolverThreadLocal();
    private final DirectMap map;
    private final RecordSource recordSource;
    private final ObjList<AggregatorFunction> aggregators;
    private final RecordMetadata metadata;
    private final DirectMapStorageFacade storageFacade;
    private final DirectMapRecord record;
    private final ObjList<MapRecordValueInterceptor> interceptors;
    private final RecordKeyCopier copier;
    private ObjList<MapRecordValueInterceptor> interceptorWorkingSet;
    private RecordCursor cursor;
    private Iterator<DirectMapEntry> mapCursor;

    public AggregatedRecordSource(RecordSource recordSource, ObjHashSet<String> keyColumns, ObjList<AggregatorFunction> aggregators, int pageSize, RecordKeyCopierCompiler compiler) {
        int keyColumnsSize = keyColumns.size();
        IntList keyIndices = new IntList(keyColumnsSize);
        this.aggregators = aggregators;
        RecordMetadata rm = recordSource.getMetadata();
        for (int i = 0; i < keyColumnsSize; ++i) {
            keyIndices.add(rm.getColumnIndex(keyColumns.get(i)));
        }
        this.copier = compiler.compile(rm, keyIndices);
        ObjList<MapRecordValueInterceptor> interceptors = null;
        ObjList columns = (ObjList)AggregationUtils.TL_COLUMNS.get();
        columns.clear();
        int index = 0;
        int sz = aggregators.size();
        for (int i = 0; i < sz; ++i) {
            AggregatorFunction func = aggregators.getQuick(i);
            int n = columns.size();
            func.prepare(columns, index);
            index += columns.size() - n;
            if (!(func instanceof MapRecordValueInterceptor)) continue;
            if (interceptors == null) {
                interceptors = new ObjList<MapRecordValueInterceptor>();
            }
            interceptors.add((MapRecordValueInterceptor)((Object)func));
        }
        this.interceptors = interceptors;
        this.metadata = new DirectMapMetadata(rm, keyColumns, columns);
        this.storageFacade = new DirectMapStorageFacade(columns.size(), keyIndices);
        this.map = new DirectMap(pageSize, ((MetadataTypeResolver)tlMetadataTypeResolver.get()).of(rm, keyIndices), ((VirtualColumnTypeResolver)tlVirtualColumnTypeResolver.get()).of(columns));
        this.recordSource = recordSource;
        this.record = new DirectMapRecord(this.storageFacade);
    }

    @Override
    public void close() {
        Misc.free(this.map);
        Misc.free(this.recordSource);
        int n = this.aggregators.size();
        for (int i = 0; i < n; ++i) {
            Misc.free(this.aggregators.getQuick(i));
        }
        this.aggregators.clear();
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        this.interceptorWorkingSet = this.interceptors;
        this.map.clear();
        this.cursor = this.recordSource.prepareCursor(factory, cancellationHandler);
        this.storageFacade.prepare(this.cursor);
        this.buildMap(cancellationHandler);
        return this;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record newRecord() {
        return new DirectMapRecord(this.storageFacade);
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.storageFacade;
    }

    @Override
    public void releaseCursor() {
        this.map.clear();
        this.cursor.releaseCursor();
    }

    @Override
    public void toTop() {
        this.interceptorWorkingSet = null;
        this.mapCursor = this.map.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.mapCursor.hasNext();
    }

    @Override
    public Record next() {
        DirectMapEntry entry = this.mapCursor.next();
        if (this.interceptorWorkingSet != null) {
            this.notifyInterceptors(entry);
        }
        return this.record.of(entry);
    }

    @Override
    public Record recordAt(long rowId) {
        this.recordAt(this.record, rowId);
        return this.record;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        DirectMapEntry entry = this.map.entryAt(atRowId);
        if (this.interceptorWorkingSet != null) {
            this.notifyInterceptors(entry);
        }
        ((DirectMapRecord)record).of(entry);
    }

    @Override
    public boolean supportsRowIdAccess() {
        return true;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("AggregatedRecordSource").put(',');
        sink.putQuoted("src").put(':').put(this.recordSource);
        sink.put('}');
    }

    private void buildMap(CancellationHandler cancellationHandler) {
        int sz = this.aggregators.size();
        while (this.cursor.hasNext()) {
            cancellationHandler.check();
            Record r = (Record)this.cursor.next();
            this.map.locate(this.copier, r);
            DirectMapValues values = this.map.getOrCreateValues();
            for (int i = 0; i < sz; ++i) {
                this.aggregators.getQuick(i).calculate(r, values);
            }
        }
        this.mapCursor = this.map.iterator();
    }

    private void notifyInterceptors(DirectMapEntry entry) {
        int n = this.interceptorWorkingSet.size();
        for (int i = 0; i < n; ++i) {
            this.interceptors.getQuick(i).beforeRecord(entry.values());
        }
    }
}

