/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.aggregation;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.CollectionRecordMetadata;
import com.questdb.ql.PartitionCursor;
import com.questdb.ql.PartitionSlice;
import com.questdb.ql.PartitionSource;
import com.questdb.ql.RecordColumnMetadataImpl;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;

public class CountRecordSource
extends AbstractCombinedRecordSource {
    private final CountRecord record;
    private final PartitionSource partitionSource;
    private final CollectionRecordMetadata metadata = new CollectionRecordMetadata();
    private boolean done = false;

    public CountRecordSource(String columnName, PartitionSource partitionSource) {
        this.metadata.add(new RecordColumnMetadataImpl(columnName, 5));
        this.record = new CountRecord();
        this.partitionSource = partitionSource;
    }

    @Override
    public void close() {
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        this.done = false;
        PartitionCursor partitionCursor = this.partitionSource.prepareCursor(factory);
        try {
            this.computeCount(partitionCursor);
        }
        finally {
            partitionCursor.releaseCursor();
        }
        return this;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record newRecord() {
        return new CountRecord();
    }

    @Override
    public StorageFacade getStorageFacade() {
        return null;
    }

    @Override
    public void releaseCursor() {
    }

    @Override
    public void toTop() {
        this.done = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasNext() {
        if (this.done) return false;
        this.done = true;
        if (!true) return false;
        return true;
    }

    @Override
    public Record next() {
        return this.record;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("CountRecordSource").put(',');
        sink.putQuoted("psrc").put(':').put(this.partitionSource);
        sink.put('}');
    }

    private void computeCount(PartitionCursor cursor) {
        long count = 0L;
        while (cursor.hasNext()) {
            PartitionSlice slice = (PartitionSlice)cursor.next();
            long hi = slice.calcHi ? slice.partition.size() : slice.hi;
            count += hi - slice.lo;
        }
        this.record.count = count;
    }

    private static class CountRecord
    implements Record {
        private long count;

        private CountRecord() {
        }

        @Override
        public long getLong(int col) {
            return this.count;
        }
    }
}

