/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.aggregation;

import com.questdb.ql.aggregation.TimestampSampler;
import com.questdb.std.str.CharSink;
import com.questdb.std.time.Dates;

class MonthsSampler
implements TimestampSampler {
    private final int bucket;

    MonthsSampler(int bucket) {
        this.bucket = bucket;
    }

    @Override
    public long resample(long value) {
        int y = Dates.getYear(value);
        boolean l = Dates.isLeapYear(y);
        int m = Dates.getMonthOfYear(value, y, l);
        int n = (m - 1) / this.bucket * this.bucket + 1;
        return Dates.yearMillis(y, l) + Dates.monthOfYearMillis(n, l);
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("MonthsSampler").put(',');
        sink.putQuoted("buckets").put(':').put(this.bucket);
        sink.put('}');
    }
}

