/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.aggregation;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.AggregatorFunction;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.RecordSource;
import com.questdb.ql.aggregation.AggregationUtils;
import com.questdb.ql.aggregation.TimestampSampler;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapEntry;
import com.questdb.ql.map.DirectMapIterator;
import com.questdb.ql.map.DirectMapMetadata;
import com.questdb.ql.map.DirectMapRecord;
import com.questdb.ql.map.DirectMapStorageFacade;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.MapRecordValueInterceptor;
import com.questdb.ql.map.MetadataNameTypeResolver;
import com.questdb.ql.map.RecordKeyCopier;
import com.questdb.ql.map.RecordKeyCopierCompiler;
import com.questdb.ql.map.VirtualColumnTypeResolver;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.std.IntList;
import com.questdb.std.Misc;
import com.questdb.std.ObjHashSet;
import com.questdb.std.ObjList;
import com.questdb.std.ThreadLocal;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;

public class ResampledRecordSource
extends AbstractCombinedRecordSource {
    private static final ThreadLocal<VirtualColumnTypeResolver> tlAggregationTypeResolver = new VirtualColumnTypeResolver.ResolverThreadLocal();
    private static final MetadataNameTypeResolver.MetadataNameTypeResolverThreadLocal tlMetadataTypeResolver = new MetadataNameTypeResolver.MetadataNameTypeResolverThreadLocal();
    private final DirectMap map;
    private final RecordSource recordSource;
    private final int tsIndex;
    private final ObjList<AggregatorFunction> aggregators;
    private final TimestampSampler sampler;
    private final DirectMapMetadata metadata;
    private final DirectMapRecord record;
    private final DirectMapStorageFacade storageFacade;
    private final ObjList<MapRecordValueInterceptor> interceptors;
    private final RecordKeyCopier copier;
    private RecordCursor recordCursor;
    private DirectMapIterator mapCursor;
    private Record nextRecord = null;

    public ResampledRecordSource(RecordSource recordSource, int timestampColumnIndex, ObjHashSet<String> keyColumns, ObjList<AggregatorFunction> aggregators, TimestampSampler sampler, int pageSize, RecordKeyCopierCompiler compiler) {
        int keyColumnsSize = keyColumns.size();
        IntList keyIndices = new IntList(keyColumnsSize);
        ObjHashSet<String> keyCols = new ObjHashSet<String>();
        RecordMetadata rm = recordSource.getMetadata();
        this.tsIndex = timestampColumnIndex;
        keyCols.add(rm.getColumnName(this.tsIndex));
        for (int i = 0; i < keyColumnsSize; ++i) {
            keyCols.add(keyColumns.get(i));
            int index = rm.getColumnIndex(keyColumns.get(i));
            if (index == this.tsIndex) continue;
            keyIndices.add(index);
        }
        this.aggregators = aggregators;
        this.sampler = sampler;
        this.copier = compiler.compile(rm, keyIndices);
        ObjList<MapRecordValueInterceptor> interceptors = null;
        ObjList columns = (ObjList)AggregationUtils.TL_COLUMNS.get();
        columns.clear();
        int index = 0;
        int sz = aggregators.size();
        for (int i = 0; i < sz; ++i) {
            AggregatorFunction func = aggregators.getQuick(i);
            int n = columns.size();
            func.prepare(columns, index);
            index += columns.size() - n;
            if (!(func instanceof MapRecordValueInterceptor)) continue;
            if (interceptors == null) {
                interceptors = new ObjList<MapRecordValueInterceptor>();
            }
            interceptors.add((MapRecordValueInterceptor)((Object)func));
        }
        this.interceptors = interceptors;
        this.storageFacade = new DirectMapStorageFacade(columns.size() + 1, keyIndices);
        this.metadata = new DirectMapMetadata(rm, keyCols, columns);
        this.record = new DirectMapRecord(this.storageFacade);
        this.map = new DirectMap(pageSize, ((MetadataNameTypeResolver)tlMetadataTypeResolver.get()).of(rm, keyCols), ((VirtualColumnTypeResolver)tlAggregationTypeResolver.get()).of(columns));
        this.recordSource = recordSource;
    }

    @Override
    public void close() {
        Misc.free(this.map);
        Misc.free(this.recordSource);
        int n = this.aggregators.size();
        for (int i = 0; i < n; ++i) {
            Misc.free(this.aggregators.getQuick(i));
        }
        this.aggregators.clear();
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        this.map.clear();
        this.nextRecord = null;
        this.mapCursor = null;
        this.recordCursor = this.recordSource.prepareCursor(factory, cancellationHandler);
        this.storageFacade.prepare(this.recordCursor);
        return this;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record newRecord() {
        return new DirectMapRecord(this.storageFacade);
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.storageFacade;
    }

    @Override
    public void releaseCursor() {
        this.recordCursor.releaseCursor();
    }

    @Override
    public void toTop() {
        this.nextRecord = null;
        this.mapCursor = null;
        this.recordCursor.toTop();
    }

    @Override
    public boolean hasNext() {
        return this.mapCursor != null && this.mapCursor.hasNext() || this.buildMap();
    }

    @Override
    public Record next() {
        DirectMapEntry entry = this.mapCursor.next();
        if (this.interceptors != null) {
            int n = this.interceptors.size();
            for (int i = 0; i < n; ++i) {
                this.interceptors.getQuick(i).beforeRecord(entry.values());
            }
        }
        return this.record.of(entry);
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("ResampledRecordSource").put(',');
        sink.putQuoted("src").put(':').put(this.recordSource).put(',');
        sink.putQuoted("sampler").put(':').put(this.sampler);
        sink.put('}');
    }

    private boolean buildMap() {
        Record rec;
        long current = 0L;
        boolean first = true;
        int sz = this.aggregators.size();
        this.map.clear();
        for (int i = 0; i < sz; ++i) {
            this.aggregators.getQuick(i).clear();
        }
        while ((rec = this.fetchNext()) != null) {
            long sample = this.sampler.resample(rec.getLong(this.tsIndex));
            if (first) {
                current = sample;
                first = false;
            } else if (sample != current) {
                this.nextRecord = rec;
                break;
            }
            DirectMap.KeyWriter kw = this.map.keyWriter();
            kw.putLong(sample);
            this.copier.copy(rec, kw);
            DirectMapValues values = this.map.getOrCreateValues();
            for (int i = 0; i < sz; ++i) {
                this.aggregators.getQuick(i).calculate(rec, values);
            }
        }
        this.mapCursor = this.map.iterator();
        return this.mapCursor.hasNext();
    }

    private Record fetchNext() {
        if (this.nextRecord != null) {
            Record r = this.nextRecord;
            this.nextRecord = null;
            return r;
        }
        if (!this.recordCursor.hasNext()) {
            return null;
        }
        return (Record)this.recordCursor.next();
    }
}

