/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.aggregation;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.NumericException;
import com.questdb.ql.aggregation.MillisSampler;
import com.questdb.ql.aggregation.MonthsSampler;
import com.questdb.ql.aggregation.TimestampSampler;
import com.questdb.ql.aggregation.YearSampler;
import com.questdb.std.Numbers;

public final class SamplerFactory {
    public static TimestampSampler from(CharSequence cs) {
        int k = -1;
        for (int i = 0; i < cs.length(); ++i) {
            char c = cs.charAt(i);
            if (c >= '0' && c <= '9') continue;
            k = i;
            break;
        }
        if (k == -1) {
            return null;
        }
        if (k + 1 < cs.length()) {
            return null;
        }
        if (k == 0) {
            if (cs.charAt(k) == 'Y') {
                return YearSampler.INSTANCE;
            }
            return null;
        }
        try {
            int n = Numbers.parseInt(cs, 0, k);
            switch (cs.charAt(k)) {
                case 's': {
                    return new MillisSampler(1000L * (long)n);
                }
                case 'm': {
                    return new MillisSampler(60000L * (long)n);
                }
                case 'h': {
                    return new MillisSampler(3600000L * (long)n);
                }
                case 'd': {
                    return new MillisSampler(86400000L * (long)n);
                }
                case 'M': {
                    return new MonthsSampler(n);
                }
            }
            return null;
        }
        catch (NumericException e) {
            throw new JournalRuntimeException("Internal error", new Object[0]);
        }
    }
}

