/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.aggregation;

import com.questdb.ql.aggregation.TimestampSampler;
import com.questdb.std.str.CharSink;
import com.questdb.std.time.Dates;

class YearSampler
implements TimestampSampler {
    public static final YearSampler INSTANCE = new YearSampler();

    private YearSampler() {
    }

    @Override
    public long resample(long value) {
        int y = Dates.getYear(value);
        return Dates.yearMillis(y, Dates.isLeapYear(y));
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("YearSampler");
        sink.put('}');
    }
}

