/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic;

import com.questdb.common.Record;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.common.RecordCursor;
import com.questdb.common.SymbolTable;
import com.questdb.ql.NullRecord;
import com.questdb.ql.analytic.AnalyticFunction;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.LongResolver;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.Misc;
import com.questdb.std.str.CharSink;
import java.io.Closeable;
import java.io.IOException;

public abstract class AbstractOrderedAnalyticFunction
implements AnalyticFunction,
Closeable {
    protected final DirectMap map;
    private final VirtualColumn valueColumn;
    protected boolean closed = false;
    private Record out;
    private Record record;
    private RecordCursor cursor;

    public AbstractOrderedAnalyticFunction(int pageSize, VirtualColumn valueColumn) {
        this.map = new DirectMap(pageSize, LongResolver.INSTANCE, LongResolver.INSTANCE);
        this.valueColumn = valueColumn;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        Misc.free(this.map);
        this.closed = true;
    }

    @Override
    public byte get() {
        return this.valueColumn.get(this.out);
    }

    @Override
    public boolean getBool() {
        return this.valueColumn.getBool(this.out);
    }

    @Override
    public long getDate() {
        return this.valueColumn.getDate(this.out);
    }

    @Override
    public double getDouble() {
        return this.valueColumn.getDouble(this.out);
    }

    @Override
    public float getFloat() {
        return this.valueColumn.getFloat(this.out);
    }

    @Override
    public CharSequence getFlyweightStr() {
        return this.valueColumn.getFlyweightStr(this.out);
    }

    @Override
    public CharSequence getFlyweightStrB() {
        return this.valueColumn.getFlyweightStrB(this.out);
    }

    @Override
    public int getInt() {
        return this.valueColumn.getInt(this.out);
    }

    @Override
    public long getLong() {
        return this.valueColumn.getLong(this.out);
    }

    @Override
    public RecordColumnMetadata getMetadata() {
        return this.valueColumn;
    }

    @Override
    public short getShort() {
        return this.valueColumn.getShort(this.out);
    }

    @Override
    public void getStr(CharSink sink) {
        this.valueColumn.getStr(this.out, sink);
    }

    @Override
    public int getStrLen() {
        return this.valueColumn.getStrLen(this.out);
    }

    @Override
    public CharSequence getSym() {
        return this.valueColumn.getSym(this.out);
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.valueColumn.getSymbolTable();
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void prepare(RecordCursor cursor) {
        this.record = cursor.newRecord();
        this.cursor = cursor;
        this.valueColumn.prepare(cursor.getStorageFacade());
    }

    @Override
    public void prepareFor(Record record) {
        long row;
        this.map.locate(record.getRowId());
        DirectMapValues values = this.map.getValues();
        if (values == null || (row = values.getLong(0)) == -1L) {
            this.out = NullRecord.INSTANCE;
        } else {
            this.cursor.recordAt(this.record, row);
            this.out = this.record;
        }
    }

    @Override
    public void reset() {
        this.map.clear();
    }
}

