/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic;

import com.questdb.ServerConfiguration;
import com.questdb.ql.analytic.AnalyticFunction;
import com.questdb.ql.analytic.AnalyticFunctionFactory;
import com.questdb.ql.analytic.denserank.DenseRankAnalyticFunctionFactory;
import com.questdb.ql.analytic.next.NextAnalyticFunctionFactory;
import com.questdb.ql.analytic.prev.PrevAnalyticFunctionFactory;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.CharSequenceObjHashMap;
import com.questdb.std.ObjList;

public class AnalyticFunctionFactories {
    private static final CharSequenceObjHashMap<AnalyticFunctionFactory> factories = new CharSequenceObjHashMap();

    public static AnalyticFunction newInstance(ServerConfiguration configuration, String name, VirtualColumn valueColumn, String valueColumnAlias, ObjList<VirtualColumn> partitionBy, boolean supportsRowId, boolean orderedAnalytic) {
        AnalyticFunctionFactory factory = factories.get(name);
        if (factory != null) {
            return factory.newInstance(configuration, valueColumn, valueColumnAlias, partitionBy, supportsRowId, orderedAnalytic);
        }
        return null;
    }

    static {
        factories.put("next", new NextAnalyticFunctionFactory());
        factories.put("prev", new PrevAnalyticFunctionFactory());
        factories.put("dense_rank", new DenseRankAnalyticFunctionFactory());
    }
}

