/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.CollectionRecordMetadata;
import com.questdb.ql.RecordSource;
import com.questdb.ql.SplitRecordMetadata;
import com.questdb.ql.analytic.AnalyticFunction;
import com.questdb.ql.analytic.AnalyticRecord;
import com.questdb.ql.analytic.AnalyticRecordStorageFacade;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;

public class AnalyticRecordSource
extends AbstractCombinedRecordSource {
    private final RecordSource delegate;
    private final ObjList<AnalyticFunction> functions;
    private final RecordMetadata metadata;
    private final AnalyticRecord record;
    private final AnalyticRecordStorageFacade storageFacade;
    private final int split;
    private RecordCursor cursor;

    public AnalyticRecordSource(RecordSource delegate, ObjList<AnalyticFunction> functionGroups) {
        this.delegate = delegate;
        CollectionRecordMetadata funcMetadata = new CollectionRecordMetadata();
        this.functions = functionGroups;
        for (int j = 0; j < functionGroups.size(); ++j) {
            funcMetadata.add(functionGroups.getQuick(j).getMetadata());
        }
        this.metadata = new SplitRecordMetadata(delegate.getMetadata(), funcMetadata);
        this.split = delegate.getMetadata().getColumnCount();
        this.record = new AnalyticRecord(this.split, this.functions);
        this.storageFacade = new AnalyticRecordStorageFacade(this.split, this.functions);
    }

    @Override
    public void close() {
        Misc.free(this.delegate);
        int n = this.functions.size();
        for (int i = 0; i < n; ++i) {
            Misc.free(this.functions.getQuick(i));
        }
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        this.cursor = this.delegate.prepareCursor(factory, cancellationHandler);
        this.storageFacade.prepare(this.cursor.getStorageFacade());
        this.prepareFunctions();
        return this;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record newRecord() {
        return new AnalyticRecord(this.split, this.functions);
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.storageFacade;
    }

    @Override
    public void releaseCursor() {
        this.cursor.releaseCursor();
    }

    @Override
    public void toTop() {
        this.cursor.toTop();
        int n = this.functions.size();
        for (int i = 0; i < n; ++i) {
            this.functions.getQuick(i).toTop();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.cursor.hasNext()) {
            this.record.of((Record)this.cursor.next());
            int n = this.functions.size();
            for (int i = 0; i < n; ++i) {
                this.functions.getQuick(i).prepareFor(this.record);
            }
            return true;
        }
        return false;
    }

    @Override
    public Record next() {
        return this.record;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("AnalyticRecordSource").put(',');
        sink.putQuoted("functions").put(':').put(this.functions.size()).put(',');
        sink.putQuoted("src").put(':').put(this.delegate);
        sink.put('}');
    }

    private void prepareFunctions() {
        int n = this.functions.size();
        for (int i = 0; i < n; ++i) {
            AnalyticFunction f = this.functions.getQuick(i);
            f.reset();
            f.prepare(this.cursor);
        }
    }
}

