/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.CollectionRecordMetadata;
import com.questdb.ql.RecordList;
import com.questdb.ql.RecordSource;
import com.questdb.ql.SplitRecordMetadata;
import com.questdb.ql.analytic.AnalyticFunction;
import com.questdb.ql.analytic.AnalyticRecord;
import com.questdb.ql.analytic.AnalyticRecordStorageFacade;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.ql.sort.RecordComparator;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.std.RedBlackTree;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;

public class CachedAnalyticRecordSource
extends AbstractCombinedRecordSource {
    private final RecordList recordList;
    private final RecordSource recordSource;
    private final ObjList<RedBlackTree> orderedSources;
    private final int orderGroupCount;
    private final ObjList<ObjList<AnalyticFunction>> functionGroups;
    private final ObjList<AnalyticFunction> functions;
    private final RecordMetadata metadata;
    private final AnalyticRecord record;
    private final AnalyticRecordStorageFacade storageFacade;
    private final int split;
    private RecordCursor cursor;
    private boolean closed = false;

    public CachedAnalyticRecordSource(int rowidPageSize, int keyPageSize, RecordSource delegate, ObjList<RecordComparator> comparators, ObjList<ObjList<AnalyticFunction>> functionGroups) {
        this.recordSource = delegate;
        this.orderGroupCount = comparators.size();
        assert (this.orderGroupCount == functionGroups.size());
        this.orderedSources = new ObjList(this.orderGroupCount);
        this.functionGroups = functionGroups;
        RecordList list = new RecordList(delegate.getMetadata(), rowidPageSize);
        for (int i = 0; i < this.orderGroupCount; ++i) {
            RecordComparator cmp = comparators.getQuick(i);
            this.orderedSources.add(cmp == null ? null : new RedBlackTree(new MyComparator(cmp, list), keyPageSize));
        }
        this.recordList = list;
        CollectionRecordMetadata funcMetadata = new CollectionRecordMetadata();
        this.functions = new ObjList(this.orderGroupCount);
        for (int i = 0; i < this.orderGroupCount; ++i) {
            ObjList<AnalyticFunction> l = functionGroups.getQuick(i);
            for (int j = 0; j < l.size(); ++j) {
                AnalyticFunction f = l.getQuick(j);
                funcMetadata.add(f.getMetadata());
                this.functions.add(f);
            }
        }
        this.metadata = new SplitRecordMetadata(delegate.getMetadata(), funcMetadata);
        this.split = delegate.getMetadata().getColumnCount();
        this.record = new AnalyticRecord(this.split, this.functions);
        this.storageFacade = new AnalyticRecordStorageFacade(this.split, this.functions);
        this.recordList.setStorageFacade(this.storageFacade);
    }

    @Override
    public void close() {
        int i;
        if (this.closed) {
            return;
        }
        Misc.free(this.recordSource);
        Misc.free(this.recordList);
        for (i = 0; i < this.orderGroupCount; ++i) {
            Misc.free(this.orderedSources.getQuick(i));
        }
        int n = this.functions.size();
        for (i = 0; i < n; ++i) {
            Misc.free(this.functions.getQuick(i));
        }
        this.closed = true;
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        int i;
        this.recordList.clear();
        for (i = 0; i < this.orderGroupCount; ++i) {
            RedBlackTree tree = this.orderedSources.getQuick(i);
            if (tree == null) continue;
            tree.clear();
        }
        int n = this.functions.size();
        for (i = 0; i < n; ++i) {
            this.functions.getQuick(i).reset();
        }
        RecordCursor cursor = this.recordSource.prepareCursor(factory, cancellationHandler);
        try {
            this.storageFacade.prepare(cursor.getStorageFacade());
            long rowid = -1L;
            while (cursor.hasNext()) {
                cancellationHandler.check();
                Record record = (Record)cursor.next();
                rowid = this.recordList.append(record, rowid);
                if (this.orderGroupCount <= 0) continue;
                for (int i2 = 0; i2 < this.orderGroupCount; ++i2) {
                    RedBlackTree tree = this.orderedSources.getQuick(i2);
                    if (tree == null) continue;
                    tree.add(rowid);
                }
            }
            for (int i3 = 0; i3 < this.orderGroupCount; ++i3) {
                RedBlackTree tree = this.orderedSources.getQuick(i3);
                ObjList<AnalyticFunction> functions = this.functionGroups.getQuick(i3);
                if (tree != null) {
                    RedBlackTree.LongIterator iterator = tree.iterator();
                    while (iterator.hasNext()) {
                        cancellationHandler.check();
                        Record record = this.recordList.recordAt(iterator.next());
                        int n2 = functions.size();
                        for (int j = 0; j < n2; ++j) {
                            functions.getQuick(j).add(record);
                        }
                    }
                    continue;
                }
                int n3 = functions.size();
                for (int j = 0; j < n3; ++j) {
                    AnalyticFunction f = functions.getQuick(j);
                    if (f.getType() == 1) continue;
                    this.recordList.toTop();
                    while (this.recordList.hasNext()) {
                        f.add(this.recordList.next());
                    }
                }
            }
        }
        finally {
            cursor.releaseCursor();
        }
        this.recordList.toTop();
        this.setCursorAndPrepareFunctions();
        return this;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record newRecord() {
        return new AnalyticRecord(this.split, this.functions);
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.storageFacade;
    }

    @Override
    public void releaseCursor() {
        this.cursor.releaseCursor();
    }

    @Override
    public void toTop() {
        this.cursor.toTop();
        int n = this.functions.size();
        for (int i = 0; i < n; ++i) {
            this.functions.getQuick(i).toTop();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.cursor.hasNext()) {
            this.record.of((Record)this.cursor.next());
            int n = this.functions.size();
            for (int i = 0; i < n; ++i) {
                this.functions.getQuick(i).prepareFor(this.record);
            }
            return true;
        }
        return false;
    }

    @Override
    public Record next() {
        return this.record;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("CachedAnalyticRecordSource").put(',');
        sink.putQuoted("functions").put(':').put(this.functions.size()).put(',');
        sink.putQuoted("orderedSources").put(':').put(this.orderedSources.size()).put(',');
        sink.putQuoted("src").put(':').put(this.recordSource);
        sink.put('}');
    }

    private void setCursorAndPrepareFunctions() {
        int n = this.functions.size();
        for (int i = 0; i < n; ++i) {
            this.functions.getQuick(i).prepare(this.recordList);
        }
        this.cursor = this.recordList;
    }

    private static class MyComparator
    implements RedBlackTree.LongComparator {
        private final RecordComparator delegate;
        private final RecordCursor cursor;
        private final Record left;
        private final Record right;

        public MyComparator(RecordComparator delegate, RecordCursor cursor) {
            this.delegate = delegate;
            this.cursor = cursor;
            this.left = cursor.newRecord();
            this.right = cursor.newRecord();
        }

        @Override
        public int compare(long right) {
            this.cursor.recordAt(this.right, right);
            return this.delegate.compare(this.right);
        }

        @Override
        public void setLeft(long left) {
            this.cursor.recordAt(this.left, left);
            this.delegate.setLeft(this.left);
        }
    }
}

