/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.CollectionRecordMetadata;
import com.questdb.ql.RecordList;
import com.questdb.ql.RecordSource;
import com.questdb.ql.SplitRecordMetadata;
import com.questdb.ql.analytic.AnalyticFunction;
import com.questdb.ql.analytic.AnalyticRecord;
import com.questdb.ql.analytic.AnalyticRecordStorageFacade;
import com.questdb.ql.join.hash.FakeRecord;
import com.questdb.ql.map.MapUtils;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.ql.sort.RecordComparator;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.std.RedBlackTree;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;

public class CachedRowAnalyticRecordSource
extends AbstractCombinedRecordSource {
    private final RecordList recordList;
    private final RecordSource delegate;
    private final ObjList<RedBlackTree> orderedSources;
    private final int orderGroupCount;
    private final ObjList<ObjList<AnalyticFunction>> functionGroups;
    private final ObjList<AnalyticFunction> functions;
    private final RecordMetadata metadata;
    private final AnalyticRecord record;
    private final AnalyticRecordStorageFacade storageFacade;
    private final int split;
    private final FakeRecord fakeRecord = new FakeRecord();
    private RecordCursor parentCursor;

    public CachedRowAnalyticRecordSource(int pageSize, RecordSource delegate, ObjList<RecordComparator> comparators, ObjList<ObjList<AnalyticFunction>> functionGroups) {
        int i;
        this.delegate = delegate;
        this.orderGroupCount = comparators.size();
        assert (this.orderGroupCount == functionGroups.size());
        this.orderedSources = new ObjList(this.orderGroupCount);
        this.functionGroups = functionGroups;
        this.recordList = new RecordList(MapUtils.ROWID_RECORD_METADATA, pageSize);
        CollectionRecordMetadata funcMetadata = new CollectionRecordMetadata();
        this.functions = new ObjList(this.orderGroupCount);
        for (i = 0; i < this.orderGroupCount; ++i) {
            ObjList<AnalyticFunction> l = functionGroups.getQuick(i);
            for (int j = 0; j < l.size(); ++j) {
                AnalyticFunction f = l.getQuick(j);
                funcMetadata.add(f.getMetadata());
                this.functions.add(f);
            }
        }
        this.metadata = new SplitRecordMetadata(delegate.getMetadata(), funcMetadata);
        this.split = delegate.getMetadata().getColumnCount();
        this.record = new AnalyticRecord(this.split, this.functions);
        this.storageFacade = new AnalyticRecordStorageFacade(this.split, this.functions);
        this.recordList.setStorageFacade(this.storageFacade);
        for (i = 0; i < this.orderGroupCount; ++i) {
            RecordComparator cmp = comparators.getQuick(i);
            if (cmp != null) {
                this.orderedSources.add(new RedBlackTree(new MyComparator(cmp), pageSize));
                continue;
            }
            this.orderedSources.add(null);
        }
    }

    @Override
    public void close() {
        int i;
        Misc.free(this.delegate);
        Misc.free(this.recordList);
        for (i = 0; i < this.orderGroupCount; ++i) {
            Misc.free(this.orderedSources.getQuick(i));
        }
        this.orderedSources.clear();
        int n = this.functions.size();
        for (i = 0; i < n; ++i) {
            Misc.free(this.functions.getQuick(i));
        }
        this.functions.clear();
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        int i;
        RecordCursor cursor;
        int i2;
        this.recordList.clear();
        for (i2 = 0; i2 < this.orderGroupCount; ++i2) {
            RedBlackTree tree = this.orderedSources.getQuick(i2);
            if (tree == null) continue;
            tree.clear();
        }
        int n = this.functions.size();
        for (i2 = 0; i2 < n; ++i2) {
            this.functions.getQuick(i2).reset();
        }
        this.parentCursor = cursor = this.delegate.prepareCursor(factory, cancellationHandler);
        this.storageFacade.prepare(cursor.getStorageFacade());
        for (int i3 = 0; i3 < this.orderGroupCount; ++i3) {
            RedBlackTree tree = this.orderedSources.getQuick(i3);
            if (tree == null) continue;
            ((MyComparator)tree.getComparator()).setCursor(cursor);
        }
        long rowid = -1L;
        while (cursor.hasNext()) {
            cancellationHandler.check();
            Record record = (Record)cursor.next();
            long row = record.getRowId();
            rowid = this.recordList.append(this.fakeRecord.of(row), rowid);
            if (this.orderGroupCount <= 0) continue;
            for (int i4 = 0; i4 < this.orderGroupCount; ++i4) {
                RedBlackTree tree = this.orderedSources.getQuick(i4);
                if (tree == null) continue;
                tree.add(row);
            }
        }
        for (i = 0; i < this.orderGroupCount; ++i) {
            RedBlackTree tree = this.orderedSources.getQuick(i);
            ObjList<AnalyticFunction> functions = this.functionGroups.getQuick(i);
            if (tree != null) {
                RedBlackTree.LongIterator iterator = tree.iterator();
                while (iterator.hasNext()) {
                    cancellationHandler.check();
                    Record record = cursor.recordAt(iterator.next());
                    int n2 = functions.size();
                    for (int j = 0; j < n2; ++j) {
                        functions.getQuick(j).add(record);
                    }
                }
                continue;
            }
            int n3 = functions.size();
            for (int j = 0; j < n3; ++j) {
                AnalyticFunction f = functions.getQuick(j);
                if (f.getType() == 1) continue;
                this.recordList.toTop();
                while (this.recordList.hasNext()) {
                    f.add(cursor.recordAt(this.recordList.next().getLong(0)));
                }
            }
        }
        this.recordList.toTop();
        int n4 = this.functions.size();
        for (i = 0; i < n4; ++i) {
            this.functions.getQuick(i).prepare(cursor);
        }
        return this;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record newRecord() {
        return new AnalyticRecord(this.split, this.functions);
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.storageFacade;
    }

    @Override
    public void releaseCursor() {
        this.parentCursor.releaseCursor();
        this.recordList.releaseCursor();
    }

    @Override
    public void toTop() {
        this.recordList.toTop();
        int n = this.functions.size();
        for (int i = 0; i < n; ++i) {
            this.functions.getQuick(i).toTop();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.recordList.hasNext()) {
            long row = this.recordList.next().getLong(0);
            this.record.of(this.parentCursor.recordAt(row));
            int n = this.functions.size();
            for (int i = 0; i < n; ++i) {
                this.functions.getQuick(i).prepareFor(this.record);
            }
            return true;
        }
        return false;
    }

    @Override
    public Record next() {
        return this.record;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("CachedRowAnalyticRecordSource").put(',');
        sink.putQuoted("functions").put(':').put(this.functions.size()).put(',');
        sink.putQuoted("orderedSources").put(':').put(this.orderedSources.size()).put(',');
        sink.putQuoted("src").put(':').put(this.delegate);
        sink.put('}');
    }

    private static class MyComparator
    implements RedBlackTree.LongComparator {
        private final RecordComparator delegate;
        private RecordCursor cursor;
        private Record left;
        private Record right;

        public MyComparator(RecordComparator delegate) {
            this.delegate = delegate;
        }

        @Override
        public int compare(long right) {
            assert (right > -1L);
            this.cursor.recordAt(this.right, right);
            assert (this.right != null);
            return this.delegate.compare(this.right);
        }

        @Override
        public void setLeft(long left) {
            assert (left > -1L);
            this.cursor.recordAt(this.left, left);
            assert (this.left != null);
            this.delegate.setLeft(this.left);
        }

        public void setCursor(RecordCursor cursor) {
            this.cursor = cursor;
            if (this.left == null || this.right == null) {
                this.left = cursor.newRecord();
                this.right = cursor.newRecord();
            }
        }
    }
}

