/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic.denserank;

import com.questdb.common.Record;
import com.questdb.ql.analytic.denserank.AbstractRankAnalyticFunction;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.LongResolver;
import com.questdb.std.Misc;
import java.io.Closeable;
import java.io.IOException;

public abstract class AbstractRankOrderedAnalyticFunction
extends AbstractRankAnalyticFunction
implements Closeable {
    protected final DirectMap map;
    protected boolean closed = false;

    public AbstractRankOrderedAnalyticFunction(int pageSize, String name) {
        super(name);
        this.map = new DirectMap(pageSize, LongResolver.INSTANCE, LongResolver.INSTANCE);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        Misc.free(this.map);
        this.closed = true;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void prepareFor(Record record) {
        this.map.locate(record.getRowId());
        this.rank = this.map.getValues().getLong(0);
    }

    @Override
    public void reset() {
        this.map.clear();
        this.rank = -1L;
    }

    @Override
    public void toTop() {
        this.rank = -1L;
    }
}

