/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic.denserank;

import com.questdb.common.Record;
import com.questdb.ql.analytic.denserank.AbstractRankOrderedAnalyticFunction;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.LongResolver;
import com.questdb.ql.map.MapUtils;
import com.questdb.ql.map.VirtualColumnTypeResolver;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.std.ThreadLocal;
import java.io.IOException;

public class DenseRankOPAnalyticFunction
extends AbstractRankOrderedAnalyticFunction {
    private static final ThreadLocal<VirtualColumnTypeResolver> tlPartitionByTypeResolver = new VirtualColumnTypeResolver.ResolverThreadLocal();
    private final DirectMap partitionMap;
    private final ObjList<VirtualColumn> partitionBy;

    public DenseRankOPAnalyticFunction(int pageSize, String name, ObjList<VirtualColumn> partitionBy) {
        super(pageSize, name);
        this.partitionMap = new DirectMap(pageSize, ((VirtualColumnTypeResolver)tlPartitionByTypeResolver.get()).of(partitionBy), LongResolver.INSTANCE);
        this.partitionBy = partitionBy;
    }

    @Override
    public void add(Record record) {
        long rank;
        long row = record.getRowId();
        DirectMapValues values = MapUtils.getMapValues(this.partitionMap, record, this.partitionBy);
        if (values.isNew()) {
            rank = 0L;
            values.putLong(0, 0L);
        } else {
            rank = values.getLong(0) + 1L;
            values.putLong(0, rank);
        }
        this.map.locate(row);
        this.map.getOrCreateValues().putLong(0, rank);
    }

    @Override
    public void close() throws IOException {
        super.close();
        Misc.free(this.partitionMap);
    }

    @Override
    public void reset() {
        super.reset();
        this.partitionMap.clear();
    }
}

