/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic.denserank;

import com.questdb.common.Record;
import com.questdb.ql.analytic.denserank.AbstractRankAnalyticFunction;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.LongResolver;
import com.questdb.ql.map.MapUtils;
import com.questdb.ql.map.VirtualColumnTypeResolver;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.ObjList;
import com.questdb.std.ThreadLocal;
import java.io.Closeable;
import java.io.IOException;

public class DenseRankPartitionedAnalyticFunction
extends AbstractRankAnalyticFunction
implements Closeable {
    private static final ThreadLocal<VirtualColumnTypeResolver> tlPartitionByTypeResolver = new VirtualColumnTypeResolver.ResolverThreadLocal();
    private final DirectMap map;
    private final ObjList<VirtualColumn> partitionBy;

    public DenseRankPartitionedAnalyticFunction(int pageSize, String name, ObjList<VirtualColumn> partitionBy) {
        super(name);
        this.partitionBy = partitionBy;
        this.map = new DirectMap(pageSize, ((VirtualColumnTypeResolver)tlPartitionByTypeResolver.get()).of(partitionBy), LongResolver.INSTANCE);
    }

    @Override
    public void close() throws IOException {
        this.map.close();
    }

    @Override
    public void prepareFor(Record rec) {
        DirectMapValues values = MapUtils.getMapValues(this.map, rec, this.partitionBy);
        if (values.isNew()) {
            this.rank = 0L;
            values.putLong(0, 1L);
        } else {
            this.rank = values.getLong(0);
            values.putLong(0, this.rank + 1L);
        }
    }

    @Override
    public void reset() {
        this.map.clear();
    }

    @Override
    public void toTop() {
        this.reset();
    }
}

