/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic.next;

import com.questdb.common.Record;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.common.RecordCursor;
import com.questdb.common.SymbolTable;
import com.questdb.ql.NullRecord;
import com.questdb.ql.analytic.AnalyticFunction;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.MemoryPages;
import com.questdb.std.Misc;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import java.io.Closeable;

public abstract class AbstractNextAnalyticFunction
implements AnalyticFunction,
Closeable {
    protected final MemoryPages pages;
    private final VirtualColumn valueColumn;
    private long offset;
    private Record record;
    private Record next;
    private RecordCursor baseCursor;

    public AbstractNextAnalyticFunction(int pageSize, VirtualColumn valueColumn) {
        this.pages = new MemoryPages(pageSize);
        this.valueColumn = valueColumn;
    }

    @Override
    public void close() {
        Misc.free(this.pages);
    }

    @Override
    public byte get() {
        return this.valueColumn.get(this.next);
    }

    @Override
    public boolean getBool() {
        return this.valueColumn.getBool(this.next);
    }

    @Override
    public long getDate() {
        return this.valueColumn.getDate(this.next);
    }

    @Override
    public double getDouble() {
        return this.valueColumn.getDouble(this.next);
    }

    @Override
    public float getFloat() {
        return this.valueColumn.getFloat(this.next);
    }

    @Override
    public CharSequence getFlyweightStr() {
        return this.valueColumn.getFlyweightStr(this.next);
    }

    @Override
    public CharSequence getFlyweightStrB() {
        return this.valueColumn.getFlyweightStrB(this.next);
    }

    @Override
    public int getInt() {
        return this.next == NullRecord.INSTANCE && this.valueColumn.getType() == 8 ? -1 : this.valueColumn.getInt(this.next);
    }

    @Override
    public long getLong() {
        return this.valueColumn.getLong(this.next);
    }

    @Override
    public RecordColumnMetadata getMetadata() {
        return this.valueColumn;
    }

    @Override
    public short getShort() {
        return this.valueColumn.getShort(this.next);
    }

    @Override
    public void getStr(CharSink sink) {
        this.valueColumn.getStr(this.next, sink);
    }

    @Override
    public int getStrLen() {
        return this.valueColumn.getStrLen(this.next);
    }

    @Override
    public String getSym() {
        return this.next instanceof NullRecord ? null : this.valueColumn.getSymbolTable().value(this.getInt());
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.valueColumn.getSymbolTable();
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void prepare(RecordCursor cursor) {
        this.baseCursor = cursor;
        this.record = cursor.newRecord();
        this.valueColumn.prepare(cursor.getStorageFacade());
        this.offset = 0L;
    }

    @Override
    public void prepareFor(Record rec) {
        long rowid = Unsafe.getUnsafe().getLong(this.pages.addressOf(this.offset));
        if (rowid == -1L) {
            this.next = NullRecord.INSTANCE;
        } else {
            this.baseCursor.recordAt(this.record, rowid);
            this.next = this.record;
        }
        this.offset += 8L;
    }

    @Override
    public void reset() {
        this.pages.clear();
    }

    @Override
    public void toTop() {
        this.offset = 0L;
    }
}

