/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic.next;

import com.questdb.common.Record;
import com.questdb.ql.analytic.next.AbstractNextAnalyticFunction;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.Unsafe;

public class NextAnalyticFunction
extends AbstractNextAnalyticFunction {
    private long prevAddress = -1L;

    public NextAnalyticFunction(int pageSize, VirtualColumn valueColumn) {
        super(pageSize, valueColumn);
    }

    @Override
    public void add(Record record) {
        if (this.prevAddress != -1L) {
            Unsafe.getUnsafe().putLong(this.prevAddress, record.getRowId());
        }
        this.prevAddress = this.pages.allocate(8L);
        Unsafe.getUnsafe().putLong(this.prevAddress, -1L);
    }

    @Override
    public void reset() {
        super.reset();
        this.prevAddress = -1L;
    }

    @Override
    public void toTop() {
        super.toTop();
        this.prevAddress = -1L;
    }
}

