/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic.next;

import com.questdb.common.Record;
import com.questdb.ql.analytic.AbstractOrderedAnalyticFunction;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.LongResolver;
import com.questdb.ql.map.MapUtils;
import com.questdb.ql.map.VirtualColumnTypeResolver;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.std.ThreadLocal;
import java.io.IOException;

public class NextOrderedPartitionedAnalyticFunction
extends AbstractOrderedAnalyticFunction {
    private static final ThreadLocal<VirtualColumnTypeResolver> tlPartitionByTypeResolver = new VirtualColumnTypeResolver.ResolverThreadLocal();
    private final DirectMap prevMap;
    private final ObjList<VirtualColumn> partitionBy;

    public NextOrderedPartitionedAnalyticFunction(int pageSize, ObjList<VirtualColumn> partitionBy, VirtualColumn valueColumn) {
        super(pageSize, valueColumn);
        this.prevMap = new DirectMap(pageSize, ((VirtualColumnTypeResolver)tlPartitionByTypeResolver.get()).of(partitionBy), LongResolver.INSTANCE);
        this.partitionBy = partitionBy;
    }

    @Override
    public void add(Record record) {
        long row = record.getRowId();
        DirectMapValues prevValues = MapUtils.getMapValues(this.prevMap, record, this.partitionBy);
        if (!prevValues.isNew()) {
            this.map.locate(prevValues.getLong(0));
            this.map.getOrCreateValues().putLong(0, row);
        }
        prevValues.putLong(0, row);
    }

    @Override
    public void toTop() {
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        Misc.free(this.prevMap);
        super.close();
    }

    @Override
    public void reset() {
        this.prevMap.clear();
        super.reset();
    }
}

